/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.exposure;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.radiation.IRadiationExposureSystem;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.api.radiation.IRadioactiveItem;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.map.MapSystem;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.DataMap;
import com.builtbroken.atomic.map.events.MapSystemEvent;
import com.builtbroken.atomic.map.exposure.RadSourceWrapper;
import com.builtbroken.atomic.map.exposure.wrapper.RadSourceEntityItem;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class RadiationMap
extends MapSystem
implements IRadiationExposureSystem {
    private HashMap<IRadiationSource, RadSourceWrapper> radiationSourceMap = new HashMap();
    private HashMap<Entity, IRadiationSource> radiationEntityMap = new HashMap();
    private HashMap<Class<? extends Entity>, Function<Entity, IRadiationSource>> wrapperFactories = new HashMap();

    public RadiationMap() {
        super("atomicscience:radiation_exposure", null);
        this.wrapperFactories.put(EntityItem.class, e -> RadSourceEntityItem.build((EntityItem)e));
    }

    public void addSource(IRadiationSource source) {
        if (source != null && source.isRadioactive() && !this.radiationSourceMap.containsKey(source)) {
            this.radiationSourceMap.put(source, new RadSourceWrapper(source));
            this.onSourceAdded(source);
        }
    }

    public void addSource(Entity entity) {
        IRadiationSource source;
        if (entity != null && entity.func_70089_S() && !this.radiationEntityMap.containsKey(entity) && (source = this.getSource(entity)) != null) {
            this.addSource(source);
            this.radiationEntityMap.put(entity, source);
        }
    }

    public void removeSource(IRadiationSource source) {
        if (this.radiationSourceMap.containsKey(source)) {
            this.onSourceRemoved(source);
            this.radiationSourceMap.remove(source);
        }
    }

    public void removeSource(Entity entity) {
        if (this.radiationEntityMap.containsKey(entity)) {
            this.removeSource(this.radiationEntityMap.get(entity));
            this.radiationEntityMap.remove(entity);
        }
    }

    protected void onSourceAdded(IRadiationSource source) {
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.info("RadiationMap: adding source " + source);
        }
        this.fireSourceChange(source, source.getRadioactiveMaterial());
    }

    protected void onSourceRemoved(IRadiationSource source) {
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.info("RadiationMap: remove source " + source);
        }
        this.fireSourceChange(source, 0);
    }

    public void clearDeadSources() {
        Iterator<Map.Entry<IRadiationSource, RadSourceWrapper>> it = this.radiationSourceMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IRadiationSource, RadSourceWrapper> next = it.next();
            if (next != null && next.getKey() != null && next.getValue() != null && next.getKey().isRadioactive()) continue;
            if (next.getKey() != null) {
                this.onSourceRemoved(next.getKey());
            }
            it.remove();
        }
    }

    protected void fireSourceChange(IRadiationSource source, int newValue) {
        RadSourceWrapper wrapper;
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.info("RadiationMap: on changed " + source);
        }
        if ((wrapper = this.getRadSourceWrapper(source)) != null && wrapper.radioactiveMaterialValue != newValue) {
            if (wrapper.radioactiveMaterialValue != 0) {
                MapHandler.THREAD_RAD_EXPOSURE.queuePosition(DataChange.get(wrapper.dim, wrapper.xi(), wrapper.yi(), wrapper.zi(), wrapper.radioactiveMaterialValue, 0));
            }
            wrapper.logCurrentData();
            if (newValue != 0 && source.isRadioactive()) {
                MapHandler.THREAD_RAD_EXPOSURE.queuePosition(DataChange.get(wrapper.dim, wrapper.xi(), wrapper.yi(), wrapper.zi(), 0, newValue));
            }
        }
    }

    protected RadSourceWrapper getRadSourceWrapper(IRadiationSource source) {
        if (this.radiationSourceMap.containsKey(source)) {
            RadSourceWrapper wrapper = this.radiationSourceMap.get(source);
            if (wrapper == null) {
                wrapper = new RadSourceWrapper(source);
                this.radiationSourceMap.put(source, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    public IRadiationSource getSource(Entity entity) {
        if (entity instanceof IRadiationSource) {
            return (IRadiationSource)entity;
        }
        Class<?> clazz = entity.getClass();
        if (this.wrapperFactories.containsKey(clazz)) {
            return this.wrapperFactories.get(clazz).apply(entity);
        }
        return null;
    }

    public int getRadLevel(World world, int x, int y, int z) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            return map.getData(x, y, z);
        }
        return 0;
    }

    public float getRemExposure(Entity entity) {
        float value = 0.0f;
        value += (float)this.getRadLevel(entity.field_70170_p, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u + (double)entity.field_70131_O), (int)Math.floor(entity.field_70161_v));
        value += (float)this.getRadLevel(entity.field_70170_p, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u + (double)(entity.field_70131_O / 2.0f)), (int)Math.floor(entity.field_70161_v));
        value += (float)this.getRadLevel(entity.field_70170_p, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
        value /= 3.0f;
        return value /= 1000.0f;
    }

    @Override
    public void onWorldUnload(World world) {
        super.onWorldUnload(world);
        this.radiationSourceMap.clear();
        this.radiationEntityMap.clear();
    }

    @SubscribeEvent
    public void onChunkAdded(MapSystemEvent.AddChunk event) {
        if (event.world() != null && event.world().field_72995_K && event.map.mapSystem == MapHandler.MATERIAL_MAP) {
            MapHandler.THREAD_RAD_EXPOSURE.queueChunkForAddition(event.chunk);
        }
    }

    @SubscribeEvent
    public void onChunkRemove(MapSystemEvent.RemoveChunk event) {
        if (event.world() != null && event.world().field_72995_K && event.map.mapSystem == MapHandler.MATERIAL_MAP) {
            MapHandler.THREAD_RAD_EXPOSURE.queueChunkForRemoval(event.chunk);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRadiationChange(MapSystemEvent.UpdateValue event) {
        if (event.world() != null && !event.world().field_72995_K && event.map.mapSystem == MapHandler.MATERIAL_MAP && event.prev_value != event.new_value) {
            MapHandler.THREAD_RAD_EXPOSURE.queuePosition(DataChange.get(event.dim(), event.x, event.y, event.z, event.prev_value, event.new_value));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.clearDeadSources();
            for (RadSourceWrapper wrapper : this.radiationSourceMap.values()) {
                if (!wrapper.hasSourceChanged()) continue;
                this.fireSourceChange((IRadiationSource)wrapper.source, ((IRadiationSource)wrapper.source).getRadioactiveMaterial());
            }
        }
    }

    @SubscribeEvent
    public void itemPickUpEvent(PlayerEvent.ItemPickupEvent event) {
        ItemStack stack;
        EntityItem entityItem;
        if (!event.player.field_70170_p.field_72995_K && (entityItem = event.pickedUp) != null && (stack = entityItem.func_92059_d()) != null && stack.func_77973_b() instanceof IRadioactiveItem) {
            this.removeSource((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity.func_70089_S()) {
            this.addSource(event.entity);
        }
    }
}

