/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.exposure;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.config.ConfigRadiation;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.DataMap;
import com.builtbroken.atomic.map.data.ThreadDataChange;
import com.builtbroken.atomic.map.exposure.RadiationMap;
import com.builtbroken.jlib.lang.StringHelpers;

public class ThreadRadExposure
extends ThreadDataChange {
    public ThreadRadExposure() {
        super("ThreadRadExposure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateLocation(DataChange change) {
        DataMap map;
        RadiationMap radiationMap = MapHandler.RADIATION_MAP;
        synchronized (radiationMap) {
            map = MapHandler.RADIATION_MAP.getMap(change.dim, true);
        }
        long time = System.nanoTime();
        this.updateValue(map, change.old_value, change.xi(), change.yi(), change.zi(), true);
        this.updateValue(map, change.new_value, change.xi(), change.yi(), change.zi(), false);
        if (AtomicScience.runningAsDev) {
            time = System.nanoTime() - time;
            AtomicScience.logger.info(String.format("ThreadRadExposure: %sx %sy %sz | %so %sn | took %s", change.x, change.y, change.z, change.old_value, change.new_value, StringHelpers.formatNanoTime(time)));
        }
    }

    protected boolean updateValue(DataMap map, int value, int cx, int cy, int cz, boolean remove) {
        if (value > 0) {
            int rad = this.getRadFromMaterial(value);
            int edit_range = Math.min(ConfigRadiation.MAX_UPDATE_RANGE, (int)Math.floor(this.getDecayRange(rad)));
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.info(String.format("ThreadRadExposure: updateValue(map, %smat, %sx %sy %sz, %s) | %srad | %sm", value, cx, cy, cz, remove, rad, edit_range));
            }
            int startX = cx - edit_range;
            int startY = Math.max(0, cy - edit_range);
            int startZ = cz - edit_range;
            int endX = cx + edit_range + 1;
            int endY = Math.min(255, cy + edit_range + 1);
            int endZ = cz + edit_range + 1;
            for (int x = startX; x < endX; ++x) {
                for (int y = startY; y < endY; ++y) {
                    for (int z = startZ; z < endZ; ++z) {
                        if (!this.shouldRun) {
                            return false;
                        }
                        int dx = x - cx;
                        int dy = y - cy;
                        int dz = z - cz;
                        double distanceSQ = dx * dx + dz * dz + dy * dy;
                        int current_value = map.getData(x, y, z);
                        int change = this.getRadForDistance(rad, distanceSQ);
                        current_value = remove ? (current_value -= change) : (current_value += change);
                        if (!map.blockExists(x, y, z)) continue;
                        map.setData(x, y, z, Math.max(0, current_value));
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected int getRadFromMaterial(int material_amount) {
        return (int)Math.ceil((float)material_amount * ConfigRadiation.MAP_VALUE_TO_MILI_RAD);
    }

    protected int getRadForDistance(int power, double distanceSQ) {
        if (distanceSQ < 1.0) {
            return power;
        }
        return (int)Math.floor((double)power / distanceSQ);
    }

    protected double getDecayRange(int value) {
        double power = value;
        double distance = 1.0;
        while (power > 1.0) {
            power = this.getRadForDistance(value, distance += 0.5);
        }
        return distance;
    }
}

