/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.thermal.IHeatSource;
import com.builtbroken.atomic.api.thermal.IThermalSystem;
import com.builtbroken.atomic.config.ConfigNetwork;
import com.builtbroken.atomic.lib.MassHandler;
import com.builtbroken.atomic.lib.network.netty.PacketSystem;
import com.builtbroken.atomic.lib.network.packet.client.PacketSpawnParticle;
import com.builtbroken.atomic.lib.thermal.ThermalHandler;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.map.MapSystem;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.DataMap;
import com.builtbroken.atomic.map.data.DataPos;
import com.builtbroken.atomic.map.events.MapSystemEvent;
import com.builtbroken.atomic.map.thermal.ThermalMapChange;
import com.builtbroken.atomic.map.thermal.ThermalSourceWrapper;
import com.builtbroken.jlib.lang.StringHelpers;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ThermalMap
extends MapSystem
implements IThermalSystem {
    private HashMap<IHeatSource, ThermalSourceWrapper> thermalSourceMap = new HashMap();
    private HashMap<Integer, HashSet<DataPos>> steamSources = new HashMap();
    public ConcurrentLinkedQueue<ThermalMapChange> dataFromThread = new ConcurrentLinkedQueue();

    public ThermalMap() {
        super("atomicscience:thermal", null);
    }

    public void addSource(IHeatSource source) {
        if (source != null && source.canGeneratingHeat() && !this.thermalSourceMap.containsKey(source)) {
            this.thermalSourceMap.put(source, new ThermalSourceWrapper(source));
            this.onSourceAdded(source);
        }
    }

    public void removeSource(IHeatSource source) {
        if (this.thermalSourceMap.containsKey(source)) {
            this.onSourceRemoved(source);
            this.thermalSourceMap.remove(source);
        }
    }

    protected void onSourceAdded(IHeatSource source) {
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.info("ThermalMap: adding source " + source);
        }
        this.fireSourceChange(source, source.getHeatGenerated());
    }

    protected void onSourceRemoved(IHeatSource source) {
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.info("ThermalMap: remove source " + source);
        }
        this.fireSourceChange(source, 0);
    }

    public void clearDeadSources() {
        Iterator<Map.Entry<IHeatSource, ThermalSourceWrapper>> it = this.thermalSourceMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IHeatSource, ThermalSourceWrapper> next = it.next();
            if (next != null && next.getKey() != null && next.getValue() != null && next.getKey().canGeneratingHeat()) continue;
            if (next.getKey() != null) {
                this.onSourceRemoved(next.getKey());
            }
            it.remove();
        }
    }

    protected void fireSourceChange(IHeatSource source, int newValue) {
        ThermalSourceWrapper wrapper;
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.info("ThermalMap: on changed " + source);
        }
        if ((wrapper = this.getRadSourceWrapper(source)) != null && wrapper.heatValue != newValue) {
            if (wrapper.heatValue != 0) {
                MapHandler.THREAD_THERMAL_ACTION.queuePosition(DataChange.get(wrapper.dim, wrapper.xi(), wrapper.yi(), wrapper.zi(), wrapper.heatValue, 0));
            }
            wrapper.logCurrentData();
            if (newValue != 0 && source.canGeneratingHeat()) {
                MapHandler.THREAD_THERMAL_ACTION.queuePosition(DataChange.get(wrapper.dim, wrapper.xi(), wrapper.yi(), wrapper.zi(), 0, newValue));
            }
        }
    }

    protected ThermalSourceWrapper getRadSourceWrapper(IHeatSource source) {
        if (this.thermalSourceMap.containsKey(source)) {
            ThermalSourceWrapper wrapper = this.thermalSourceMap.get(source);
            if (wrapper == null) {
                wrapper = new ThermalSourceWrapper(source);
                this.thermalSourceMap.put(source, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    public long getJoules(World world, int x, int y, int z) {
        return (long)this.getData(world, x, y, z) * 1000L;
    }

    public long getActualJoules(World world, int x, int y, int z) {
        return this.getJoules(world, x, y, z) + this.getEnvironmentalJoules(world, x, y, z);
    }

    public double getTemperature(World world, int x, int y, int z) {
        return this.getTemperature(world, x, y, z, this.getActualJoules(world, x, y, z));
    }

    public double getTemperature(World world, int x, int y, int z, double joules) {
        return joules / (double)(MassHandler.getMass(world, x, y, z) * ThermalHandler.getSpecificHeat(world, x, y, z) * 1000.0f);
    }

    public double getTemperatureDelta(World world, int x, int y, int z, int i, int j, int k) {
        return this.getTemperature(world, x, y, z) - this.getTemperature(world, i, j, k);
    }

    public long getEnvironmentalJoules(World world, int x, int y, int z) {
        return (long)Math.floor(this.getEnvironmentalTemperature(world, x, y, z) * (double)MassHandler.getMass(world, x, y, z) * (double)ThermalHandler.getSpecificHeat(world, x, y, z)) * 1000L;
    }

    public double getEnvironmentalTemperature(World world, int x, int y, int z) {
        return 290.0;
    }

    @Override
    public void onWorldUnload(World world) {
        super.onWorldUnload(world);
        this.thermalSourceMap.clear();
        this.steamSources.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHeatChanged(MapSystemEvent.UpdateValue event) {
        World world = event.world();
        DataMap map = this.getMap(world, false);
        if (world != null && map != null && map.blockExists(event.x, event.y, event.z)) {
            this.checkForThermalChange(world, event.x, event.y, event.z, event.new_value);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(PlayerInteractEvent event) {
        if (!event.world.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            this.checkForThermalChange(event.world, event.x, event.y, event.z, this.getData(event.world, event.x, event.y, event.z));
        }
    }

    protected void checkForThermalChange(World world, int x, int y, int z, int heat) {
        long joules;
        if (ThermalHandler.canChangeStates(world, x, y, z) && (joules = (long)(heat * 1000) + this.getEnvironmentalJoules(world, x, y, z)) > ThermalHandler.energyCostToChangeStates(world, x, y, z)) {
            ThermalHandler.changeStates(world, x, y, z);
        }
        int vap = ThermalHandler.getVaporRate(world, x, y, z, (long)(heat * 1000) + this.getEnvironmentalJoules(world, x, y, z));
        DataPos pos = DataPos.get(x, y, z);
        int dim = world.field_73011_w.field_76574_g;
        if (!this.steamSources.containsKey(dim)) {
            this.steamSources.put(dim, new HashSet());
        }
        if (vap > 0) {
            if (!this.steamSources.get(dim).contains(pos)) {
                this.steamSources.get(dim).add(pos);
            } else {
                pos.dispose();
            }
        }
        if (!this.steamSources.get(dim).contains(pos)) {
            this.steamSources.remove(pos);
            pos.dispose();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.clearDeadSources();
            for (ThermalSourceWrapper wrapper : this.thermalSourceMap.values()) {
                if (!wrapper.hasSourceChanged()) continue;
                this.fireSourceChange((IHeatSource)wrapper.source, ((IHeatSource)wrapper.source).getHeatGenerated());
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        block6: {
            block5: {
                if (event.phase != TickEvent.Phase.START) break block5;
                long time = System.currentTimeMillis();
                while (!this.dataFromThread.isEmpty() && System.currentTimeMillis() - time < 10L) {
                    ThermalMapChange change = this.dataFromThread.poll();
                    if (change == null) continue;
                    long t = System.nanoTime();
                    change.pop();
                    t = System.nanoTime() - t;
                    AtomicScience.logger.info("ThermalMap: Dumped data from thread to map. Data size: " + change.size + " Time: " + StringHelpers.formatNanoTime(t));
                }
                break block6;
            }
            if (event.phase != TickEvent.Phase.END) break block6;
            World world = event.world;
            int dim = world.field_73011_w.field_76574_g;
            if (ConfigNetwork.BOILING_EFFECT && this.steamSources.containsKey(dim)) {
                HashSet<DataPos> steamPositions = this.steamSources.get(dim);
                Iterator<DataPos> it = steamPositions.iterator();
                while (it.hasNext()) {
                    DataPos pos = it.next();
                    if (world.func_72899_e(pos.x, pos.y, pos.z)) {
                        int vap = ThermalHandler.getVaporRate(world, pos.x, pos.y, pos.z);
                        if (vap > 0) {
                            int count = Math.min(10, Math.max(1, vap / 100));
                            PacketSpawnParticle packetSpawnParticle = new PacketSpawnParticle(dim, (double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, 0.0, 0.0, 0.0, "boiling;" + count);
                            PacketSystem.INSTANCE.sendToAllAround(packetSpawnParticle, world, pos, 30.0);
                            continue;
                        }
                        it.remove();
                        pos.dispose();
                        continue;
                    }
                    it.remove();
                    pos.dispose();
                }
            }
        }
    }
}

