/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.lib.thermal.HeatSpreadDirection;
import com.builtbroken.atomic.lib.thermal.ThermalHandler;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.DataMap;
import com.builtbroken.atomic.map.data.DataPos;
import com.builtbroken.atomic.map.data.ThreadDataChange;
import com.builtbroken.atomic.map.thermal.ThermalMap;
import com.builtbroken.atomic.map.thermal.ThermalMapChange;
import com.builtbroken.jlib.lang.StringHelpers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ThreadThermalAction
extends ThreadDataChange {
    public ThreadThermalAction() {
        super("ThreadThermalAction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateLocation(DataChange change) {
        DataMap map;
        ThermalMap thermalMap = MapHandler.THERMAL_MAP;
        synchronized (thermalMap) {
            map = MapHandler.THERMAL_MAP.getMap(change.dim, true);
        }
        int cx = change.xi();
        int cy = change.yi();
        int cz = change.zi();
        HashMap<DataPos, DataPos> old_data = this.calculateHeatSpread(map, cx, cy, cz, change.old_value);
        HashMap<DataPos, DataPos> new_data = this.calculateHeatSpread(map, cx, cy, cz, change.new_value);
        ThermalMapChange mapChange = new ThermalMapChange(map, old_data, new_data);
        MapHandler.THERMAL_MAP.dataFromThread.add(mapChange);
    }

    protected HashMap<DataPos, DataPos> calculateHeatSpread(DataMap map, int cx, int cy, int cz, int heat) {
        int range = 50;
        HashMap<DataPos, DataPos> heatSpreadData = new HashMap<DataPos, DataPos>();
        long time = System.nanoTime();
        if (heat > 6) {
            LinkedList<DataPos> pathNext = new LinkedList<DataPos>();
            DataPos centerPos = DataPos.get(cx, cy, cz);
            heatSpreadData.put(centerPos, DataPos.get(heat, 0, 0));
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                DataPos pos = DataPos.get(cx, cy, cz, direction);
                pathNext.add(pos);
                heatSpreadData.put(pos, DataPos.get(0, 0, 0));
            }
            ArrayList<DataPos> tempHold = new ArrayList<DataPos>(6);
            while (!pathNext.isEmpty()) {
                DataPos currentPos = (DataPos)pathNext.poll();
                int heatAsPosition = 0;
                double heatRateTotal = 0.0;
                for (HeatSpreadDirection direction : HeatSpreadDirection.values()) {
                    int x = currentPos.x + direction.offsetX;
                    int y = currentPos.y + direction.offsetY;
                    int z = currentPos.z + direction.offsetZ;
                    if (!this.inRange(cx, cy, cz, x, y, z, 50) || y < 0 || y >= 256) continue;
                    heatRateTotal += ThermalHandler.getHeatTransferRate(map.getWorld(), x, y, z);
                }
                for (HeatSpreadDirection direction : HeatSpreadDirection.values()) {
                    DataPos pos = DataPos.get(currentPos.x + direction.offsetX, currentPos.y + direction.offsetY, currentPos.z + direction.offsetZ);
                    if (this.inRange(cx, cy, cz, pos.x, pos.y, pos.z, 50) && pos.y >= 0 && pos.y < 256) {
                        if (!heatSpreadData.containsKey(pos)) {
                            if (direction.ordinal() >= 6) continue;
                            tempHold.add(pos);
                            continue;
                        }
                        int heatAtNext = heatSpreadData.get((Object)pos).x;
                        double transferRate = ThermalHandler.getHeatTransferRate(map.getWorld(), pos.x, pos.y, pos.z);
                        double percentage = transferRate / heatRateTotal;
                        int heatMoved = this.getHeatToSpread(map, pos, currentPos, heatAtNext, percentage * (double)direction.percentage, heatSpreadData);
                        heatSpreadData.get((Object)pos).y += heatMoved;
                        heatAsPosition += heatMoved;
                        pos.dispose();
                        continue;
                    }
                    pos.dispose();
                }
                if (heatAsPosition > 0) {
                    pathNext.addAll(tempHold);
                    tempHold.forEach(e -> heatSpreadData.put((DataPos)e, DataPos.get(0, 0, 0)));
                } else {
                    tempHold.forEach(e -> e.dispose());
                }
                tempHold.clear();
                heatSpreadData.get((Object)currentPos).x = heatAsPosition;
            }
        }
        if (AtomicScience.runningAsDev) {
            time = System.nanoTime() - time;
            AtomicScience.logger.info(String.format("%s: Spread heat %s | %s tiles | %s %s %s | in %s", this.name, heat, heatSpreadData.size(), cx, cy, cz, StringHelpers.formatNanoTime(time)));
        }
        return heatSpreadData;
    }

    protected int getHeatToSpread(DataMap map, DataPos heatSource, DataPos heatTarget, int heatToMove, double percentage, HashMap<DataPos, DataPos> heatSpreadData) {
        if (map.blockExists(heatTarget.x, heatTarget.y, heatTarget.z)) {
            return this.getHeatSpread(map.getWorld(), heatSource, heatTarget, (int)Math.floor((double)heatToMove * percentage), heatSpreadData);
        }
        return heatToMove;
    }

    public int getHeatSpread(World world, DataPos heatSource, DataPos heatTarget, int heat, HashMap<DataPos, DataPos> heatSpreadData) {
        double deltaTemp = this.getTemperature(world, heatSource, heatSpreadData);
        if (deltaTemp > 0.0) {
            double heatMovementRate1 = ThermalHandler.getHeatTransferRate(world, heatTarget.x, heatTarget.y, heatTarget.z) * deltaTemp;
            return (int)Math.min(heatMovementRate1 * 20.0 * 60.0, (double)heat);
        }
        return 0;
    }

    public double getTemperature(World world, DataPos pos, HashMap<DataPos, DataPos> heatSpreadData) {
        if (heatSpreadData.containsKey(pos)) {
            return MapHandler.THERMAL_MAP.getTemperature(world, pos.x, pos.y, pos.z, (long)heatSpreadData.get((Object)pos).x * 1000L);
        }
        return 0.0;
    }
}

