/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import cofh.api.energy.IEnergyContainerItem;
import com.flansmod.api.IControllable;
import com.flansmod.api.IExplodeable;
import com.flansmod.client.EntityCamera;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.raytracing.BulletHit;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.network.PacketDriveableDamage;
import com.flansmod.common.network.PacketDriveableKeyHeld;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityDriveable
extends Entity
implements IControllable,
IExplodeable,
IEntityAdditionalSpawnData {
    public boolean syncFromServer = true;
    public int serverPositionTransitionTicker;
    public double field_70118_ct;
    public double field_70117_cu;
    public double field_70116_cv;
    public double serverYaw;
    public double serverPitch;
    public double serverRoll;
    public DriveableData driveableData;
    public String driveableType;
    public float throttle;
    public EntityWheel[] wheels;
    public boolean fuelling;
    public float prevRotationRoll;
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean leftMouseHeld = false;
    public boolean rightMouseHeld = false;
    public int shootDelayPrimary;
    public int shootDelaySecondary;
    public float minigunSpeedPrimary;
    public float minigunSpeedSecondary;
    public int currentGunPrimary;
    public int currentGunSecondary;
    public float harvesterAngle;
    public RotatedAxes prevAxes;
    public RotatedAxes axes = new RotatedAxes();
    public EntitySeat[] seats;
    private int foundFuel = -1;
    public boolean couldNotFindFuel = false;
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase camera;

    public EntityDriveable(World world) {
        super(world);
        this.prevAxes = new RotatedAxes();
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70129_M = 0.375f;
        this.field_70158_ak = true;
        this.field_70155_l = 200.0;
    }

    public EntityDriveable(World world, DriveableType t, DriveableData d) {
        this(world);
        this.driveableType = t.shortName;
        this.driveableData = d;
    }

    protected void initType(DriveableType type, boolean clientSide) {
        int i;
        this.seats = new EntitySeat[type.numPassengers + 1];
        for (i = 0; i < type.numPassengers + 1; ++i) {
            if (clientSide) continue;
            this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
            this.field_70170_p.func_72838_d((Entity)this.seats[i]);
        }
        this.wheels = new EntityWheel[type.wheelPositions.length];
        for (i = 0; i < this.wheels.length; ++i) {
            if (clientSide) continue;
            this.wheels[i] = new EntityWheel(this.field_70170_p, this, i);
            this.field_70170_p.func_72838_d((Entity)this.wheels[i]);
        }
        this.field_70138_W = type.wheelStepHeight;
        this.field_70129_M = type.yOffset;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        this.driveableData.writeToNBT(tag);
        tag.func_74778_a("Type", this.driveableType);
        tag.func_74776_a("RotationYaw", this.axes.getYaw());
        tag.func_74776_a("RotationPitch", this.axes.getPitch());
        tag.func_74776_a("RotationRoll", this.axes.getRoll());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.driveableType = tag.func_74779_i("Type");
        this.driveableData = new DriveableData(tag);
        this.initType(DriveableType.getDriveable(this.driveableType), false);
        this.field_70126_B = tag.func_74760_g("RotationYaw");
        this.field_70127_C = tag.func_74760_g("RotationPitch");
        this.prevRotationRoll = tag.func_74760_g("RotationRoll");
        this.axes = new RotatedAxes(this.field_70126_B, this.field_70127_C, this.prevRotationRoll);
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.driveableType);
        NBTTagCompound tag = new NBTTagCompound();
        this.driveableData.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tag);
        data.writeFloat(this.axes.getYaw());
        data.writeFloat(this.axes.getPitch());
        data.writeFloat(this.axes.getRoll());
        for (EnumDriveablePart ep : EnumDriveablePart.values()) {
            DriveablePart part = this.getDriveableData().parts.get((Object)ep);
            data.writeShort((int)((short)part.health));
            data.writeBoolean(part.onFire);
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.driveableType = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.driveableData = new DriveableData(ByteBufUtils.readTag((ByteBuf)data));
            this.initType(this.getDriveableType(), true);
            this.axes.setAngles(data.readFloat(), data.readFloat(), data.readFloat());
            this.field_70126_B = this.axes.getYaw();
            this.field_70127_C = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                part.health = data.readShort();
                part.onFire = data.readBoolean();
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to retreive plane type from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
        this.camera = new EntityCamera(this.field_70170_p, this);
        this.field_70170_p.func_72838_d((Entity)this.camera);
    }

    @Override
    public abstract void onMouseMoved(int var1, int var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return this.camera;
    }

    protected boolean canSit(int seat) {
        return this.getDriveableType().numPassengers >= seat && this.seats[seat].field_70153_n == null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return -0.3;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        return this.field_70170_p.field_72995_K || this.field_70128_L || this.attackPart(EnumDriveablePart.core, damagesource, i);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.camera.func_70106_y();
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.func_70106_y();
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
        if (!this.isPartOfThis(entity)) {
            super.func_70108_f(entity);
        }
    }

    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (this.field_70173_aa > 1) {
            return;
        }
        if (!(this.field_70153_n instanceof EntityPlayer) || !FlansMod.proxy.isThePlayer((EntityPlayer)this.field_70153_n)) {
            if (this.syncFromServer) {
                this.serverPositionTransitionTicker = i + 5;
            } else {
                double var10 = d - this.field_70165_t;
                double var12 = d1 - this.field_70163_u;
                double var14 = d2 - this.field_70161_v;
                double var16 = var10 * var10 + var12 * var12 + var14 * var14;
                if (var16 <= 1.0) {
                    return;
                }
                this.serverPositionTransitionTicker = 3;
            }
            this.field_70118_ct = d;
            this.field_70117_cu = d1;
            this.field_70116_cv = d2;
            this.serverYaw = f;
            this.serverPitch = f1;
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt, float steeringYaw) {
        if (this.field_70170_p.field_72995_K) {
            this.field_70118_ct = x;
            this.field_70117_cu = y;
            this.field_70116_cv = z;
            this.serverYaw = yaw;
            this.serverPitch = pitch;
            this.serverRoll = roll;
            this.serverPositionTransitionTicker = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.field_70126_B = yaw;
            this.field_70127_C = pitch;
            this.prevRotationRoll = roll;
            this.setRotation(yaw, pitch, roll);
        }
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
        this.angularVelocity = new Vector3f(velYaw, velPitch, velRoll);
        this.throttle = throt;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && key == 9 && this.getDriveableType().modePrimary == EnumFireMode.SEMIAUTO) {
            this.shoot(false);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && key == 8 && this.getDriveableType().modeSecondary == EnumFireMode.SEMIAUTO) {
            this.shoot(true);
            return true;
        }
        return false;
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if (this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKeyHeld(key, held));
        }
        switch (key) {
            case 9: {
                this.leftMouseHeld = held;
                break;
            }
            case 8: {
                this.rightMouseHeld = held;
            }
        }
    }

    public void shoot(boolean secondary) {
        DriveableType type = this.getDriveableType();
        if (this.seats[0] == null && !(this.seats[0].field_70153_n instanceof EntityLivingBase)) {
            return;
        }
        if (this.getShootDelay(secondary) <= 0) {
            ArrayList<DriveablePosition> shootPoints = type.shootPoints(secondary);
            EnumWeaponType weaponType = type.weaponType(secondary);
            if (shootPoints.size() == 0) {
                return;
            }
            int currentGun = this.getCurrentGun(secondary);
            if (type.alternate(secondary)) {
                currentGun = (currentGun + 1) % shootPoints.size();
                this.setCurrentGun(currentGun, secondary);
                this.shootEach(type, shootPoints.get(currentGun), currentGun, secondary, weaponType);
            } else {
                for (int i = 0; i < shootPoints.size(); ++i) {
                    this.shootEach(type, shootPoints.get(i), i, secondary, weaponType);
                }
            }
        }
    }

    private void shootEach(DriveableType type, DriveablePosition shootPoint, int currentGun, boolean secondary, EnumWeaponType weaponType) {
        Vector3f gunVec = this.getOrigin(shootPoint);
        Vector3f lookVector = this.getLookVector(shootPoint);
        if (shootPoint instanceof PilotGun) {
            ShootableType bullet;
            PilotGun pilotGun = (PilotGun)shootPoint;
            GunType gunType = pilotGun.type;
            ItemStack bulletItemStack = this.driveableData.ammo[this.getDriveableType().numPassengerGunners + currentGun];
            if (gunType != null && bulletItemStack != null && bulletItemStack.func_77973_b() instanceof ItemShootable && TeamsManager.bulletsEnabled && gunType.isAmmo(bullet = ((ItemShootable)bulletItemStack.func_77973_b()).type)) {
                this.field_70170_p.func_72838_d((Entity)((ItemShootable)bulletItemStack.func_77973_b()).getEntity(this.field_70170_p, Vector3f.add(gunVec, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null), lookVector, (EntityLivingBase)this.seats[0].field_70153_n, gunType.bulletSpread / 2.0f, gunType.damage, 10.0f, bulletItemStack.func_77960_j(), (InfoType)type));
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                int damage = bulletItemStack.func_77960_j();
                bulletItemStack.func_77964_b(damage + 1);
                if (damage + 1 == bulletItemStack.func_77958_k()) {
                    bulletItemStack.func_77964_b(0);
                    if (this.seats[0].field_70153_n instanceof EntityPlayer && !((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                        --bulletItemStack.field_77994_a;
                        if (bulletItemStack.field_77994_a <= 0) {
                            bulletItemStack = null;
                        }
                        this.driveableData.func_70299_a(this.getDriveableType().numPassengerGunners + currentGun, bulletItemStack);
                    }
                }
                this.setShootDelay(type.shootDelay(secondary), secondary);
            }
        } else {
            switch (weaponType) {
                case BOMB: {
                    if (!TeamsManager.bombsEnabled) break;
                    int slot = -1;
                    for (int i = this.driveableData.getBombInventoryStart(); i < this.driveableData.getBombInventoryStart() + type.numBombSlots; ++i) {
                        ItemStack bomb = this.driveableData.func_70301_a(i);
                        if (bomb == null || !(bomb.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)bomb.func_77973_b()).type, weaponType)) continue;
                        slot = i;
                    }
                    if (slot == -1) break;
                    boolean spread = false;
                    boolean damageMultiplier = true;
                    float shellSpeed = 0.0f;
                    ItemStack bulletStack = this.driveableData.func_70301_a(slot);
                    ItemBullet bulletItem = (ItemBullet)bulletStack.func_77973_b();
                    EntityShootable bulletEntity = bulletItem.getEntity(this.field_70170_p, Vec3.func_72443_a((double)(this.field_70165_t + (double)gunVec.x), (double)(this.field_70163_u + (double)gunVec.y), (double)(this.field_70161_v + (double)gunVec.z)), this.axes.getYaw(), this.axes.getPitch(), this.field_70159_w, this.field_70181_x, this.field_70179_y, (EntityLivingBase)this.seats[0].field_70153_n, (float)damageMultiplier, this.driveableData.func_70301_a(slot).func_77960_j(), type);
                    this.field_70170_p.func_72838_d((Entity)bulletEntity);
                    if (type.shootSound(secondary) != null) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                    }
                    if (this.seats[0].field_70153_n instanceof EntityPlayer && !((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                        bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                        if (bulletStack.func_77960_j() == bulletStack.func_77958_k()) {
                            bulletStack.func_77964_b(0);
                            --bulletStack.field_77994_a;
                            if (bulletStack.field_77994_a == 0) {
                                bulletStack = null;
                            }
                        }
                        this.driveableData.func_70299_a(slot, bulletStack);
                    }
                    this.setShootDelay(type.shootDelay(secondary), secondary);
                    break;
                }
                case MISSILE: 
                case SHELL: {
                    if (!TeamsManager.shellsEnabled) break;
                    int slot = -1;
                    for (int i = this.driveableData.getMissileInventoryStart(); i < this.driveableData.getMissileInventoryStart() + type.numMissileSlots; ++i) {
                        ItemStack shell = this.driveableData.func_70301_a(i);
                        if (shell == null || !(shell.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)shell.func_77973_b()).type, weaponType)) continue;
                        slot = i;
                    }
                    if (slot == -1) break;
                    boolean spread = false;
                    boolean damageMultiplier = true;
                    float shellSpeed = 3.0f;
                    ItemStack bulletStack = this.driveableData.func_70301_a(slot);
                    ItemBullet bulletItem = (ItemBullet)bulletStack.func_77973_b();
                    EntityShootable bulletEntity = bulletItem.getEntity(this.field_70170_p, Vector3f.add(new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), gunVec, null), lookVector, (EntityLivingBase)this.seats[0].field_70153_n, (float)spread, (float)damageMultiplier, shellSpeed, this.driveableData.func_70301_a(slot).func_77960_j(), (InfoType)type);
                    this.field_70170_p.func_72838_d((Entity)bulletEntity);
                    if (type.shootSound(secondary) != null) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                    }
                    if (this.seats[0].field_70153_n instanceof EntityPlayer && !((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
                        bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                        if (bulletStack.func_77960_j() == bulletStack.func_77958_k()) {
                            bulletStack.func_77964_b(0);
                            --bulletStack.field_77994_a;
                            if (bulletStack.field_77994_a == 0) {
                                bulletStack = null;
                            }
                        }
                        this.driveableData.func_70299_a(slot, bulletStack);
                    }
                    this.setShootDelay(type.shootDelay(secondary), secondary);
                    break;
                }
                case GUN: {
                    break;
                }
                case MINE: {
                    break;
                }
            }
        }
    }

    public Vector3f getOrigin(DriveablePosition dp) {
        Vector3f localGunVec = new Vector3f(dp.position);
        if (dp.part == EnumDriveablePart.turret) {
            Vector3f.sub(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
            localGunVec = this.seats[0].looking.findLocalVectorGlobally(localGunVec);
            Vector3f.add(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
        }
        return this.rotate(localGunVec);
    }

    public Vector3f getLookVector(DriveablePosition dp) {
        return this.axes.getXAxis();
    }

    public void func_70071_h_() {
        boolean canThrust;
        boolean driverIsCreative;
        super.func_70071_h_();
        DriveableType type = this.getDriveableType();
        DriveableData data = this.getDriveableData();
        if (!this.field_70170_p.field_72995_K) {
            int i;
            for (i = 0; i < this.getDriveableType().numPassengers + 1; ++i) {
                if (this.seats[i] != null && this.seats[i].field_70175_ag) continue;
                this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.seats[i]);
            }
            for (i = 0; i < type.wheelPositions.length; ++i) {
                if (this.wheels[i] != null && this.wheels[i].field_70175_ag) continue;
                this.wheels[i] = new EntityWheel(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.wheels[i]);
            }
        }
        boolean bl = driverIsCreative = this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
        if (this.hasEnoughFuel()) {
            this.harvesterAngle += this.throttle / 5.0f;
        }
        if (type.harvestBlocks && type.health.get((Object)EnumDriveablePart.harvester) != null) {
            CollisionBox box = type.health.get((Object)EnumDriveablePart.harvester);
            for (float x = box.x; x <= box.x + box.w; x += 1.0f) {
                for (float y = box.y; y <= box.y + box.h; y += 1.0f) {
                    for (float z = box.z; z <= box.z + box.d; z += 1.0f) {
                        int blockZ;
                        int blockY;
                        Vector3f v = this.axes.findLocalVectorGlobally(new Vector3f(x, y, z));
                        int blockX = (int)Math.round(this.field_70165_t + (double)v.x);
                        Block block = this.field_70170_p.func_147439_a(blockX, blockY = (int)Math.round(this.field_70163_u + (double)v.y), blockZ = (int)Math.round(this.field_70161_v + (double)v.z));
                        if (!type.materialsHarvested.contains(block.func_149688_o()) || !(block.func_149712_f(this.field_70170_p, blockX, blockY, blockZ) >= 0.0f)) continue;
                        ArrayList stacks = block.getDrops(this.field_70170_p, blockX, blockY, blockZ, this.field_70170_p.func_72805_g(blockX, blockY, blockZ), 0);
                        for (int i = 0; i < stacks.size(); ++i) {
                            ItemStack stack = (ItemStack)stacks.get(i);
                            FlansMod.log("");
                            if (InventoryHelper.addItemStackToInventory(this.driveableData, stack, driverIsCreative) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) continue;
                            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), stack));
                        }
                        this.field_70170_p.func_147480_a(blockX, blockY, blockZ, false);
                    }
                }
            }
        }
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            Vector3f pos;
            if (part.box == null) continue;
            part.update(this);
            if (this.field_70170_p.field_72995_K) {
                if (part.onFire) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x + this.field_70146_Z.nextFloat() * part.box.w, part.box.y + this.field_70146_Z.nextFloat() * part.box.h, part.box.z + this.field_70146_Z.nextFloat() * part.box.d));
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
                if (part.health > 0 && part.health < part.maxHealth / 2) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x + this.field_70146_Z.nextFloat() * part.box.w, part.box.y + this.field_70146_Z.nextFloat() * part.box.h, part.box.z + this.field_70146_Z.nextFloat() * part.box.d));
                    this.field_70170_p.func_72869_a(part.health < part.maxHealth / 4 ? "largesmoke" : "smoke", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
            }
            if (part.onFire) {
                if (this.field_70170_p.func_72896_J() && this.field_70146_Z.nextInt(40) == 0) {
                    part.onFire = false;
                }
                pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x + part.box.w / 2.0f, part.box.y + part.box.h / 2.0f, part.box.z + part.box.d / 2.0f));
                if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))).func_149688_o() != Material.field_151586_h) continue;
                part.onFire = false;
                continue;
            }
            pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x / 16.0f + part.box.w / 32.0f, part.box.y / 16.0f + part.box.h / 32.0f, part.box.z / 16.0f + part.box.d / 32.0f));
            if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))).func_149688_o() != Material.field_151587_i) continue;
            part.onFire = true;
        }
        this.checkParts();
        this.field_70126_B = this.axes.getYaw();
        this.field_70127_C = this.axes.getPitch();
        this.prevRotationRoll = this.axes.getRoll();
        this.prevAxes = this.axes.clone();
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
        if (this.field_70153_n != null && this.field_70128_L) {
            this.field_70153_n.func_70078_a(null);
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70143_R = 0.0f;
        }
        boolean bl2 = canThrust = this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d || this.driveableData.fuelInTank > 0.0f;
        if (this.seats[0] != null && this.seats[0].field_70153_n == null || !canThrust) {
            this.throttle *= 0.98f;
            this.leftMouseHeld = false;
            this.rightMouseHeld = false;
        }
        if (this.shootDelayPrimary > 0) {
            --this.shootDelayPrimary;
        }
        if (this.shootDelaySecondary > 0) {
            --this.shootDelaySecondary;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.leftMouseHeld && this.getDriveableType().modePrimary == EnumFireMode.FULLAUTO) {
                this.shoot(false);
            }
            if (this.rightMouseHeld && this.getDriveableType().modeSecondary == EnumFireMode.FULLAUTO) {
                this.shoot(true);
            }
            this.minigunSpeedPrimary *= 0.9f;
            this.minigunSpeedSecondary *= 0.9f;
            if (this.leftMouseHeld && this.getDriveableType().modePrimary == EnumFireMode.MINIGUN) {
                this.minigunSpeedPrimary += 0.1f;
                if (this.minigunSpeedPrimary > 1.0f) {
                    this.shoot(false);
                }
            }
            if (this.rightMouseHeld && this.getDriveableType().modeSecondary == EnumFireMode.MINIGUN) {
                this.minigunSpeedSecondary += 0.1f;
                if (this.minigunSpeedSecondary > 1.0f) {
                    this.shoot(true);
                }
            }
        }
        int fuelMultiplier = 2;
        if (data.fuelInTank >= (float)type.fuelTankSize) {
            return;
        }
        for (int i = 0; i < data.func_70302_i_(); ++i) {
            ItemStack stack = data.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            Item item = stack.func_77973_b();
            if (data.engine.useRFPower) {
                if (!(item instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem energy = (IEnergyContainerItem)item;
                data.fuelInTank += (float)(fuelMultiplier * energy.extractEnergy(stack, data.engine.RFDrawRate, false) / data.engine.RFDrawRate);
                continue;
            }
            if (item instanceof ItemPart) {
                PartType part = ((ItemPart)item).type;
                if (part.category != 9) continue;
                data.fuelInTank += (float)fuelMultiplier;
                int damage = stack.func_77960_j();
                stack.func_77964_b(damage + 1);
                if (damage < stack.func_77958_k()) break;
                stack.func_77964_b(0);
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) break;
                data.func_70299_a(i, null);
                break;
            }
            if (FlansMod.hooks.BuildCraftLoaded && stack.func_77969_a(FlansMod.hooks.BuildCraftOilBucket) && data.fuelInTank + (float)(1000 * fuelMultiplier) <= (float)type.fuelTankSize) {
                data.fuelInTank += (float)(1000 * fuelMultiplier);
                data.func_70299_a(i, new ItemStack(Items.field_151133_ar));
                continue;
            }
            if (!FlansMod.hooks.BuildCraftLoaded || !stack.func_77969_a(FlansMod.hooks.BuildCraftFuelBucket) || !(data.fuelInTank + (float)(2000 * fuelMultiplier) <= (float)type.fuelTankSize)) continue;
            data.fuelInTank += (float)(2000 * fuelMultiplier);
            data.func_70299_a(i, new ItemStack(Items.field_151133_ar));
        }
    }

    public void checkForCollisions() {
        boolean crashInWater = false;
        double speed = this.getSpeedXYZ();
        for (DriveablePosition p : this.getDriveableType().collisionPoints) {
            MovingObjectPosition hit;
            if (this.driveableData.parts.get((Object)((Object)p.part)).dead) continue;
            Vector3f lastRelPos = this.prevAxes.findLocalVectorGlobally(p.position);
            Vec3 lastPos = Vec3.func_72443_a((double)(this.field_70169_q + (double)lastRelPos.x), (double)(this.field_70167_r + (double)lastRelPos.y), (double)(this.field_70166_s + (double)lastRelPos.z));
            Vector3f currentRelPos = this.axes.findLocalVectorGlobally(p.position);
            Vec3 currentPos = Vec3.func_72443_a((double)(this.field_70165_t + (double)currentRelPos.x), (double)(this.field_70163_u + (double)currentRelPos.y), (double)(this.field_70161_v + (double)currentRelPos.z));
            if (FlansMod.DEBUG && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, new Vector3f(lastPos), Vector3f.sub(currentRelPos, lastRelPos, null), 10, 1.0f, 0.0f, 0.0f));
            }
            if ((hit = this.field_70170_p.func_72901_a(lastPos, currentPos, crashInWater)) == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) continue;
            int x = hit.field_72311_b;
            int y = hit.field_72312_c;
            int z = hit.field_72309_d;
            Block blockHit = this.field_70170_p.func_147439_a(x, y, z);
            int meta = this.field_70170_p.func_72805_g(x, y, z);
            float blockHardness = blockHit.func_149712_f(this.field_70170_p, x, y, z);
            if (!this.attackPart(p.part, DamageSource.field_76368_d, blockHardness * blockHardness * (float)speed) && TeamsManager.driveablesBreakBlocks) {
                this.field_70170_p.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)blockHit) + (meta << 12));
                if (this.field_70170_p.field_72995_K) continue;
                blockHit.func_149697_b(this.field_70170_p, x, y, z, meta, 1);
                this.field_70170_p.func_147468_f(x, y, z);
                continue;
            }
            this.field_70170_p.func_72876_a((Entity)this, currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c, 1.0f, false);
        }
    }

    protected void func_70069_a(float k) {
        if (k <= 0.0f) {
            return;
        }
        int i = MathHelper.func_76123_f((float)(k - 10.0f));
        if (i > 0) {
            this.attackPart(EnumDriveablePart.core, DamageSource.field_76379_h, i / 5);
        }
    }

    public boolean attackPart(EnumDriveablePart ep, DamageSource source, float damage) {
        DriveablePart part = this.driveableData.parts.get((Object)ep);
        return part.attack(damage, source.func_76347_k());
    }

    public Vector3f rotate(Vector3f inVec) {
        return this.axes.findLocalVectorGlobally(inVec);
    }

    public Vector3f rotate(Vec3 inVec) {
        return this.rotate(inVec.field_72450_a, inVec.field_72448_b, inVec.field_72449_c);
    }

    public Vector3f rotate(double x, double y, double z) {
        return this.rotate(new Vector3f((float)x, (float)y, (float)z));
    }

    public void rotateYaw(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalYaw(rotateBy);
        this.updatePrevAngles();
    }

    public void rotatePitch(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalPitch(rotateBy);
        this.updatePrevAngles();
    }

    public void rotateRoll(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalRoll(rotateBy);
        this.updatePrevAngles();
    }

    public void updatePrevAngles() {
        double dRoll;
        double dPitch;
        double dYaw = this.axes.getYaw() - this.field_70126_B;
        if (dYaw > 180.0) {
            this.field_70126_B += 360.0f;
        }
        if (dYaw < -180.0) {
            this.field_70126_B -= 360.0f;
        }
        if ((dPitch = (double)(this.axes.getPitch() - this.field_70127_C)) > 180.0) {
            this.field_70127_C += 360.0f;
        }
        if (dPitch < -180.0) {
            this.field_70127_C -= 360.0f;
        }
        if ((dRoll = (double)(this.axes.getRoll() - this.prevRotationRoll)) > 180.0) {
            this.prevRotationRoll += 360.0f;
        }
        if (dRoll < -180.0) {
            this.prevRotationRoll -= 360.0f;
        }
    }

    public void setRotation(float rotYaw, float rotPitch, float rotRoll) {
        this.axes.setAngles(rotYaw, rotPitch, rotRoll);
    }

    public boolean isPartOfThis(Entity ent) {
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            if (ent == seat) {
                return true;
            }
            if (seat.field_70153_n != ent) continue;
            return true;
        }
        return ent == this;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public DriveableType getDriveableType() {
        return DriveableType.getDriveable(this.driveableType);
    }

    public DriveableData getDriveableData() {
        return this.driveableData;
    }

    @Override
    public boolean isDead() {
        return this.field_70128_L;
    }

    @Override
    public Entity getControllingEntity() {
        return this.seats[0].getControllingEntity();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack(this.getDriveableType().item, 1, 0);
        stack.field_77990_d = new NBTTagCompound();
        this.driveableData.writeToNBT(stack.field_77990_d);
        return stack;
    }

    public boolean hasFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].field_70153_n == null) {
            return false;
        }
        return this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d || this.driveableData.fuelInTank > 0.0f;
    }

    public boolean hasEnoughFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].field_70153_n == null) {
            return false;
        }
        return this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d || this.driveableData.fuelInTank > this.driveableData.engine.fuelConsumption * this.throttle;
    }

    public double getSpeedXYZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public boolean landVehicle() {
        return false;
    }

    public boolean gearDown() {
        return true;
    }

    public boolean onGround() {
        return this.field_70122_E;
    }

    public ArrayList<BulletHit> attackFromBullet(Vector3f origin, Vector3f motion) {
        ArrayList<BulletHit> hits = new ArrayList<BulletHit>();
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            DriveableHit hit = part.rayTrace(this, rotatedPosVector, rotatedMotVector);
            if (hit == null) continue;
            hits.add(hit);
        }
        return hits;
    }

    public float bulletHit(EntityBullet bullet, DriveableHit hit, float penetratingPower) {
        DriveablePart part = this.getDriveableData().parts.get((Object)hit.part);
        part.hitByBullet(bullet);
        if (!this.field_70170_p.field_72995_K) {
            this.checkParts();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 100.0f, this.field_71093_bK);
        }
        return penetratingPower - 5.0f;
    }

    public DriveablePart raytraceParts(Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part.rayTrace(this, rotatedPosVector, rotatedMotVector) == null) continue;
            return part;
        }
        return null;
    }

    public boolean canHitPart(EnumDriveablePart part) {
        return true;
    }

    public void checkParts() {
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part == null || part.dead || part.health > 0 || part.maxHealth <= 0) continue;
            this.killPart(part);
        }
        for (EntitySeat seat : this.seats) {
        }
        if (this.getDriveableData().parts.get((Object)((Object)EnumDriveablePart.core)).dead) {
            if (!this.field_70170_p.field_72995_K) {
                for (DriveablePart part : this.driveableData.parts.values()) {
                    if (part.health <= 0 || part.dead) continue;
                    this.killPart(part);
                }
            }
            this.func_70106_y();
        }
    }

    private void killPart(DriveablePart part) {
        if (part.dead) {
            return;
        }
        part.health = 0;
        part.dead = true;
        DriveableType type = this.getDriveableType();
        if (!this.field_70170_p.field_72995_K) {
            ArrayList<ItemStack> drops;
            Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
            if (part.box != null) {
                pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x / 16.0f + part.box.w / 32.0f, part.box.y / 16.0f + part.box.h / 32.0f, part.box.z / 16.0f + part.box.d / 32.0f));
            }
            if ((drops = type.getItemsRequired(part, this.getDriveableData().engine)) != null) {
                for (ItemStack stack : drops) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, stack.func_77946_l()));
                }
            }
            this.dropItemsOnPartDeath(pos, part);
            if (part.type == EnumDriveablePart.core) {
                for (int i = 0; i < this.getDriveableData().func_70302_i_(); ++i) {
                    ItemStack stack;
                    stack = this.getDriveableData().func_70301_a(i);
                    if (stack == null) continue;
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + this.field_70146_Z.nextGaussian(), this.field_70161_v + this.field_70146_Z.nextGaussian(), stack));
                }
            }
        }
        for (EnumDriveablePart child : part.type.getChildren()) {
            this.killPart(this.getDriveableData().parts.get((Object)child));
        }
    }

    protected abstract void dropItemsOnPartDeath(Vector3f var1, DriveablePart var2);

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    public void explode() {
    }

    @Override
    public float getCameraDistance() {
        return this.getDriveableType().cameraDistance;
    }

    public boolean isPartIntact(EnumDriveablePart part) {
        DriveablePart thisPart = this.getDriveableData().parts.get((Object)part);
        return thisPart.maxHealth == 0 || thisPart.health > 0;
    }

    public abstract boolean hasMouseControlMode();

    public abstract String getBombInventoryName();

    public abstract String getMissileInventoryName();

    public boolean rotateWithTurret(Seat seat) {
        return seat.part == EnumDriveablePart.turret;
    }

    public String func_70005_c_() {
        return this.getDriveableType().name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat != 0 || !FlansModClient.controlModeMouse;
    }

    public int getShootDelay(boolean secondary) {
        return secondary ? this.shootDelaySecondary : this.shootDelayPrimary;
    }

    public float getMinigunSpeed(boolean secondary) {
        return secondary ? this.minigunSpeedSecondary : this.minigunSpeedPrimary;
    }

    public int getCurrentGun(boolean secondary) {
        return secondary ? this.currentGunSecondary : this.currentGunPrimary;
    }

    public void setShootDelay(int i, boolean secondary) {
        if (secondary) {
            this.shootDelaySecondary = i;
        } else {
            this.shootDelayPrimary = i;
        }
    }

    public void setMinigunSpeed(float f, boolean secondary) {
        if (secondary) {
            this.minigunSpeedSecondary = f;
        } else {
            this.minigunSpeedPrimary = f;
        }
    }

    public void setCurrentGun(int i, boolean secondary) {
        if (secondary) {
            this.currentGunSecondary = i;
        } else {
            this.currentGunPrimary = i;
        }
    }
}

