/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.core.RegistrySocial;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.block.TEBlocks;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cofh.thermalexpansion.block.plate.TilePlateBase;
import cofh.thermalexpansion.gui.client.plate.GuiPlateSignal;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;

public class TilePlateSignal
extends TilePlateBase {
    public static final byte MIN_DISTANCE = 0;
    public static final byte MAX_DISTANCE = 15;
    public static final byte MIN_INTENSITY = 0;
    public static final byte MAX_INTENSITY = 15;
    public static final byte MIN_DURATION = 2;
    public static final byte MAX_DURATION = 40;
    public byte distance = (byte)15;
    public byte intensity = (byte)15;
    public byte duration = (byte)20;
    public byte collisionMode = 0;
    byte collided = 0;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateSignal.class, (String)"cofh.thermalexpansion.PlateSignal");
    }

    public TilePlateSignal() {
        super(BlockPlate.Types.SIGNAL);
    }

    public void blockBroken() {
        this.removeSignal();
        super.blockBroken();
    }

    @Override
    public void rotated() {
        this.removeSignal();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    private void removeSignal() {
        int n;
        int n2;
        int[] nArray = this.getVector(this.distance + 1);
        int n3 = nArray[0];
        if (((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c + n3, ((TileEntity)this).field_145848_d + (n2 = nArray[1]), ((TileEntity)this).field_145849_e + (n = nArray[2])).equals(TEBlocks.blockAirSignal)) {
            ((TileEntity)this).field_145850_b.func_147465_d(((TileEntity)this).field_145851_c + n3, ((TileEntity)this).field_145848_d + n2, ((TileEntity)this).field_145849_e + n, Blocks.field_150350_a, 0, 3);
        }
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    public void func_145845_h() {
        if (this.collided > 0) {
            this.markChunkDirty();
            this.collided = (byte)(this.collided - 1);
            if (this.collided == 0) {
                this.removeSignal();
            }
        }
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        int n;
        int n2;
        int n3;
        Object object;
        block13: {
            block15: {
                block14: {
                    if (((TileEntity)this).field_145850_b.field_72995_K) {
                        return;
                    }
                    switch (this.collisionMode) {
                        case 3: {
                            if (entity instanceof IMob) break;
                            return;
                        }
                        case 2: {
                            if (entity instanceof EntityPlayer) break;
                            return;
                        }
                        case 1: {
                            if (entity instanceof EntityLivingBase) break;
                            return;
                        }
                    }
                    if (!this.filterSecure || this.getAccess().isPublic()) break block13;
                    if (!(entity instanceof EntityItem)) break block14;
                    object = ((EntityItem)entity).func_145800_j();
                    if (object == null) break block15;
                    if (this.getAccess().isRestricted() && RegistrySocial.playerHasAccess((String)object, (GameProfile)this.getOwner())) break block13;
                    GameProfile gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a((String)object);
                    if (!this.getOwner().getId().equals(gameProfile.getId())) break block15;
                    break block13;
                }
                if (this.canPlayerAccess((EntityPlayer)entity)) break block13;
            }
            return;
        }
        if (this.collided > 0) {
            this.collided = this.duration;
            if (((TileEntity)this).field_145850_b.func_82737_E() % 10L != 0L) {
                return;
            }
        }
        if (((TileEntity)this).field_145850_b.func_147437_c(((TileEntity)this).field_145851_c + (n3 = (object = this.getVector(this.distance + 1))[0]), ((TileEntity)this).field_145848_d + (n2 = object[1]), ((TileEntity)this).field_145849_e + (n = object[2]))) {
            if (((TileEntity)this).field_145850_b.func_147465_d(((TileEntity)this).field_145851_c + n3, ((TileEntity)this).field_145848_d + n2, ((TileEntity)this).field_145849_e + n, TEBlocks.blockAirSignal, (int)this.intensity, 3)) {
                this.markChunkDirty();
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
            this.collided = this.duration;
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.distance = nBTTagCompound.func_74771_c("Dist");
        this.intensity = nBTTagCompound.func_74771_c("Int");
        this.duration = nBTTagCompound.func_74771_c("Time");
        this.collisionMode = nBTTagCompound.func_74771_c("Mode");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74774_a("Dist", this.distance);
        nBTTagCompound.func_74774_a("Int", this.intensity);
        nBTTagCompound.func_74774_a("Time", this.duration);
        nBTTagCompound.func_74774_a("Mode", this.collisionMode);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPlateSignal(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this, false, false);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.distance = nBTTagCompound.func_74771_c("Dist");
        this.intensity = nBTTagCompound.func_74771_c("Int");
        this.duration = nBTTagCompound.func_74771_c("Time");
        this.collided = nBTTagCompound.func_74771_c("Col");
        this.collisionMode = nBTTagCompound.func_74771_c("cMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Dist", this.distance);
        nBTTagCompound.func_74774_a("Int", this.intensity);
        nBTTagCompound.func_74774_a("Time", this.duration);
        nBTTagCompound.func_74774_a("Col", this.collided);
        nBTTagCompound.func_74774_a("cMode", this.collisionMode);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.distance);
        packetCoFHBase.addByte(this.intensity);
        packetCoFHBase.addByte(this.duration);
        packetCoFHBase.addByte(this.collided);
        packetCoFHBase.addByte(this.collisionMode);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addByte(this.distance);
        packetCoFHBase.addByte(this.intensity);
        packetCoFHBase.addByte(this.duration);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addByte(MathHelper.clamp((int)this.distance, (int)0, (int)15));
        packetCoFHBase.addByte(MathHelper.clamp((int)this.intensity, (int)0, (int)15));
        packetCoFHBase.addByte(MathHelper.clamp((int)this.duration, (int)2, (int)40));
        packetCoFHBase.addByte(this.collisionMode);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.distance = packetCoFHBase.getByte();
        this.intensity = packetCoFHBase.getByte();
        this.duration = packetCoFHBase.getByte();
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        byte by = packetCoFHBase.getByte();
        if (by != this.distance) {
            this.removeSignal();
            this.distance = by;
        }
        this.intensity = packetCoFHBase.getByte();
        this.duration = packetCoFHBase.getByte();
        this.collisionMode = packetCoFHBase.getByte();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.distance = packetCoFHBase.getByte();
            this.intensity = packetCoFHBase.getByte();
            this.duration = packetCoFHBase.getByte();
            this.collisionMode = packetCoFHBase.getByte();
        } else {
            packetCoFHBase.getByte();
            packetCoFHBase.getByte();
            packetCoFHBase.getByte();
            packetCoFHBase.getByte();
        }
    }
}

