/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.api.transport.IEnderDestination;
import cofh.core.RegistryEnderAttuned;
import cofh.core.RegistrySocial;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.EntityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cofh.thermalexpansion.block.plate.TilePlatePoweredBase;
import cofh.thermalexpansion.core.TeleportChannelRegistry;
import cofh.thermalexpansion.gui.client.plate.GuiPlateTeleport;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.network.PacketTEBase;
import cofh.thermalexpansion.render.particle.ParticlePortal;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.client.particle.EntityPortalFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TilePlateTeleporter
extends TilePlatePoweredBase
implements IEnderDestination,
IRedstoneControl {
    protected static final int TELEPORT_COST = 100000;
    protected static final int DIMENSION_TELEPORT_COST = 1000000;
    protected static final int PARTICLE_DELAY = 80;
    protected static final int TELEPORT_DELAY = 130;
    private final ThreadLocal<Boolean> internalSet = new ThreadLocal();
    private Integer pendingFrequency;
    protected int frequency = -1;
    protected int destination = -1;
    protected boolean isActive;
    protected boolean isPowered;
    protected boolean playerOnly = false;
    protected IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.DISABLED;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateTeleporter.class, (String)"cofh.thermalexpansion.PlateTeleporter");
    }

    public TilePlateTeleporter() {
        super(BlockPlate.Types.TELEPORT, 2000000);
        this.filterSecure = true;
    }

    protected void teleportEntity(Entity entity, double d, double d2, double d3) {
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70634_a(d, d2, d3);
        } else {
            entity.func_70012_b(d, d2, d3, entity.field_70177_z, entity.field_70125_A);
        }
        entity.field_70170_p.func_72956_a(entity, "mob.endermen.portal", 1.0f, 1.0f);
    }

    private static boolean posEquals(double d, double d2, double d3, double d4, double d5, double d6) {
        long l = (long)(d * 64.0);
        long l2 = (long)(d2 * 64.0);
        long l3 = (long)(d3 * 64.0);
        long l4 = (long)(d4 * 64.0);
        long l5 = (long)(d5 * 64.0);
        long l6 = (long)(d6 * 64.0);
        return l == l4 & l2 == l5 & l3 == l6;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        double d;
        double d2;
        String string;
        int n;
        IEnderDestination iEnderDestination;
        block28: {
            block30: {
                block29: {
                    if (this.destination == -1 || entity.field_70170_p.field_72995_K) {
                        return;
                    }
                    if (!this.redstoneControlOrDisable()) {
                        return;
                    }
                    if (entity.field_71088_bW > 0 && entity.field_71088_bW >= entity.func_82147_ab()) {
                        entity.field_71088_bW = entity.func_82147_ab() + 130;
                        return;
                    }
                    if (!TilePlateTeleporter.posEquals(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) {
                        entity.field_71088_bW = 0;
                        return;
                    }
                    if (!RegistryEnderAttuned.getRegistry().hasDestination((IEnderDestination)this)) {
                        if (this.destination != -1) {
                            this.internalSet.set(Boolean.FALSE);
                            this.clearDestination();
                            this.internalSet.set(null);
                        }
                        return;
                    }
                    iEnderDestination = RegistryEnderAttuned.getRegistry().getDestination((IEnderDestination)this, true);
                    if (iEnderDestination == null) {
                        return;
                    }
                    if (iEnderDestination.isNotValid()) {
                        // empty if block
                    }
                    n = 100000;
                    if (iEnderDestination.dimension() != this.dimension()) {
                        n = 1000000;
                    }
                    if (entity instanceof EntityEnderman) {
                        n *= 2;
                    } else if (entity instanceof EntityItem) {
                        n /= 1000;
                    }
                    if (this.storage.getEnergyStored() < n) {
                        return;
                    }
                    Class<Entity> clazz = Entity.class;
                    if (this.playerOnly) {
                        clazz = EntityPlayer.class;
                    }
                    if (!clazz.isInstance(entity)) {
                        return;
                    }
                    if (!this.filterSecure || this.getAccess().isPublic()) break block28;
                    if (!(entity instanceof EntityItem)) break block29;
                    string = ((EntityItem)entity).func_145800_j();
                    if (string == null) break block30;
                    if (this.getAccess().isRestricted() && RegistrySocial.playerHasAccess((String)string, (GameProfile)this.getOwner())) break block28;
                    GameProfile gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(string);
                    if (!this.getOwner().getId().equals(gameProfile.getId())) break block30;
                    break block28;
                }
                if (entity instanceof EntityPlayer && this.canPlayerAccess((EntityPlayer)entity)) break block28;
            }
            return;
        }
        if (entity instanceof EntityLivingBase && entity.field_71088_bW >= -130) {
            if (entity.field_71088_bW > -130) {
                --entity.field_71088_bW;
                if (entity instanceof EntityPlayerMP && (((TileEntity)this).field_145850_b.func_82737_E() & 1L) == 0L) {
                    ++entity.field_71088_bW;
                }
            }
            string = entity.field_70170_p;
            int n2 = entity.field_71088_bW <= -130 ? 100 : 99;
            d2 = entity.field_70165_t;
            d = entity.field_70161_v;
            double d3 = entity.field_70163_u;
            d3 += (double)entity.field_70131_O * 0.75;
            int n3 = -entity.field_71088_bW * 5 / 80;
            if (!(n2 != 100 && n3 == (-entity.field_71088_bW - 2) * 5 / 80 || n2 != 100 && entity.field_71088_bW < -80)) {
                PacketCoFHBase packetCoFHBase = this.getModePacket();
                packetCoFHBase.addByte(n2);
                if (n2 == 99) {
                    packetCoFHBase.addInt(n3);
                }
                packetCoFHBase.addFloat((float)d2);
                packetCoFHBase.addFloat((float)d3);
                packetCoFHBase.addFloat((float)d);
                if (n2 == 100) {
                    packetCoFHBase.addInt(entity.func_145782_y());
                    packetCoFHBase.addInt(iEnderDestination.x());
                    packetCoFHBase.addInt(iEnderDestination.y());
                    packetCoFHBase.addInt(iEnderDestination.z());
                    packetCoFHBase.addInt(iEnderDestination.dimension());
                }
                NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(((World)string).field_73011_w.field_76574_g, (double)((TileEntity)this).field_145851_c, (double)((TileEntity)this).field_145848_d, (double)((TileEntity)this).field_145849_e, 50.0);
                PacketHandler.sendToAllAround((PacketBase)packetCoFHBase, (NetworkRegistry.TargetPoint)targetPoint);
            }
            if (n2 == 99) {
                return;
            }
        }
        if (this.storage.extractEnergy(n, false) == n) {
            entity.field_71088_bW = entity.func_82147_ab() + 130 + 5;
            double d4 = (double)iEnderDestination.x() + 0.5;
            d2 = (double)iEnderDestination.y() + 0.2;
            d = (double)iEnderDestination.z() + 0.5;
            if (iEnderDestination.dimension() != this.dimension()) {
                EntityHelper.transferEntityToDimension((Entity)entity, (double)d4, (double)d2, (double)d, (int)iEnderDestination.dimension(), (ServerConfigurationManager)MinecraftServer.func_71276_C().func_71203_ab());
            } else {
                this.teleportEntity(entity, d4, d2, d);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, Random random) {
        if (!this.isActive || world.func_82737_E() % 6L != 0L || !this.redstoneControlOrDisable()) {
            return;
        }
        double d = 0.5 + 0.15 * random.nextGaussian();
        double d2 = 0.5 + 0.15 * random.nextGaussian();
        double[] dArray = this.fixPosition(d, 0.0, d2);
        ParticlePortal particlePortal = new ParticlePortal(world, (double)((TileEntity)this).field_145851_c + dArray[0], (double)((TileEntity)this).field_145848_d + dArray[1], (double)((TileEntity)this).field_145849_e + dArray[2], 1.0f, 1.0f, 1.0f);
        dArray = this.fixVector(((Entity)particlePortal).field_70159_w, ((Entity)particlePortal).field_70181_x, ((Entity)particlePortal).field_70179_y);
        particlePortal.func_70016_h(dArray[0], dArray[1], dArray[2]);
        particlePortal.setScale(this.fixVector(0.03, 0.1, 0.03));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particlePortal);
    }

    @SideOnly(value=Side.CLIENT)
    protected void addZapParticles(int n, double d, double d2, double d3) {
        double d4 = (n += 2) / 2;
        int n2 = n;
        while (n2-- > 0) {
            int n3 = n;
            while (n3-- > 0) {
                double d5 = Math.cos((double)n3 * Math.PI / d4);
                double d6 = Math.pow(Math.sin((double)n2 * Math.PI / d4) * d5, 1.0) * 2.0;
                double d7 = Math.pow(Math.cos((double)n2 * Math.PI / d4) * d5, 1.0) * 2.0;
                d5 = Math.pow(Math.sin((double)n3 * Math.PI / d4) * 1.0, 1.0) * 2.0;
                EntityPortalFX entityPortalFX = new EntityPortalFX(((TileEntity)this).field_145850_b, d, d2, d3, d6, d5, d7);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityPortalFX);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTeleportParticles(double d, double d2, double d3, boolean bl) {
        int n = 15;
        while (n-- > 0) {
            int n2 = 15;
            while (n2-- > 0) {
                double d4 = Math.cos((double)n2 * Math.PI / 7.5);
                double d5 = Math.pow(Math.sin((double)n * Math.PI / 7.5) * d4, 3.0) * 0.15;
                double d6 = Math.pow(Math.cos((double)n * Math.PI / 7.5) * d4, 3.0) * 0.15;
                d4 = Math.pow(Math.sin((double)n2 * Math.PI / 7.5) * 1.0, 3.0) * 0.15;
                EntityFireworkSparkFX entityFireworkSparkFX = new EntityFireworkSparkFX(((TileEntity)this).field_145850_b, d, d2, d3, d5, d4, d6, Minecraft.func_71410_x().field_71452_i){

                    public void func_70091_d(double d, double d2, double d3) {
                        ((Entity)this).field_70181_x += 0.004;
                        super.func_70091_d(d, d2 + 0.004, d3);
                    }
                };
                entityFireworkSparkFX.func_92045_e(bl);
                entityFireworkSparkFX.func_92044_a(15027455);
                entityFireworkSparkFX.func_92046_g(7670943);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)entityFireworkSparkFX);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        byte by = packetCoFHBase.getByte();
        switch (by) {
            case 99: {
                this.addZapParticles(packetCoFHBase.getInt(), packetCoFHBase.getFloat(), packetCoFHBase.getFloat(), packetCoFHBase.getFloat());
                break;
            }
            case 100: {
                float f = packetCoFHBase.getFloat();
                float f2 = packetCoFHBase.getFloat();
                float f3 = packetCoFHBase.getFloat();
                Entity entity = ((TileEntity)this).field_145850_b.func_73045_a(packetCoFHBase.getInt());
                this.addTeleportParticles(f, f2, f3, entity instanceof EntityEnderman);
                f = (float)packetCoFHBase.getInt() + 0.5f;
                f2 = (float)packetCoFHBase.getInt() + 0.2f;
                f3 = (float)packetCoFHBase.getInt() + 0.5f;
                int n = packetCoFHBase.getInt();
                if (entity == null || entity instanceof EntityPlayer) break;
                if (n != this.dimension()) {
                    entity.func_70106_y();
                    break;
                }
                entity.func_70107_b((double)f, (double)f2, (double)f3);
            }
        }
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addInt(this.frequency);
        packetCoFHBase.addInt(this.destination);
        packetCoFHBase.addByte(this.access.ordinal());
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.frequency = packetCoFHBase.getInt();
            this.destination = packetCoFHBase.getInt();
            this.access = ISecurable.AccessMode.values()[packetCoFHBase.getByte()];
        }
        this.isActive = this.destination != -1;
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    public void handleTileInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        if (bl) {
            if (!this.canPlayerAccess(entityPlayer)) {
                return;
            }
            this.internalSet.set(Boolean.TRUE);
            if (packetCoFHBase.getBool()) {
                if (packetCoFHBase.getBool()) {
                    int n = packetCoFHBase.getByte();
                    String string = packetCoFHBase.getString();
                    String string2 = packetCoFHBase.getString();
                    int n2 = this.frequency;
                    if (n == 0) {
                        n = TeleportChannelRegistry.getRegistry().findFreeFrequency(string);
                    }
                    if (this.setFrequency(n)) {
                        PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)entityPlayer);
                        if (n == -1) {
                            TeleportChannelRegistry.getChannels(true).removeFrequency(string, n2);
                            TeleportChannelRegistry.removeChannelFrequency(entityPlayer, string, n2);
                        } else {
                            TeleportChannelRegistry.getChannels(true).setFrequency(string, n, string2);
                            TeleportChannelRegistry.updateChannelFrequency(entityPlayer, string, n, string2);
                        }
                    }
                } else {
                    this.setDestination(packetCoFHBase.getInt());
                }
            } else {
                ISecurable.AccessMode accessMode = ISecurable.AccessMode.values()[packetCoFHBase.getByte()];
                if (this.frequency != -1 && this.access != accessMode) {
                    int n = this.frequency;
                    if (this.setFrequency(-1)) {
                        TeleportChannelRegistry.getChannels(true).removeFrequency(this.getChannelString(), n);
                    }
                }
                this.access = accessMode;
            }
            this.internalSet.set(null);
        } else {
            super.handleTileInfoPacket(packetCoFHBase, bl, entityPlayer);
        }
    }

    public String getChannelString() {
        return this.access.isPublic() ? "_public_" : String.valueOf(this.owner.getName()).toLowerCase(Locale.US);
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean setFrequency(int n) {
        if (this.internalSet.get() == null && !this.access.isPublic()) {
            return false;
        }
        if (!this.inWorld || n != this.frequency) {
            RegistryEnderAttuned.getRegistry().removeDestination((IEnderDestination)this);
            int n2 = this.frequency;
            this.frequency = n;
            if (n != -1) {
                if (RegistryEnderAttuned.getRegistry().hasDestination((IEnderDestination)this, false)) {
                    this.frequency = n2;
                    return false;
                }
                RegistryEnderAttuned.getRegistry().addDestination((IEnderDestination)this);
            }
            this.func_70296_d();
            ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
        return true;
    }

    public boolean clearFrequency() {
        return this.setFrequency(-1);
    }

    public int getDestination() {
        return this.destination;
    }

    public boolean setDestination(int n) {
        if (this.internalSet.get() == null && !this.access.isPublic()) {
            return false;
        }
        if (n != this.destination) {
            int n2 = this.destination;
            this.destination = n;
            boolean bl = this.isActive = n != -1;
            if (this.isActive && !RegistryEnderAttuned.getRegistry().hasDestination((IEnderDestination)this, true)) {
                this.destination = n2;
                this.isActive = n2 != -1;
                return false;
            }
            this.func_70296_d();
            ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
        return true;
    }

    public boolean clearDestination() {
        return this.setDestination(-1);
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.getChannelString().equals(nBTTagCompound.func_74779_i("Channel"))) {
            return false;
        }
        this.setDestination(nBTTagCompound.func_74762_e("Destination"));
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("RS");
        this.rsMode = IRedstoneControl.ControlMode.values()[nBTTagCompound2.func_74771_c("Mode")];
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74778_a("Channel", this.getChannelString());
        nBTTagCompound.func_74768_a("Destination", this.destination);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        nBTTagCompound.func_74782_a("RS", (NBTBase)nBTTagCompound2);
        return true;
    }

    public void blockBroken() {
        RegistryEnderAttuned.getRegistry().removeDestination((IEnderDestination)this);
        if (this.frequency != -1) {
            TeleportChannelRegistry.getChannels(!((TileEntity)this).field_145850_b.field_72995_K).removeFrequency(this.getChannelString(), this.frequency);
        }
    }

    @Override
    public void cofh_validate() {
        if (this.pendingFrequency != null) {
            this.internalSet.set(Boolean.FALSE);
            this.frequency = this.pendingFrequency;
            if (!this.setFrequency(this.frequency)) {
                this.frequency = -1;
            }
            this.internalSet.set(null);
            this.pendingFrequency = null;
        }
        super.cofh_validate();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.pendingFrequency = nBTTagCompound.func_74764_b("Frequency") ? new Integer(nBTTagCompound.func_74762_e("Frequency")) : null;
        this.destination = nBTTagCompound.func_74764_b("Destination") ? nBTTagCompound.func_74762_e("Destination") : -1;
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("RS");
        this.isPowered = nBTTagCompound2.func_74767_n("Power");
        this.rsMode = IRedstoneControl.ControlMode.values()[nBTTagCompound2.func_74771_c("Mode")];
        if (!nBTTagCompound.func_74764_b("FilterSecure")) {
            this.filterSecure = true;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Frequency", this.frequency);
        nBTTagCompound.func_74768_a("Destination", this.destination);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74757_a("Power", this.isPowered);
        nBTTagCompound2.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        nBTTagCompound.func_74782_a("RS", (NBTBase)nBTTagCompound2);
    }

    public boolean isNotValid() {
        return !this.inWorld || ((TileEntity)this).field_145846_f;
    }

    public int x() {
        return ((TileEntity)this).field_145851_c;
    }

    public int y() {
        return ((TileEntity)this).field_145848_d;
    }

    public int z() {
        return ((TileEntity)this).field_145849_e;
    }

    public int dimension() {
        return ((TileEntity)this).field_145850_b.field_73011_w.field_76574_g;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiPlateTeleport(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this, false, false);
    }

    public void onNeighborBlockChange() {
        this.setPowered(((TileEntity)this).field_145850_b.func_72864_z(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e));
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    @Override
    public boolean setAccess(ISecurable.AccessMode accessMode) {
        if (this.frequency != -1 || this.destination != -1) {
            return false;
        }
        if (((TileEntity)this).field_145850_b.field_72995_K && this.access != accessMode) {
            PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addBool(false).addByte(accessMode.ordinal()));
        }
        this.access = accessMode;
        return true;
    }

    public final void setPowered(boolean bl) {
        boolean bl2 = this.isPowered;
        this.isPowered = bl;
        if (bl2 != this.isPowered) {
            if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            } else {
                PacketTEBase.sendRSPowerUpdatePacketToClients(this, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
        }
    }

    public final boolean isPowered() {
        return this.isPowered;
    }

    public final void setControl(IRedstoneControl.ControlMode controlMode) {
        this.rsMode = controlMode;
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            PacketTEBase.sendRSConfigUpdatePacketToServer(this, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        } else {
            this.sendUpdatePacket(Side.CLIENT);
            boolean bl = this.isPowered;
            this.isPowered = !bl;
            this.setPowered(bl);
        }
    }

    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }
}

