/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockCageTrap;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.network.packets.PacketCPlaySoundAtPos;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockPos;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class SCEventHandler {
    public static HashMap<String, String> tipsWithLink = new HashMap();

    public SCEventHandler() {
        tipsWithLink.put("trello", "https://trello.com/b/dbCNZwx0/securitycraft");
        tipsWithLink.put("patreon", "https://www.patreon.com/Geforce");
        tipsWithLink.put("discord", "https://discord.gg/U8DvBAW");
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!SecurityCraft.config.sayThanksMessage || !event.player.func_130014_f_().field_72995_K) {
            return;
        }
        String tipKey = this.getRandomTip();
        Object message = tipsWithLink.containsKey(tipKey.split("\\.")[2]) ? new ChatComponentText("[" + EnumChatFormatting.GOLD + "SecurityCraft" + EnumChatFormatting.WHITE + "] " + StatCollector.func_74838_a((String)"messages.securitycraft:thanks").replace("#", SecurityCraft.getVersion()) + " " + StatCollector.func_74838_a((String)"messages.securitycraft:tip") + " " + StatCollector.func_74838_a((String)tipKey) + " ").func_150257_a(ForgeHooks.newChatWithLinks((String)tipsWithLink.get(tipKey.split("\\.")[2]))) : new ChatComponentText("[" + EnumChatFormatting.GOLD + "SecurityCraft" + EnumChatFormatting.WHITE + "] " + StatCollector.func_74838_a((String)"messages.securitycraft:thanks").replace("#", SecurityCraft.getVersion()) + " " + StatCollector.func_74838_a((String)"messages.securitycraft:tip") + " " + StatCollector.func_74838_a((String)tipKey));
        event.player.func_146105_b((IChatComponent)message);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.player) && event.player.field_70154_o instanceof EntitySecurityCamera) {
            event.player.field_70154_o.func_70106_y();
        }
    }

    @SubscribeEvent
    public void onDamageTaken(LivingHurtEvent event) {
        if (event.entityLiving != null && PlayerUtils.isPlayerMountedOnCamera(event.entityLiving)) {
            event.setCanceled(true);
            return;
        }
        if (event.source == CustomDamageSources.electricity) {
            SecurityCraft.network.sendToAll((IMessage)new PacketCPlaySoundAtPos(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, SCSounds.ELECTRIFIED.path, 0.25));
        }
    }

    @SubscribeEvent
    public void onBucketUsed(FillBucketEvent event) {
        ItemStack result = this.fillBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onWorldUnloaded(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            ((ClientProxy)SecurityCraft.proxy).worldViews.clear();
        }
    }

    @SubscribeEvent
    public void onPlayerInteracted(PlayerInteractEvent event) {
        List sentries;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        World world = event.entityPlayer.field_70170_p;
        if (!world.field_72995_K) {
            TileEntity tileEntity = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z);
            Block block = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z);
            if (PlayerUtils.isHoldingItem(event.entityPlayer, SCContent.codebreaker) && this.handleCodebreaking(event)) {
                event.setCanceled(true);
                return;
            }
            if (tileEntity != null && tileEntity instanceof CustomizableSCTE && PlayerUtils.isHoldingItem(event.entityPlayer, SCContent.universalBlockModifier)) {
                event.setCanceled(true);
                if (!((IOwnable)tileEntity).getOwner().isOwner(event.entityPlayer)) {
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, StatCollector.func_74838_a((String)"item.securitycraft:universalBlockModifier.name"), StatCollector.func_74838_a((String)"messages.securitycraft:notOwned").replace("#", ((IOwnable)tileEntity).getOwner().getName()), EnumChatFormatting.RED);
                    return;
                }
                event.entityPlayer.openGui((Object)SecurityCraft.instance, 100, world, event.x, event.y, event.z);
                return;
            }
            if (tileEntity instanceof INameable && ((INameable)tileEntity).canBeNamed() && PlayerUtils.isHoldingItem(event.entityPlayer, Items.field_151057_cb) && event.entityPlayer.func_71045_bC().func_82837_s()) {
                event.setCanceled(true);
                for (String character : new String[]{"(", ")"}) {
                    if (!event.entityPlayer.func_71045_bC().func_82833_r().contains(character)) continue;
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, "Naming", StatCollector.func_74838_a((String)"messages.securitycraft:naming.error").replace("#n", event.entityPlayer.func_71045_bC().func_82833_r()).replace("#c", character), EnumChatFormatting.RED);
                    return;
                }
                if (((INameable)tileEntity).getCustomName().equals(event.entityPlayer.func_71045_bC().func_82833_r())) {
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, "Naming", StatCollector.func_74838_a((String)"messages.securitycraft:naming.alreadyMatches").replace("#n", ((INameable)tileEntity).getCustomName()), EnumChatFormatting.RED);
                    return;
                }
                if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                    --event.entityPlayer.func_71045_bC().field_77994_a;
                }
                ((INameable)tileEntity).setCustomName(event.entityPlayer.func_71045_bC().func_82833_r());
                return;
            }
            if (tileEntity != null && this.isOwnableBlock(block, tileEntity) && PlayerUtils.isHoldingItem(event.entityPlayer, SCContent.universalBlockRemover)) {
                event.setCanceled(true);
                if (!((IOwnable)tileEntity).getOwner().isOwner(event.entityPlayer)) {
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, StatCollector.func_74838_a((String)"item.securitycraft:universalBlockRemover.name"), StatCollector.func_74838_a((String)"messages.securitycraft:notOwned").replace("#", ((IOwnable)tileEntity).getOwner().getName()), EnumChatFormatting.RED);
                    return;
                }
                if (block == SCContent.laserBlock) {
                    world.func_147480_a(event.x, event.y, event.z, true);
                    BlockLaserBlock.destroyAdjacentLasers(event.world, event.x, event.y, event.z);
                    event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
                } else if (block == SCContent.deactivatedCageTrap && ((BlockCageTrap)world.func_147439_a((int)event.x, (int)event.y, (int)event.z)).deactivated) {
                    BlockPos originalPos = new BlockPos(event.x, event.y, event.z);
                    int[] pos = originalPos.east().up().asArray();
                    if (BlockUtils.getBlock(world, pos[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(2).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(3).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up().south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(2).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(3).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(2).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(3).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up().south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(2).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(3).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up().south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up(2).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up(3).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(2).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(3).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up().north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up(2).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up(3).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up().north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(2).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(3).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up().north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(2).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(3).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(4).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(4).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(4).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(4).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(4).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.east().up(4).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.west().up(4).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up(4).south().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up(4).north().asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    if (BlockUtils.getBlock(world, (pos = originalPos.up(4).asArray())[0], pos[1], pos[2]) == SCContent.reinforcedIronBars && ((IOwnable)world.func_147438_o(pos[0], pos[1], pos[2])).getOwner().isOwner(event.entityPlayer)) {
                        BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                    }
                    pos = originalPos.asArray();
                    BlockUtils.destroyBlock(world, pos[0], pos[1], pos[2], false);
                } else {
                    world.func_147480_a(event.x, event.y, event.z, true);
                    world.func_147475_p(event.x, event.y, event.z);
                    event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
                }
                return;
            }
        }
        if (!(sentries = world.func_72872_a(EntitySentry.class, AxisAlignedBB.func_72330_a((double)event.x, (double)event.y, (double)event.z, (double)(event.x + 1), (double)(event.y + 1), (double)(event.z + 1)))).isEmpty()) {
            event.setCanceled(((EntitySentry)((Object)sentries.get(0))).func_70085_c(event.entityPlayer));
        }
    }

    @SubscribeEvent
    public void onBlockEventBreak(BlockEvent.BreakEvent event) {
        List sentries = event.world.func_72872_a(EntitySentry.class, AxisAlignedBB.func_72330_a((double)event.x, (double)event.y, (double)event.z, (double)(event.x + 1), (double)(event.y + 1), (double)(event.z + 1)));
        if (!sentries.isEmpty()) {
            event.setCanceled(true);
            return;
        }
        sentries = event.world.func_72872_a(EntitySentry.class, AxisAlignedBB.func_72330_a((double)event.x, (double)(event.y + 1), (double)event.z, (double)(event.x + 1), (double)(event.y + 2), (double)(event.z + 1)));
        if (!sentries.isEmpty()) {
            ((EntitySentry)((Object)sentries.get(0))).remove();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("securitycraft")) {
            SecurityCraft.configFile.save();
            SecurityCraft.config.setupConfiguration();
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        this.handleOwnableTEs(event);
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.world.field_72995_K && event.world.func_147438_o(event.x, event.y, event.z) != null && event.world.func_147438_o(event.x, event.y, event.z) instanceof CustomizableSCTE) {
            CustomizableSCTE te = (CustomizableSCTE)event.world.func_147438_o(event.x, event.y, event.z);
            for (int i = 0; i < te.getNumberOfCustomizableOptions(); ++i) {
                if (te.itemStacks[i] == null) continue;
                ItemStack stack = te.itemStacks[i];
                EntityItem item = new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, stack);
                event.world.func_72838_d((Entity)item);
                te.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModule());
                te.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, te);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.target instanceof EntityPlayer && event.target != event.entityLiving.func_94060_bK()) {
            if (PlayerUtils.isPlayerMountedOnCamera(event.target)) {
                ((EntityLiving)event.entityLiving).func_70624_b(null);
            }
        } else if (event.target instanceof EntitySentry && event.entityLiving instanceof EntityLiving) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Item held;
        if (event.entityPlayer != null && event.entityPlayer.func_70694_bm() != null && ((held = event.entityPlayer.func_70694_bm().func_77973_b()) == SCContent.universalBlockReinforcerLvL1 || held == SCContent.universalBlockReinforcerLvL2 || held == SCContent.universalBlockReinforcerLvL3)) {
            for (Block rb : IReinforcedBlock.BLOCKS) {
                IReinforcedBlock reinforcedBlock = (IReinforcedBlock)rb;
                if (!reinforcedBlock.getVanillaBlocks().contains(event.block)) continue;
                event.newSpeed = 10000.0f;
                return;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRendered(RenderPlayerEvent.Pre event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70165_t) == (double)event.target.field_72311_b && Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70163_u == (double)event.target.field_72312_c && Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70161_v) == (double)event.target.field_72309_d) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (Minecraft.func_71410_x().field_71439_g != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE && Minecraft.func_71410_x().field_71441_e.func_147439_a((int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70161_v)) instanceof BlockSecurityCamera) {
                GuiUtils.drawCameraOverlay(Minecraft.func_71410_x(), (Gui)Minecraft.func_71410_x().field_71456_v, event.resolution, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70161_v), event.mouseX, event.mouseY);
            }
        } else if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            World world = player.func_130014_f_();
            int held = player.field_71071_by.field_70461_c;
            if (held < 0 || held >= player.field_71071_by.field_70462_a.length) {
                return;
            }
            ItemStack monitor = player.field_71071_by.field_70462_a[held];
            if (monitor != null && monitor.func_77973_b() == SCContent.cameraMonitor) {
                String textureToUse = "cameraNotBound";
                double eyeHeight = player.func_70047_e();
                Vec3 lookVec = Vec3.func_72443_a((double)(player.field_70165_t + player.func_70040_Z().field_72450_a * 5.0), (double)(eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * 5.0), (double)(player.field_70161_v + player.func_70040_Z().field_72449_c * 5.0));
                MovingObjectPosition mop = world.func_72933_a(Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v), lookVec);
                if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) instanceof TileEntitySecurityCamera) {
                    NBTTagCompound cameras = monitor.func_77978_p();
                    if (cameras != null) {
                        for (int i = 1; i < 31; ++i) {
                            String[] coords;
                            if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.field_72311_b || Integer.parseInt(coords[1]) != mop.field_72312_c || Integer.parseInt(coords[2]) != mop.field_72309_d) continue;
                            textureToUse = "cameraBound";
                            break;
                        }
                    }
                    GL11.glEnable((int)3042);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    this.drawNonStandardTexturedRect(event.resolution.func_78326_a() / 2 - 90 + held * 20 + 2, event.resolution.func_78328_b() - 16 - 3, 0, 0, 16, 16, 16, 16);
                    GL11.glDisable((int)3042);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.entity)) {
            event.newfov = ((EntitySecurityCamera)event.entity.field_70154_o).getZoomAmount();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseClicked(MouseEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    private void drawNonStandardTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        double z = 200.0;
        double widthFactor = 1.0 / (double)textureWidth;
        double heightFactor = 1.0 / (double)textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), z, (double)u * widthFactor, (double)(v + height) * heightFactor);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), z, (double)(u + width) * widthFactor, (double)(v + height) * heightFactor);
        tessellator.func_78374_a((double)(x + width), (double)y, z, (double)(u + width) * widthFactor, (double)v * heightFactor);
        tessellator.func_78374_a((double)x, (double)y, z, (double)u * widthFactor, (double)v * heightFactor);
        tessellator.func_78381_a();
    }

    private String getRandomTip() {
        String[] tips = new String[]{"messages.tip.scHelp", "messages.tip.trello", "messages.tip.patreon", "messages.tip.discord", "messages.tip.scserver"};
        return tips[new Random().nextInt(tips.length)];
    }

    private ItemStack fillBucket(World world, MovingObjectPosition position) {
        Block block = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
        if (block == SCContent.bogusWater) {
            world.func_147468_f(position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return new ItemStack(SCContent.fWaterBucket, 1);
        }
        if (block == SCContent.bogusLava) {
            world.func_147468_f(position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return new ItemStack(SCContent.fLavaBucket, 1);
        }
        return null;
    }

    private void handleOwnableTEs(BlockEvent.PlaceEvent event) {
        if (event.world.func_147438_o(event.x, event.y, event.z) instanceof IOwnable) {
            String name = event.player.func_70005_c_();
            String uuid = event.player.func_146103_bH().getId().toString();
            ((IOwnable)event.world.func_147438_o(event.x, event.y, event.z)).getOwner().set(uuid, name);
        }
    }

    private boolean handleCodebreaking(PlayerInteractEvent event) {
        World world = event.entityPlayer.field_70170_p;
        TileEntity tileEntity = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z);
        if (SecurityCraft.config.allowCodebreakerItem) {
            event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
        }
        if (tileEntity != null && tileEntity instanceof IPasswordProtected && new Random().nextInt(3) == 1) {
            return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_72805_g(event.x, event.y, event.z), event.entityPlayer, !SecurityCraft.config.allowCodebreakerItem);
        }
        return false;
    }

    private boolean isOwnableBlock(Block block, TileEntity tileEntity) {
        return tileEntity instanceof TileEntityOwnable || tileEntity instanceof IOwnable || block instanceof BlockOwnable;
    }
}

