/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.google.common.collect.Ordering;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCEventHandler;
import net.geforcemods.securitycraft.SetupHandler;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.commands.CommandModule;
import net.geforcemods.securitycraft.commands.CommandSC;
import net.geforcemods.securitycraft.compat.lookingglass.IWorldViewHelper;
import net.geforcemods.securitycraft.compat.lookingglass.LookingGlassPanelRenderer;
import net.geforcemods.securitycraft.compat.versionchecker.VersionUpdateChecker;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.tabs.CreativeTabSCDecoration;
import net.geforcemods.securitycraft.tabs.CreativeTabSCExplosives;
import net.geforcemods.securitycraft.tabs.CreativeTabSCTechnical;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="securitycraft", name="SecurityCraft", version="v1.8.12", guiFactory="net.geforcemods.securitycraft.gui.SecurityCraftGuiFactory", dependencies="required-after:Forge@[10.13.4.1558,);after:LookingGlass@[0.2.0.01,);")
public class SecurityCraft {
    public static boolean debug;
    public static final String MODID = "securitycraft";
    private static final String MOTU = "Finally! Cameras!";
    protected static final String VERSION = "v1.8.12";
    protected static final String DEPENDENCIES = "required-after:Forge@[10.13.4.1558,);after:LookingGlass@[0.2.0.01,);";
    @SidedProxy(clientSide="net.geforcemods.securitycraft.network.ClientProxy", serverSide="net.geforcemods.securitycraft.network.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="securitycraft")
    public static SecurityCraft instance;
    public static ConfigHandler config;
    public static SimpleNetworkWrapper network;
    public static SCEventHandler eventHandler;
    private GuiHandler guiHandler = new GuiHandler();
    public LookingGlassPanelRenderer lgPanelRenderer;
    public ArrayList<SCManualPage> manualPages = new ArrayList();
    private NBTTagCompound savedModule;
    public static Configuration configFile;
    public static CreativeTabs tabSCTechnical;
    public static CreativeTabs tabSCMine;
    public static CreativeTabs tabSCDecoration;

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSC());
        event.registerServerCommand((ICommand)new CommandModule());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        SecurityCraft.log("Starting to load....");
        SecurityCraft.log("Loading config file....");
        SecurityCraft.log("v1.8.12 of SecurityCraft is for a post MC-1.6.4 version! Configuration files are useless for setting anything besides options.");
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        config.setupConfiguration();
        SecurityCraft.log("Config file loaded.");
        SecurityCraft.log("Setting up handlers!");
        SecurityCraft.log("Handlers registered.");
        SecurityCraft.log("Setting up network....");
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        RegistrationHandler.registerPackets(network);
        SecurityCraft.log("Network setup.");
        SecurityCraft.log("Loading mod content....");
        SetupHandler.setupBlocks();
        SetupHandler.setupMines();
        SetupHandler.setupItems();
        SecurityCraft.log("Finished loading mod content.");
        SecurityCraft.log("Regisering mod content... (PT 1/2)");
        RegistrationHandler.registerContent();
        RegistrationHandler.registerTileEntities();
        RegistrationHandler.registerRecipes();
        SecurityCraft.log("Sorting items...");
        ArrayList<Item> technicalItems = new ArrayList<Item>();
        for (SCManualPage page : this.manualPages) {
            technicalItems.add(page.getItem());
        }
        CreativeTabSCTechnical.itemSorter = Ordering.explicit(technicalItems).onResultOf(item -> item.func_77973_b());
        ModMetadata modMeta = event.getModMetadata();
        modMeta.authorList = Arrays.asList("Geforce", "bl4ckscor3");
        modMeta.autogenerated = false;
        modMeta.credits = "Thanks to all of you guys for your support!";
        modMeta.description = "Adds a load of things to keep your house safe with.\nIf you like this mod, hit the green arrow\nin the corner of the forum thread!\nPlease visit the URL above for help. \n \nMessage of the update: \nFinally! Cameras!";
        modMeta.url = "http://geforcemods.net";
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NBTTagCompound vcUpdateTag;
        SecurityCraft.log("Setting up inter-mod stuff...");
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"net.geforcemods.securitycraft.compat.waila.WailaDataProvider.callbackRegister");
        FMLInterModComms.sendMessage((String)"LookingGlass", (String)"API", (String)"net.geforcemods.securitycraft.compat.lookingglass.LookingGlassAPIProvider.register");
        if (SecurityCraft.config.checkForUpdates && (vcUpdateTag = VersionUpdateChecker.getNBTTagCompound()) != null) {
            FMLInterModComms.sendRuntimeMessage((Object)MODID, (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)vcUpdateTag);
        }
        SecurityCraft.log("Registering mod content... (PT 2/2)");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        RegistrationHandler.registerEntities();
        EnumCustomModules.refresh();
        proxy.registerRenderThings();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        for (Field field : SCContent.class.getFields()) {
            try {
                if (!field.isAnnotationPresent(Reinforced.class)) continue;
                IReinforcedBlock.BLOCKS.add((Block)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        SecurityCraft.log("Mod finished loading correctly! :D");
    }

    public NBTTagCompound getSavedModule() {
        return this.savedModule;
    }

    public void setSavedModule(NBTTagCompound savedModule) {
        this.savedModule = savedModule;
    }

    public LookingGlassPanelRenderer getLGPanelRenderer() {
        return SecurityCraft.instance.lgPanelRenderer;
    }

    public IWorldViewHelper getViewFromCoords(String coords) {
        return ((ClientProxy)SecurityCraft.proxy).worldViews.get(coords);
    }

    public boolean hasViewForCoords(String coords) {
        return ((ClientProxy)SecurityCraft.proxy).worldViews.containsKey(coords);
    }

    public void removeViewForCoords(String coords) {
        ((ClientProxy)SecurityCraft.proxy).worldViews.remove(coords);
    }

    public boolean useLookingGlass() {
        return Loader.isModLoaded((String)"LookingGlass") && config != null && SecurityCraft.config.useLookingGlass;
    }

    public static void log(String line) {
        SecurityCraft.log(line, false);
    }

    public static void log(String line, boolean isSevereError) {
        if (debug) {
            System.out.println(isSevereError ? "{SecurityCraft} {" + FMLCommonHandler.instance().getEffectiveSide() + "} {Severe}: " + line : "[SecurityCraft] [" + FMLCommonHandler.instance().getEffectiveSide() + "] " + line);
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    static {
        instance = new SecurityCraft();
        config = new ConfigHandler();
        eventHandler = new SCEventHandler();
        tabSCTechnical = new CreativeTabSCTechnical();
        tabSCMine = new CreativeTabSCExplosives();
        tabSCDecoration = new CreativeTabSCDecoration();
    }
}

