/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.network.packets.PacketSUpdateSliderValue;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    public Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    public Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public void toggle() {
    }

    public void copy(Option<?> option) {
        this.value = option.getValue();
    }

    public boolean asBoolean() {
        return (Boolean)this.value;
    }

    public int asInteger() {
        return (Integer)this.value;
    }

    public double asDouble() {
        return (Double)this.value;
    }

    public float asFloat() {
        return ((Float)this.value).floatValue();
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (this.value instanceof Boolean) {
            this.value = tag.func_74767_n(this.name);
        } else if (this.value instanceof Integer) {
            this.value = tag.func_74762_e(this.name);
        } else if (this.value instanceof Double) {
            this.value = tag.func_74769_h(this.name);
        } else if (this.value instanceof Float) {
            this.value = Float.valueOf(tag.func_74760_g(this.name));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.value instanceof Boolean) {
            tag.func_74757_a(this.name, this.asBoolean());
        } else if (this.value instanceof Integer) {
            tag.func_74768_a(this.name, this.asInteger());
        } else if (this.value instanceof Double) {
            tag.func_74780_a(this.name, this.asDouble());
        } else if (this.value instanceof Float) {
            tag.func_74776_a(this.name, this.asFloat());
        }
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public static class OptionFloat
    extends Option<Float> {
        public OptionFloat(String optionName, Float value) {
            super(optionName, value);
        }

        public OptionFloat(String optionName, Float value, Float min, Float max, Float increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
            if (this.getValue().floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMin());
                return;
            }
            if (this.getValue().floatValue() + ((Float)this.getIncrement()).floatValue() >= ((Float)this.getMax()).floatValue()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue(Float.valueOf(this.getValue().floatValue() + ((Float)this.getIncrement()).floatValue()));
        }

        @Override
        public Float getValue() {
            return (Float)this.value;
        }

        public String toString() {
            return Float.toString(((Float)this.value).floatValue()).length() > 5 ? Float.toString(((Float)this.value).floatValue()).substring(0, 5) : Float.toString(((Float)this.value).floatValue());
        }
    }

    public static class OptionDouble
    extends Option<Double>
    implements GuiSlider.ISlider {
        private boolean slider;
        private CustomizableSCTE tileEntity;

        public OptionDouble(String optionName, Double value) {
            super(optionName, value);
            this.slider = false;
        }

        public OptionDouble(String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
            this.slider = false;
        }

        public OptionDouble(CustomizableSCTE te, String optionName, Double value, Double min, Double max, Double increment, boolean s) {
            super(optionName, value, min, max, increment);
            this.slider = s;
            this.tileEntity = te;
        }

        @Override
        public void toggle() {
            if (this.isSlider()) {
                return;
            }
            if (this.getValue() >= (Double)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if (this.getValue() + (Double)this.getIncrement() >= (Double)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue(this.getValue() + (Double)this.getIncrement());
        }

        @Override
        public Double getValue() {
            return (double)((Double)this.value);
        }

        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        public boolean isSlider() {
            return this.slider;
        }

        @Override
        public void onChangeSliderValue(GuiSlider slider, String blockName, int id) {
            if (!this.isSlider()) {
                return;
            }
            this.setValue(slider.getValue());
            slider.field_146126_j = (StatCollector.func_74838_a((String)("option." + blockName + "." + this.getName())) + " ").replace("#", this.toString());
            SecurityCraft.network.sendToServer((IMessage)new PacketSUpdateSliderValue(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, id, this.getValue()));
        }
    }

    public static class OptionInt
    extends Option<Integer> {
        public OptionInt(String optionName, Integer value) {
            super(optionName, value);
        }

        public OptionInt(String optionName, Integer value, Integer min, Integer max, Integer increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
            if (this.getValue() >= (Integer)this.getMax()) {
                this.setValue(this.getMin());
                return;
            }
            if (this.getValue() + (Integer)this.getIncrement() >= (Integer)this.getMax()) {
                this.setValue(this.getMax());
                return;
            }
            this.setValue(this.getValue() + (Integer)this.getIncrement());
        }

        @Override
        public Integer getValue() {
            return (int)((Integer)this.value);
        }

        public String toString() {
            return this.value + "";
        }
    }

    public static class OptionBoolean
    extends Option<Boolean> {
        public OptionBoolean(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue(this.getValue() == false);
        }

        @Override
        public Boolean getValue() {
            return (boolean)((Boolean)this.value);
        }

        public String toString() {
            return this.value + "";
        }
    }
}

