/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCageTrap
extends BlockOwnable {
    public final boolean deactivated;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;

    public BlockCageTrap(Material material, boolean deactivated) {
        super(material);
        this.deactivated = deactivated;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (!this.deactivated) {
            return null;
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K) {
            TileEntityCageTrap tileEntity = (TileEntityCageTrap)world.func_147438_o(x, y, z);
            boolean isPlayer = entity instanceof EntityPlayer;
            boolean shouldCaptureMobs = tileEntity.getOptionByName("captureMobs").asBoolean();
            if ((isPlayer || entity instanceof EntityMob) && !this.deactivated) {
                IOwnable originalTrap = (IOwnable)world.func_147438_o(x, y, z);
                if (isPlayer && originalTrap.getOwner().isOwner((EntityPlayer)entity)) {
                    return;
                }
                if (!isPlayer && !shouldCaptureMobs) {
                    return;
                }
                world.func_147449_b(x, y, z, SCContent.deactivatedCageTrap);
                world.func_147449_b(x, y + 4, z, SCContent.reinforcedIronBars);
                world.func_147449_b(x + 1, y + 4, z, SCContent.reinforcedIronBars);
                world.func_147449_b(x - 1, y + 4, z, SCContent.reinforcedIronBars);
                world.func_147449_b(x, y + 4, z + 1, SCContent.reinforcedIronBars);
                world.func_147449_b(x, y + 4, z - 1, SCContent.reinforcedIronBars);
                BlockUtils.setBlockInBox(world, x, y, z, SCContent.reinforcedIronBars);
                this.setTileEntities(world, x, y, z, originalTrap.getOwner().getUUID(), originalTrap.getOwner().getName());
                world.func_72908_a((double)x, (double)y, (double)z, "random.anvil_use", 3.0f, 1.0f);
                if (isPlayer) {
                    MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("[" + EnumChatFormatting.BLACK + StatCollector.func_74838_a((String)"tile.securitycraft:cageTrap.name") + EnumChatFormatting.RESET + "] " + StatCollector.func_74838_a((String)"messages.securitycraft:cageTrap.captured").replace("#player", ((EntityPlayer)entity).func_70005_c_()).replace("#location", Utils.getFormattedCoordinates(x, y, z))));
                }
            }
        }
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public int func_149745_a(Random par1Random) {
        return this.deactivated ? 0 : 1;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return this.deactivated ? Item.func_150898_a((Block)SCContent.deactivatedCageTrap) : Item.func_150898_a((Block)this);
    }

    public void setTileEntities(World world, int x, int y, int z, String uuid, String name) {
        ((IOwnable)world.func_147438_o(x, y, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 4, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 4, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 4, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 4, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 4, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 1, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 2, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 3, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 1, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 2, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 3, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 1, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 2, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 3, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 1, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 2, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 3, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 1, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 2, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 3, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 1, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 2, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 3, z)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 1, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 2, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x, y + 3, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 1, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 2, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 3, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 1, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 2, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 3, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 4, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x + 1, y + 4, z - 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 4, z + 1)).getOwner().set(uuid, name);
        ((IOwnable)world.func_147438_o(x - 1, y + 4, z - 1)).getOwner().set(uuid, name);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCageTrap();
    }
}

