/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockInventoryScanner
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon furnaceIconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon furnaceIconFront;

    public BlockInventoryScanner(Material material) {
        super(material);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block north = world.func_147439_a(x, y, z - 1);
            Block south = world.func_147439_a(x, y, z + 1);
            Block west = world.func_147439_a(x - 1, y, z);
            Block east = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (north.func_149730_j() && !south.func_149730_j()) {
                b0 = 3;
            }
            if (south.func_149730_j() && !north.func_149730_j()) {
                b0 = 2;
            }
            if (west.func_149730_j() && !east.func_149730_j()) {
                b0 = 5;
            }
            if (east.func_149730_j() && !west.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, z, b0, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isFacingAnotherScanner(world, x, y, z)) {
            player.openGui((Object)SecurityCraft.instance, 6, world, x, y, z);
        } else {
            PlayerUtils.sendMessageToPlayer(player, StatCollector.func_74838_a((String)"tile.securitycraft:inventoryScanner.name"), StatCollector.func_74838_a((String)"messages.securitycraft:invScan.notConnected"), EnumChatFormatting.RED);
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        int entityRotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (entityRotation == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (entityRotation == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (entityRotation == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (entityRotation == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        this.checkAndPlaceAppropriately(world, x, y, z);
    }

    private void checkAndPlaceAppropriately(World world, int x, int y, int z) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, x, y, z);
        if (connectedScanner == null) {
            return;
        }
        boolean place = true;
        if (world.func_72805_g(x, y, z) == 4) {
            int j;
            for (j = 1; j < Math.abs(x - connectedScanner.field_145851_c); ++j) {
                if (world.func_147439_a(x - j, y, z) != SCContent.inventoryScannerField) continue;
                place = false;
                break;
            }
            if (place) {
                for (j = 1; j < Math.abs(x - connectedScanner.field_145851_c); ++j) {
                    world.func_147465_d(x - j, y, z, SCContent.inventoryScannerField, 1, 3);
                }
            }
        } else if (world.func_72805_g(x, y, z) == 5) {
            int j;
            for (j = 1; j < Math.abs(x - connectedScanner.field_145851_c); ++j) {
                if (world.func_147439_a(x + j, y, z) != SCContent.inventoryScannerField) continue;
                place = false;
                break;
            }
            if (place) {
                for (j = 1; j < Math.abs(x - connectedScanner.field_145851_c); ++j) {
                    world.func_147465_d(x + j, y, z, SCContent.inventoryScannerField, 1, 3);
                }
            }
        } else if (world.func_72805_g(x, y, z) == 2) {
            int j;
            for (j = 1; j < Math.abs(z - connectedScanner.field_145849_e); ++j) {
                if (world.func_147439_a(x, y, z - j) != SCContent.inventoryScannerField) continue;
                place = false;
                break;
            }
            if (place) {
                for (j = 1; j < Math.abs(z - connectedScanner.field_145849_e); ++j) {
                    world.func_147465_d(x, y, z - j, SCContent.inventoryScannerField, 2, 3);
                }
            }
        } else if (world.func_72805_g(x, y, z) == 3) {
            int j;
            for (j = 1; j < Math.abs(z - connectedScanner.field_145849_e); ++j) {
                if (world.func_147439_a(x, y, z + j) != SCContent.inventoryScannerField) continue;
                place = false;
                break;
            }
            if (place) {
                for (j = 1; j < Math.abs(z - connectedScanner.field_145849_e); ++j) {
                    world.func_147465_d(x, y, z + j, SCContent.inventoryScannerField, 2, 3);
                }
            }
        }
        if (place) {
            CustomizableSCTE.link((CustomizableSCTE)world.func_147438_o(x, y, z), connectedScanner);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        int j;
        int i;
        if (world.field_72995_K) {
            return;
        }
        TileEntityInventoryScanner connectedScanner = null;
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (world.func_147439_a(x - j, y, z) != SCContent.inventoryScannerField || world.func_72805_g(x - j, y, z) != 1) continue;
                world.func_147480_a(x - j, y, z, false);
            }
            connectedScanner = (TileEntityInventoryScanner)world.func_147438_o(x - i, y, z);
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (world.func_147439_a(x + i, y, z) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (world.func_147439_a(x + j, y, z) != SCContent.inventoryScannerField || world.func_72805_g(x + j, y, z) != 1) continue;
                world.func_147480_a(x + j, y, z, false);
            }
            connectedScanner = (TileEntityInventoryScanner)world.func_147438_o(x + i, y, z);
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (world.func_147439_a(x, y, z - j) != SCContent.inventoryScannerField || world.func_72805_g(x, y, z - j) != 2) continue;
                world.func_147480_a(x, y, z - j, false);
            }
            connectedScanner = (TileEntityInventoryScanner)world.func_147438_o(x, y, z - i);
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (world.func_147439_a(x, y, z + i) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (world.func_147439_a(x, y, z + j) != SCContent.inventoryScannerField || world.func_72805_g(x, y, z + j) != 2) continue;
                world.func_147480_a(x, y, z + j, false);
            }
            connectedScanner = (TileEntityInventoryScanner)world.func_147438_o(x, y, z + i);
            break;
        }
        for (i = 10; i < ((TileEntityInventoryScanner)world.func_147438_o(x, y, z)).getContents().length; ++i) {
            if (((TileEntityInventoryScanner)world.func_147438_o(x, y, z)).getContents()[i] == null) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, ((TileEntityInventoryScanner)world.func_147438_o(x, y, z)).getContents()[i]));
        }
        if (connectedScanner != null) {
            for (i = 0; i < connectedScanner.getContents().length; ++i) {
                connectedScanner.getContents()[i] = null;
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    private boolean isFacingAnotherScanner(World world, int x, int y, int z) {
        return BlockInventoryScanner.getConnectedInventoryScanner(world, x, y, z) != null;
    }

    public static TileEntityInventoryScanner getConnectedInventoryScanner(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 4: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x - i, y, z) != Blocks.field_150350_a && world.func_147439_a(x - i, y, z) != SCContent.inventoryScannerField && world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner || world.func_72805_g(x - i, y, z) != 5) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x - i, y, z);
                    }
                }
                return null;
            }
            case 5: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x + i, y, z) != Blocks.field_150350_a && world.func_147439_a(x + i, y, z) != SCContent.inventoryScannerField && world.func_147439_a(x + i, y, z) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x + i, y, z) != SCContent.inventoryScanner || world.func_72805_g(x + i, y, z) != 4) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x + i, y, z);
                    }
                }
                return null;
            }
            case 2: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x, y, z - i) != Blocks.field_150350_a && world.func_147439_a(x, y, z - i) != SCContent.inventoryScannerField && world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner || world.func_72805_g(x, y, z - i) != 3) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x, y, z - i);
                    }
                    return null;
                }
                if (world.func_147439_a(x, y, z) != SCContent.inventoryScannerField) break;
                for (int i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                    if (world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner) continue;
                    return (TileEntityInventoryScanner)world.func_147438_o(x, y, z - i);
                }
                break;
            }
            case 3: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x, y, z + i) != Blocks.field_150350_a && world.func_147439_a(x, y, z + i) != SCContent.inventoryScannerField && world.func_147439_a(x, y, z + i) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x, y, z + i) != SCContent.inventoryScanner || world.func_72805_g(x, y, z + i) != 2) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x, y, z + i);
                    }
                }
                return null;
            }
            case 1: {
                if (world.func_147439_a(x, y, z) != SCContent.inventoryScannerField) break;
                for (int i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                    if (world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner) continue;
                    return (TileEntityInventoryScanner)world.func_147438_o(x - i, y, z);
                }
                break;
            }
        }
        return null;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess access, int x, int y, int z, int side) {
        if (!(access.func_147438_o(x, y, z) instanceof TileEntityInventoryScanner) || ((TileEntityInventoryScanner)access.func_147438_o(x, y, z)).getType() == null) {
            return 0;
        }
        return ((TileEntityInventoryScanner)access.func_147438_o(x, y, z)).getType().equals("redstone") && ((TileEntityInventoryScanner)access.func_147438_o(x, y, z)).shouldProvidePower() ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess access, int x, int y, int z, int side) {
        if (((TileEntityInventoryScanner)access.func_147438_o(x, y, z)).getType() == null) {
            return 0;
        }
        return ((TileEntityInventoryScanner)access.func_147438_o(x, y, z)).getType().equals("redstone") && ((TileEntityInventoryScanner)access.func_147438_o(x, y, z)).shouldProvidePower() ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 3 && meta == 0) {
            return this.furnaceIconFront;
        }
        return side == 1 ? this.furnaceIconTop : (side == 0 ? this.furnaceIconTop : (side != meta ? this.field_149761_L : this.furnaceIconFront));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("furnace_side");
        this.furnaceIconFront = register.func_94245_a("securitycraft:inventoryScanner");
        this.furnaceIconTop = register.func_94245_a("furnace_top");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityInventoryScanner();
    }
}

