/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.items.ItemKeycardBase;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockKeycardReader
extends BlockOwnable {
    @SideOnly(value=Side.CLIENT)
    private IIcon keypadIconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon keypadIconFront;

    public BlockKeycardReader(Material material) {
        super(material);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        int entityRotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (entityRotation == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (entityRotation == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (entityRotation == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (entityRotation == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public void insertCard(World world, int x, int y, int z, ItemStack stack, EntityPlayer player) {
        if (ModuleUtils.checkForModule(world, x, y, z, player, EnumCustomModules.WHITELIST) || ModuleUtils.checkForModule(world, x, y, z, player, EnumCustomModules.BLACKLIST)) {
            return;
        }
        int requiredLevel = -1;
        int cardLvl = ((ItemKeycardBase)stack.func_77973_b()).getKeycardLvl(stack);
        if (((TileEntityKeycardReader)world.func_147438_o(x, y, z)).getPassword() != null) {
            requiredLevel = Integer.parseInt(((TileEntityKeycardReader)world.func_147438_o(x, y, z)).getPassword());
        }
        if (!((TileEntityKeycardReader)world.func_147438_o(x, y, z)).doesRequireExactKeycard() && requiredLevel <= cardLvl || ((TileEntityKeycardReader)world.func_147438_o(x, y, z)).doesRequireExactKeycard() && requiredLevel == cardLvl) {
            if (cardLvl == 6 && stack.func_77978_p() != null && !player.field_71075_bZ.field_75098_d) {
                stack.func_77978_p().func_74768_a("Uses", stack.func_77978_p().func_74762_e("Uses") - 1);
                if (stack.func_77978_p().func_74762_e("Uses") <= 0) {
                    --stack.field_77994_a;
                }
            }
            BlockKeycardReader.activate(world, x, y, z);
        }
        if (!world.field_72995_K) {
            if (requiredLevel != -1 && ((TileEntityKeycardReader)world.func_147438_o(x, y, z)).doesRequireExactKeycard() && requiredLevel != cardLvl) {
                PlayerUtils.sendMessageToPlayer(player, StatCollector.func_74838_a((String)"tile.securitycraft:keycardReader.name"), StatCollector.func_74838_a((String)"messages.securitycraft:keycardReader.required").replace("#r", ((IPasswordProtected)world.func_147438_o(x, y, z)).getPassword()).replace("#c", "" + cardLvl), EnumChatFormatting.RED);
            } else if (requiredLevel == -1) {
                PlayerUtils.sendMessageToPlayer(player, StatCollector.func_74838_a((String)"tile.securitycraft:keycardReader.name"), StatCollector.func_74838_a((String)"messages.securitycraft:keycardReader.notSet"), EnumChatFormatting.RED);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof ItemKeycardBase) && player.func_71045_bC().func_77973_b() != SCContent.adminTool) {
            ((TileEntityKeycardReader)world.func_147438_o(x, y, z)).openPasswordGUI(player);
        } else if (player.func_71045_bC().func_77973_b() == SCContent.adminTool) {
            ((BlockKeycardReader)world.func_147439_a(x, y, z)).insertCard(world, x, y, z, new ItemStack(SCContent.keycards, 1, 3), player);
        } else if (BlockUtils.isMetadataBetween((IBlockAccess)world, x, y, z, 2, 5)) {
            ((BlockKeycardReader)world.func_147439_a(x, y, z)).insertCard(world, x, y, z, player.func_71045_bC(), player);
        }
        return true;
    }

    public static void activate(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) + 5, 3);
        world.func_147459_d(x, y, z, SCContent.keycardReader);
        world.func_147464_a(x, y, z, SCContent.keycardReader, 60);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) > 6 && world.func_72805_g(x, y, z) < 11) {
            world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) - 5, 3);
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_72805_g(x, y, z) > 6 && world.func_72805_g(x, y, z) < 11) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 6 && meta < 11) {
            double spawnX = (double)((float)x + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double spawnY = (double)((float)y + 0.7f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double spawnZ = (double)((float)z + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_72869_a("reddust", spawnX - magicNumber2, spawnY + magicNumber1, spawnZ, 0.0, 0.0, 0.0);
            world.func_72869_a("reddust", spawnX + magicNumber2, spawnY + magicNumber1, spawnZ, 0.0, 0.0, 0.0);
            world.func_72869_a("reddust", spawnX, spawnY + magicNumber1, spawnZ - magicNumber2, 0.0, 0.0, 0.0);
            world.func_72869_a("reddust", spawnX, spawnY + magicNumber1, spawnZ + magicNumber2, 0.0, 0.0, 0.0);
            world.func_72869_a("reddust", spawnX, spawnY, spawnZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 3 && meta == 0) {
            return this.keypadIconFront;
        }
        if (meta == 7 || meta == 8 || meta == 9 || meta == 10) {
            return side == 1 ? this.keypadIconTop : (side == 0 ? this.keypadIconTop : (side != meta - 5 ? this.field_149761_L : this.keypadIconFront));
        }
        return side == 1 ? this.keypadIconTop : (side == 0 ? this.keypadIconTop : (side != meta ? this.field_149761_L : this.keypadIconFront));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("furnace_side");
        this.keypadIconTop = register.func_94245_a("furnace_top");
        this.keypadIconFront = register.func_94245_a("securitycraft:keycardReaderFront");
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityKeycardReader();
    }
}

