/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.entity.EntityBouncingBetty;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBouncingBetty
extends BlockExplosive
implements IExplosive {
    @SideOnly(value=Side.CLIENT)
    private IIcon defusedIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;

    public BlockBouncingBetty(Material material) {
        super(material);
        this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.2f, 0.8f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149683_g() {
        this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.2f, 0.8f);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x, y - 1, z, ForgeDirection.UP);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, x, y, z);
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.explode(world, x, y, z);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!world.field_72995_K) {
            if (player != null && player.field_71075_bZ.field_75098_d && !SecurityCraft.config.mineExplodesWhenInCreative) {
                return super.removedByPlayer(world, player, x, y, z, willHarvest);
            }
            this.explode(world, x, y, z);
            return super.removedByPlayer(world, player, x, y, z, willHarvest);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    @Override
    public void activateMine(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 0, 3);
    }

    @Override
    public void defuseMine(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 1, 3);
    }

    @Override
    public void explode(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 1) {
            return;
        }
        world.func_147468_f(x, y, z);
        EntityBouncingBetty bouncingBetty = new EntityBouncingBetty(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        bouncingBetty.fuse = 15;
        bouncingBetty.field_70181_x = 0.5;
        world.func_72838_d((Entity)bouncingBetty);
        world.func_72956_a((Entity)bouncingBetty, "game.tnt.primed", 1.0f, 1.0f);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int x) {
        return x == 0 ? this.activeIcon : this.defusedIcon;
    }

    public void func_149651_a(IIconRegister register) {
        this.activeIcon = register.func_94245_a("securitycraft:bouncingBettyActive");
        this.defusedIcon = register.func_94245_a("securitycraft:bouncingBettyDefused");
    }

    @Override
    public boolean isActive(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 0;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }
}

