/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.lookingglass;

import com.xcompwiz.lookingglass.api.APIInstanceProvider;
import com.xcompwiz.lookingglass.api.APIUndefined;
import com.xcompwiz.lookingglass.api.APIVersionRemoved;
import com.xcompwiz.lookingglass.api.APIVersionUndefined;
import com.xcompwiz.lookingglass.api.animator.ICameraAnimator;
import com.xcompwiz.lookingglass.api.view.IWorldView;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.compat.lookingglass.CameraAnimatorSecurityCamera;
import net.geforcemods.securitycraft.compat.lookingglass.IWorldViewHelper;
import net.geforcemods.securitycraft.compat.lookingglass.LookingGlassAPIHandler;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LookingGlassAPIProvider {
    public static void register(APIInstanceProvider provider) {
        try {
            Object viewAPI = provider.getAPIInstance("view-2");
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                LookingGlassAPIHandler.handleAPICast(viewAPI);
            }
        }
        catch (APIUndefined e) {
            e.printStackTrace();
        }
        catch (APIVersionUndefined e) {
            e.printStackTrace();
        }
        catch (APIVersionRemoved e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void createLookingGlassView(World world, int dimension, int xCoord, int yCoord, int zCoord, int viewWidth, int viewHeight) {
        if (!Loader.isModLoaded((String)"LookingGlass")) {
            return;
        }
        IWorldView lgView = SecurityCraft.instance.getLGPanelRenderer().getApi().createWorldView(Integer.valueOf(dimension), new ChunkCoordinates(xCoord, yCoord, zCoord), viewWidth, viewHeight);
        lgView.setAnimator((ICameraAnimator)new CameraAnimatorSecurityCamera(lgView.getCamera(), xCoord, yCoord, zCoord, world.func_72805_g(xCoord, yCoord, zCoord)));
        if (!SecurityCraft.instance.hasViewForCoords(xCoord + " " + yCoord + " " + zCoord + " " + dimension)) {
            SecurityCraft.log("Inserting new view at" + Utils.getFormattedCoordinates(xCoord, yCoord, zCoord));
            ((ClientProxy)SecurityCraft.proxy).worldViews.put(xCoord + " " + yCoord + " " + zCoord + " " + dimension, new IWorldViewHelper(lgView));
        }
    }
}

