/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.ai.EntityAIAttackRangedIfEnabled;
import net.geforcemods.securitycraft.entity.ai.EntityAITargetNearestPlayerOrMob;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.network.packets.PacketCInitSentryAnimation;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntitySentry
extends EntityCreature
implements IRangedAttackMob {
    private static final int OWNER_NAME = 16;
    private static final int OWNER_UUID = 17;
    private static final int MODULE = 18;
    private static final int MODE = 19;
    public static final int HEAD_ROTATION = 20;
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private float headYTranslation = 0.9f;
    private final float animationStepSize = 0.025f;
    public boolean animateUpwards = true;
    public boolean animate = false;
    private long previousTargetId = Long.MIN_VALUE;
    private static Random notRandom = new NotRandom();

    public EntitySentry(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.initEntityAI();
    }

    public EntitySentry(World world, EntityPlayer owner) {
        this(world, new Owner(owner.func_70005_c_(), EntityPlayer.func_146094_a((GameProfile)owner.func_146103_bH()).toString()));
    }

    public EntitySentry(World world, Owner owner) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70180_af.func_75692_b(16, (Object)owner.getName());
        this.field_70180_af.func_75692_b(17, (Object)owner.getUUID());
        this.initEntityAI();
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    private void initEntityAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRangedIfEnabled(this, 0.0, 5, 10.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetNearestPlayerOrMob(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)"");
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(18, (Object)new ItemStack(Blocks.field_150348_b));
        this.field_70180_af.func_75682_a(19, (Object)EnumSentryMode.CAMOUFLAGE.ordinal());
        this.field_70180_af.func_75682_a(20, (Object)Float.valueOf(0.0f));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K && this.animate) {
            if (this.animateUpwards && this.headYTranslation > 0.0f) {
                this.headYTranslation -= 0.025f;
                if (this.headYTranslation <= 0.0f) {
                    this.animateUpwards = false;
                    this.animate = false;
                }
            } else if (!this.animateUpwards && this.headYTranslation < 0.9f) {
                this.headYTranslation += 0.025f;
                if (this.headYTranslation >= 0.9f) {
                    this.animateUpwards = true;
                    this.animate = false;
                }
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.getOwner().isOwner(player)) {
            player.func_71053_j();
            if (player.func_70093_af()) {
                this.remove();
            } else if (player.func_70694_bm() != null) {
                ItemStack module = this.getModule();
                if (player.func_70694_bm().func_77973_b() == SCContent.disguiseModule) {
                    if (module != null && !(module.func_77973_b() instanceof ItemBlock)) {
                        this.spawnAsEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, module);
                    }
                    this.setModule(player.func_70694_bm());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                } else if (player.func_70694_bm().func_77973_b() == SCContent.universalBlockModifier) {
                    this.field_70170_p.func_147449_b((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), Blocks.field_150350_a);
                    if (module != null && !(module.func_77973_b() instanceof ItemBlock)) {
                        this.spawnAsEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, module);
                    }
                    this.field_70180_af.func_75692_b(18, (Object)new ItemStack(Blocks.field_150348_b));
                }
            } else {
                this.toggleMode(player);
            }
            player.func_71038_i();
            return true;
        }
        return super.func_70085_c(player);
    }

    private void spawnAsEntity(World world, double x, double y, double z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            float f = 0.5f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityItem = new EntityItem(world, x + d0, y + d1, z + d2, stack);
            entityItem.field_145804_b = 10;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public void remove() {
        ItemStack module = this.getModule();
        this.spawnAsEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(SCContent.sentry));
        if (module != null && !(module.func_77973_b() instanceof ItemBlock)) {
            this.spawnAsEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, module);
        }
        this.field_70170_p.func_147449_b((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), Blocks.field_150350_a);
        this.func_70106_y();
    }

    public void toggleMode(EntityPlayer player) {
        int newMode = this.getMode().ordinal() + 1;
        if (newMode == 3) {
            newMode = 0;
        }
        this.field_70180_af.func_75692_b(19, (Object)newMode);
        if (player.field_70170_p.field_72995_K) {
            if (newMode == 0) {
                this.animateUpwards = true;
                this.animate = true;
            } else if (newMode == 1) {
                this.animateUpwards = false;
                this.animate = true;
            }
            PlayerUtils.sendMessageToPlayer(player, StatCollector.func_74838_a((String)"item.securitycraft:sentry.name"), StatCollector.func_74838_a((String)("messages.securitycraft:sentry.mode" + (newMode + 1))), EnumChatFormatting.DARK_RED);
        }
    }

    public void func_70624_b(EntityLivingBase target) {
        if (this.getMode() != EnumSentryMode.AGGRESSIVE && (target == null && this.previousTargetId != Long.MIN_VALUE || target != null && this.previousTargetId != (long)target.func_145782_y())) {
            this.animateUpwards = this.getMode() == EnumSentryMode.CAMOUFLAGE && target != null;
            this.animate = true;
            SecurityCraft.network.sendToAll((IMessage)new PacketCInitSentryAnimation(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.animate, this.animateUpwards));
        }
        this.previousTargetId = target == null ? Long.MIN_VALUE : (long)target.func_145782_y();
        super.func_70624_b(target);
    }

    public float func_70047_e() {
        return 1.5f;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.func_70068_e((Entity)target) > 400.0) {
            return;
        }
        EntityBullet throwableEntity = new EntityBullet(this.field_70170_p, (EntityLivingBase)this);
        double y = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double x = target.field_70165_t - this.field_70165_t;
        double d2 = y - throwableEntity.field_70163_u;
        double z = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(x * x + z * z)) * 0.2f;
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf((float)(Math.atan2(x, -z) * 57.29577951308232)));
        throwableEntity.func_70186_c(x, d2 + (double)f, z, 1.6f, 0.0f);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)throwableEntity);
    }

    public void func_70014_b(NBTTagCompound tag) {
        ItemStack module = this.getModule();
        tag.func_74782_a("TileEntityData", (NBTBase)this.getOwnerTag());
        tag.func_74782_a("InstalledModule", (NBTBase)(module == null ? new NBTTagCompound() : module.func_77955_b(new NBTTagCompound())));
        tag.func_74768_a("SentryMode", this.getMode().ordinal());
        tag.func_74776_a("HeadRotation", this.getHeadRotation());
        super.func_70014_b(tag);
    }

    public float getHeadRotation() {
        return this.field_70180_af.func_111145_d(20);
    }

    private NBTTagCompound getOwnerTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("owner", this.field_70180_af.func_75681_e(16));
        tag.func_74778_a("ownerUUID", this.field_70180_af.func_75681_e(17));
        return tag;
    }

    public void func_70037_a(NBTTagCompound tag) {
        NBTTagCompound teTag = tag.func_74775_l("TileEntityData");
        this.field_70180_af.func_75692_b(16, (Object)teTag.func_74779_i("owner"));
        this.field_70180_af.func_75692_b(17, (Object)teTag.func_74779_i("ownerUUID"));
        this.field_70180_af.func_75692_b(18, (Object)ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag.func_74781_a("InstalledModule"))));
        this.field_70180_af.func_75692_b(19, (Object)tag.func_74762_e("SentryMode"));
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(tag.func_74760_g("HeadRotation")));
        super.func_70037_a(tag);
    }

    public Owner getOwner() {
        return new Owner(this.field_70180_af.func_75681_e(16), this.field_70180_af.func_75681_e(17));
    }

    public void setModule(ItemStack module) {
        if (module == null) {
            this.field_70170_p.func_147449_b((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), Blocks.field_150350_a);
        } else {
            ArrayList<ItemStack> blocks = ((ItemModule)module.func_77973_b()).getAddons(module.func_77978_p());
            if (blocks.size() > 0) {
                ItemStack disguiseStack = (ItemStack)blocks.get(0);
                this.field_70170_p.func_147465_d((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), Block.func_149634_a((Item)disguiseStack.func_77973_b()), disguiseStack.func_77960_j(), 3);
            }
        }
        this.field_70180_af.func_75692_b(18, (Object)(module != null ? module.func_77946_l() : null));
    }

    public ItemStack getModule() {
        return this.field_70180_af.func_82710_f(18);
    }

    public EnumSentryMode getMode() {
        int mode = this.field_70180_af.func_75679_c(19);
        return mode < 0 || mode > 2 ? EnumSentryMode.CAMOUFLAGE : EnumSentryMode.values()[mode];
    }

    public float getHeadYTranslation() {
        return this.headYTranslation;
    }

    public boolean func_70652_k(Entity entity) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_70601_bi() {
        return false;
    }

    public void func_70664_aZ() {
    }

    public boolean func_70781_l() {
        return false;
    }

    protected void func_70623_bb() {
    }

    public void func_70100_b_(EntityPlayer entity) {
    }

    public void func_70091_d(double x, double y, double z) {
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    public float func_145772_a(Explosion explosion, World world, int x, int y, int z, Block block) {
        return Float.MAX_VALUE;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_110159_bB() {
    }

    public Random func_70681_au() {
        return notRandom;
    }

    public static enum EnumSentryMode {
        AGGRESSIVE,
        CAMOUFLAGE,
        IDLE;

    }

    private static class NotRandom
    extends Random {
        private NotRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }
}

