/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.ai;

import net.geforcemods.securitycraft.entity.EntitySentry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;

public class EntityAIAttackRangedIfEnabled
extends EntityAIBase {
    private EntitySentry sentry;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;

    public EntityAIAttackRangedIfEnabled(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistance) {
        this.sentry = (EntitySentry)attacker;
        this.rangedAttackTime = -1;
        this.attackIntervalMin = maxAttackTime;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistance;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase potentialTarget = this.sentry.func_70638_az();
        if (potentialTarget == null) {
            return false;
        }
        this.attackTarget = potentialTarget;
        return this.sentry.getMode() != EntitySentry.EnumSentryMode.IDLE;
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.rangedAttackTime = -3;
    }

    public void func_75246_d() {
        double targetDistance = this.sentry.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
        this.sentry.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (!this.sentry.func_70635_at().func_75522_a((Entity)this.attackTarget)) {
                return;
            }
            float f = MathHelper.func_76133_a((double)targetDistance) / this.attackRadius;
            float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            this.sentry.func_82196_d(this.attackTarget, lvt_5_1_);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            this.rangedAttackTime = MathHelper.func_76128_c((double)(MathHelper.func_76133_a((double)targetDistance) / this.attackRadius * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

