/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUtils {
    public static void setBlockInBox(World world, int x, int y, int z, Block block) {
        world.func_147449_b(x + 1, y + 1, z, block);
        world.func_147449_b(x + 1, y + 2, z, block);
        world.func_147449_b(x + 1, y + 3, z, block);
        world.func_147449_b(x + 1, y + 1, z + 1, block);
        world.func_147449_b(x + 1, y + 2, z + 1, block);
        world.func_147449_b(x + 1, y + 3, z + 1, block);
        world.func_147449_b(x - 1, y + 1, z, block);
        world.func_147449_b(x - 1, y + 2, z, block);
        world.func_147449_b(x - 1, y + 3, z, block);
        world.func_147449_b(x - 1, y + 1, z + 1, block);
        world.func_147449_b(x - 1, y + 2, z + 1, block);
        world.func_147449_b(x - 1, y + 3, z + 1, block);
        world.func_147449_b(x, y + 1, z + 1, block);
        world.func_147449_b(x, y + 2, z + 1, block);
        world.func_147449_b(x, y + 3, z + 1, block);
        world.func_147449_b(x + 1, y + 1, z, block);
        world.func_147449_b(x + 1, y + 2, z, block);
        world.func_147449_b(x + 1, y + 3, z, block);
        world.func_147449_b(x, y + 1, z - 1, block);
        world.func_147449_b(x, y + 2, z - 1, block);
        world.func_147449_b(x, y + 3, z - 1, block);
        world.func_147449_b(x + 1, y + 1, z - 1, block);
        world.func_147449_b(x + 1, y + 2, z - 1, block);
        world.func_147449_b(x + 1, y + 3, z - 1, block);
        world.func_147449_b(x - 1, y + 1, z - 1, block);
        world.func_147449_b(x - 1, y + 2, z - 1, block);
        world.func_147449_b(x - 1, y + 3, z - 1, block);
        world.func_147449_b(x + 1, y + 4, z + 1, block);
        world.func_147449_b(x + 1, y + 4, z - 1, block);
        world.func_147449_b(x - 1, y + 4, z + 1, block);
        world.func_147449_b(x - 1, y + 4, z - 1, block);
    }

    public static void updateAndNotify(World world, int x, int y, int z, Block block, int tickRate, boolean shouldUpdate) {
        if (shouldUpdate) {
            world.func_147464_a(x, y, z, block, tickRate);
        }
        world.func_147441_b(x, y, z, block, world.func_72805_g(x, y, z));
        world.func_147460_e(x + 1, y, z, world.func_147439_a(x, y, z));
        world.func_147460_e(x - 1, y, z, world.func_147439_a(x, y, z));
        world.func_147460_e(x, y, z + 1, world.func_147439_a(x, y, z));
        world.func_147460_e(x, y, z - 1, world.func_147439_a(x, y, z));
        world.func_147460_e(x, y + 1, z, world.func_147439_a(x, y, z));
        world.func_147460_e(x, y - 1, z, world.func_147439_a(x, y, z));
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z);
    }

    public static void destroyBlock(World world, int x, int y, int z, boolean shouldDropItem) {
        world.func_147480_a(x, y, z, shouldDropItem);
    }

    public static boolean isMetadataBetween(IBlockAccess world, int x, int y, int z, int min, int max) {
        return world.func_72805_g(x, y, z) >= min && world.func_72805_g(x, y, z) <= max;
    }

    public static boolean hasActiveSCBlockNextTo(World par1World, int x, int y, int z) {
        return BlockUtils.hasActiveLaserNextTo(par1World, x, y, z) || BlockUtils.hasActiveScannerNextTo(par1World, x, y, z) || BlockUtils.hasActiveKeypadNextTo(par1World, x, y, z) || BlockUtils.hasActiveReaderNextTo(par1World, x, y, z) || BlockUtils.hasActiveInventoryScannerNextTo(par1World, x, y, z);
    }

    private static boolean hasActiveLaserNextTo(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z) == SCContent.laserBlock && world.func_72805_g(x + 1, y, z) == 2) {
            return ((IOwnable)world.func_147438_o(x + 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x - 1, y, z) == SCContent.laserBlock && world.func_72805_g(x - 1, y, z) == 2) {
            return ((IOwnable)world.func_147438_o(x - 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z + 1) == SCContent.laserBlock && world.func_72805_g(x, y, z + 1) == 2) {
            return ((IOwnable)world.func_147438_o(x, y, z + 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z - 1) == SCContent.laserBlock && world.func_72805_g(x, y, z - 1) == 2) {
            return ((IOwnable)world.func_147438_o(x, y, z - 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y + 1, z) == SCContent.laserBlock && world.func_72805_g(x, y + 1, z) == 2) {
            return ((IOwnable)world.func_147438_o(x, y + 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y - 1, z) == SCContent.laserBlock && world.func_72805_g(x, y - 1, z) == 2) {
            return ((IOwnable)world.func_147438_o(x, y - 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        return false;
    }

    private static boolean hasActiveScannerNextTo(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z) == SCContent.retinalScanner && world.func_72805_g(x + 1, y, z) > 6 && world.func_72805_g(x + 1, y, z) < 11) {
            return ((IOwnable)world.func_147438_o(x + 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x - 1, y, z) == SCContent.retinalScanner && world.func_72805_g(x - 1, y, z) > 6 && world.func_72805_g(x - 1, y, z) < 11) {
            return ((IOwnable)world.func_147438_o(x - 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z + 1) == SCContent.retinalScanner && world.func_72805_g(x, y, z + 1) > 6 && world.func_72805_g(x, y, z + 1) < 11) {
            return ((IOwnable)world.func_147438_o(x, y, z + 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z - 1) == SCContent.retinalScanner && world.func_72805_g(x, y, z - 1) > 6 && world.func_72805_g(x, y, z - 1) < 11) {
            return ((IOwnable)world.func_147438_o(x, y, z - 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y + 1, z) == SCContent.retinalScanner && world.func_72805_g(x, y + 1, z) > 6 && world.func_72805_g(x, y + 1, z) < 11) {
            return ((IOwnable)world.func_147438_o(x, y + 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y - 1, z) == SCContent.retinalScanner && world.func_72805_g(x, y - 1, z) > 6 && world.func_72805_g(x, y - 1, z) < 11) {
            return ((IOwnable)world.func_147438_o(x, y - 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        return false;
    }

    private static boolean hasActiveKeypadNextTo(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z) == SCContent.keypad && world.func_72805_g(x + 1, y, z) > 6 && world.func_72805_g(x + 1, y, z) < 11) {
            return ((IOwnable)world.func_147438_o(x + 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x - 1, y, z) == SCContent.keypad && world.func_72805_g(x - 1, y, z) > 6 && world.func_72805_g(x - 1, y, z) < 11) {
            return ((IOwnable)world.func_147438_o(x - 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z + 1) == SCContent.keypad && world.func_72805_g(x, y, z + 1) > 6 && world.func_72805_g(x, y, z + 1) < 11) {
            return ((IOwnable)world.func_147438_o(x, y, z + 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z - 1) == SCContent.keypad && world.func_72805_g(x, y, z - 1) > 6 && world.func_72805_g(x, y, z - 1) < 11) {
            return ((IOwnable)world.func_147438_o(x, y, z - 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y + 1, z) == SCContent.keypad && world.func_72805_g(x, y + 1, z) > 6 && world.func_72805_g(x, y + 1, z) < 11) {
            return ((IOwnable)world.func_147438_o(x, y + 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y - 1, z) == SCContent.keypad && world.func_72805_g(x, y - 1, z) > 6 && world.func_72805_g(x, y - 1, z) < 11) {
            return ((IOwnable)world.func_147438_o(x, y - 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        return false;
    }

    private static boolean hasActiveReaderNextTo(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z) == SCContent.keycardReader && world.func_72805_g(x + 1, y, z) > 6 && world.func_72805_g(x + 1, y, z) < 11) {
            return ((IOwnable)world.func_147438_o(x + 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x - 1, y, z) == SCContent.keycardReader && world.func_72805_g(x - 1, y, z) > 6 && world.func_72805_g(x - 1, y, z) < 11) {
            return ((IOwnable)world.func_147438_o(x - 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z + 1) == SCContent.keycardReader && world.func_72805_g(x, y, z + 1) > 6 && world.func_72805_g(x, y, z + 1) < 11) {
            return ((IOwnable)world.func_147438_o(x, y, z + 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z - 1) == SCContent.keycardReader && world.func_72805_g(x, y, z - 1) > 6 && world.func_72805_g(x, y, z - 1) < 11) {
            return ((IOwnable)world.func_147438_o(x, y, z - 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y + 1, z) == SCContent.keycardReader && world.func_72805_g(x, y + 1, z) > 6 && world.func_72805_g(x, y + 1, z) < 11) {
            return ((IOwnable)world.func_147438_o(x, y + 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y - 1, z) == SCContent.keycardReader && world.func_72805_g(x, y - 1, z) > 6 && world.func_72805_g(x, y - 1, z) < 11) {
            return ((IOwnable)world.func_147438_o(x, y - 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        return false;
    }

    private static boolean hasActiveInventoryScannerNextTo(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_147438_o(x + 1, y, z)).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_147438_o(x + 1, y, z)).shouldProvidePower()) {
            return ((IOwnable)world.func_147438_o(x + 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x - 1, y, z) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_147438_o(x - 1, y, z)).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_147438_o(x - 1, y, z)).shouldProvidePower()) {
            return ((IOwnable)world.func_147438_o(x - 1, y, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z + 1) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_147438_o(x, y, z + 1)).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_147438_o(x, y, z + 1)).shouldProvidePower()) {
            return ((IOwnable)world.func_147438_o(x, y, z + 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y, z - 1) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_147438_o(x, y, z - 1)).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_147438_o(x, y, z - 1)).shouldProvidePower()) {
            return ((IOwnable)world.func_147438_o(x, y, z - 1)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y + 1, z) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_147438_o(x, y + 1, z)).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_147438_o(x, y + 1, z)).shouldProvidePower()) {
            return ((IOwnable)world.func_147438_o(x, y + 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        if (world.func_147439_a(x, y - 1, z) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)world.func_147438_o(x, y - 1, z)).getType().equals("redstone") && ((TileEntityInventoryScanner)world.func_147438_o(x, y - 1, z)).shouldProvidePower()) {
            return ((IOwnable)world.func_147438_o(x, y - 1, z)).getOwner().owns((IOwnable)world.func_147438_o(x, y, z));
        }
        return false;
    }
}

