/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ModuleUtils {
    public static void checkForBlockAndInsertModule(World world, int x, int y, int z, String dir, Block blockToCheckFor, int range, ItemStack module, boolean updateAdjacentBlocks) {
        for (int i = 1; i <= range; ++i) {
            if (dir.equalsIgnoreCase("x+")) {
                if (world.func_147439_a(x + i, y, z) != blockToCheckFor || ((CustomizableSCTE)world.func_147438_o(x + i, y, z)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_147438_o(x + i, y, z)).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, x + i, y, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("x-")) {
                if (world.func_147439_a(x - i, y, z) != blockToCheckFor || ((CustomizableSCTE)world.func_147438_o(x - i, y, z)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_147438_o(x - i, y, z)).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, x - i, y, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y+")) {
                if (world.func_147439_a(x, y + i, z) != blockToCheckFor || ((CustomizableSCTE)world.func_147438_o(x, y + i, z)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_147438_o(x, y + i, z)).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, x, y + i, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y-")) {
                if (world.func_147439_a(x, y - i, z) != blockToCheckFor || ((CustomizableSCTE)world.func_147438_o(x, y - i, z)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_147438_o(x, y - i, z)).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, x, y - i, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("z+")) {
                if (world.func_147439_a(x, y, z + i) != blockToCheckFor || ((CustomizableSCTE)world.func_147438_o(x, y, z + i)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                ((CustomizableSCTE)world.func_147438_o(x, y, z + i)).insertModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndInsertModule(world, x, y, z + i, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (!dir.equalsIgnoreCase("z-") || world.func_147439_a(x, y, z - i) != blockToCheckFor || ((CustomizableSCTE)world.func_147438_o(x, y, z - i)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
            ((CustomizableSCTE)world.func_147438_o(x, y, z - i)).insertModule(module);
            if (!updateAdjacentBlocks) continue;
            ModuleUtils.checkInAllDirsAndInsertModule(world, x, y, z - i, blockToCheckFor, range, module, updateAdjacentBlocks);
        }
    }

    public static void checkInAllDirsAndInsertModule(World world, int x, int y, int z, Block blockToCheckFor, int range, ItemStack module, boolean updateAdjacentBlocks) {
        ModuleUtils.checkForBlockAndInsertModule(world, x, y, z, "x+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, x, y, z, "x-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, x, y, z, "y+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, x, y, z, "y-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, x, y, z, "z+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndInsertModule(world, x, y, z, "z-", blockToCheckFor, range, module, updateAdjacentBlocks);
    }

    public static void checkForBlockAndRemoveModule(World world, int x, int y, int z, String dir, Block blockToCheckFor, int range, EnumCustomModules module, boolean updateAdjacentBlocks) {
        for (int i = 1; i <= range; ++i) {
            if (dir.equalsIgnoreCase("x+")) {
                if (world.func_147439_a(x + i, y, z) != blockToCheckFor || !((CustomizableSCTE)world.func_147438_o(x + i, y, z)).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_147438_o(x + i, y, z)).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, x + i, y, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("x-")) {
                if (world.func_147439_a(x - i, y, z) != blockToCheckFor || !((CustomizableSCTE)world.func_147438_o(x - i, y, z)).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_147438_o(x - i, y, z)).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, x - i, y, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y+")) {
                if (world.func_147439_a(x, y + i, z) != blockToCheckFor || !((CustomizableSCTE)world.func_147438_o(x, y + i, z)).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_147438_o(x, y + i, z)).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, x, y + i, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("y-")) {
                if (world.func_147439_a(x, y - i, z) != blockToCheckFor || !((CustomizableSCTE)world.func_147438_o(x, y - i, z)).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_147438_o(x, y - i, z)).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, x, y - i, z, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (dir.equalsIgnoreCase("z+")) {
                if (world.func_147439_a(x, y, z + i) != blockToCheckFor || !((CustomizableSCTE)world.func_147438_o(x, y, z + i)).hasModule(module)) continue;
                ((CustomizableSCTE)world.func_147438_o(x, y, z + i)).removeModule(module);
                if (!updateAdjacentBlocks) continue;
                ModuleUtils.checkInAllDirsAndRemoveModule(world, x, y, z + i, blockToCheckFor, range, module, updateAdjacentBlocks);
                continue;
            }
            if (!dir.equalsIgnoreCase("z-") || world.func_147439_a(x, y, z - i) != blockToCheckFor || !((CustomizableSCTE)world.func_147438_o(x, y, z - i)).hasModule(module)) continue;
            ((CustomizableSCTE)world.func_147438_o(x, y, z - i)).removeModule(module);
            if (!updateAdjacentBlocks) continue;
            ModuleUtils.checkInAllDirsAndRemoveModule(world, x, y, z - i, blockToCheckFor, range, module, updateAdjacentBlocks);
        }
    }

    public static void checkInAllDirsAndRemoveModule(World world, int x, int y, int z, Block blockToCheckFor, int range, EnumCustomModules module, boolean updateAdjacentBlocks) {
        ModuleUtils.checkForBlockAndRemoveModule(world, x, y, z, "x+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, x, y, z, "x-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, x, y, z, "y+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, x, y, z, "y-", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, x, y, z, "z+", blockToCheckFor, range, module, updateAdjacentBlocks);
        ModuleUtils.checkForBlockAndRemoveModule(world, x, y, z, "z-", blockToCheckFor, range, module, updateAdjacentBlocks);
    }

    public static List<String> getPlayersFromModule(World world, int x, int y, int z, EnumCustomModules module) {
        ArrayList<String> list = new ArrayList<String>();
        CustomizableSCTE te = (CustomizableSCTE)world.func_147438_o(x, y, z);
        if (te.hasModule(module)) {
            ItemStack item = te.getModule(module);
            for (int i = 1; i <= 10; ++i) {
                if (item.field_77990_d == null || item.field_77990_d.func_74779_i("Player" + i) == null || item.field_77990_d.func_74779_i("Player" + i).isEmpty()) continue;
                list.add(item.field_77990_d.func_74779_i("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean checkForModule(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, EnumCustomModules module) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof CustomizableSCTE)) {
            return false;
        }
        if (te instanceof TileEntityKeypad) {
            if (module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, x, y, z, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.securitycraft:keypad.name"), StatCollector.func_74838_a((String)"messages.securitycraft:module.whitelisted"), EnumChatFormatting.GREEN);
                BlockKeypad.activate(world, x, y, z);
                return true;
            }
            if (module == EnumCustomModules.BLACKLIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, x, y, z, EnumCustomModules.BLACKLIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.securitycraft:keypad.name"), StatCollector.func_74838_a((String)"messages.securitycraft:module.blacklisted"), EnumChatFormatting.RED);
                return true;
            }
        } else if (te instanceof TileEntityKeycardReader) {
            if (module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, x, y, z, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.securitycraft:keycardReader.name"), StatCollector.func_74838_a((String)"messages.securitycraft:module.whitelisted"), EnumChatFormatting.GREEN);
                BlockKeycardReader.activate(world, x, y, z);
                return true;
            }
            if (module == EnumCustomModules.BLACKLIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.BLACKLIST) && ModuleUtils.getPlayersFromModule(world, x, y, z, EnumCustomModules.BLACKLIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
                PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.securitycraft:keycardReader.name"), StatCollector.func_74838_a((String)"messages.securitycraft:module.blacklisted"), EnumChatFormatting.RED);
                return true;
            }
        } else if (te instanceof TileEntityRetinalScanner ? module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, x, y, z, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase()) : te instanceof TileEntityInventoryScanner && module == EnumCustomModules.WHITELIST && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, x, y, z, EnumCustomModules.WHITELIST).contains(par5EntityPlayer.func_70005_c_().toLowerCase())) {
            return true;
        }
        return false;
    }
}

