/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client.render;

import com.builtbroken.mc.lib.render.RenderUtility;
import com.builtbroken.mc.lib.render.model.loader.EngineModelLoader;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.ex.ExNightmare;
import icbm.classic.content.explosive.ex.Explosion;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMissile
extends Render
implements IItemRenderer {
    private static IModelCustom TIER1_BASE;
    private static IModelCustom TIER2_BASE;
    private static IModelCustom TIER3_BASE;
    private static IModelCustom TIER4_BASE;

    public RenderMissile(float f) {
        this.field_76989_e = f;
        TIER1_BASE = EngineModelLoader.loadModel((ResourceLocation)new ResourceLocation("icbmclassic", "models/missiles/tier1/missile_base_t1.obj"));
        TIER2_BASE = EngineModelLoader.loadModel((ResourceLocation)new ResourceLocation("icbmclassic", "models/missiles/tier2/missile_base_t2.obj"));
        TIER3_BASE = EngineModelLoader.loadModel((ResourceLocation)new ResourceLocation("icbmclassic", "models/missiles/tier3/missile_base_t3.obj"));
        TIER4_BASE = EngineModelLoader.loadModel((ResourceLocation)new ResourceLocation("icbmclassic", "models/missiles/tier4/missile_base_t4.obj"));
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
        EntityMissile entityMissile = (EntityMissile)entity;
        Explosive e = entityMissile.getExplosiveType();
        Explosion missile = e == null ? (Explosion)Explosives.CONDENSED.handler : (Explosion)e;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(entityMissile.field_70126_B + (entityMissile.field_70177_z - entityMissile.field_70126_B) * f1 - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float pitch = entityMissile.field_70127_C + (entityMissile.field_70125_A - entityMissile.field_70127_C) * f1 - 90.0f;
        GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        if (missile.missileModelPath != null && missile.missileModelPath.contains("missiles")) {
            GL11.glScalef((float)0.00625f, (float)0.00625f, (float)0.00625f);
        } else if (!(missile instanceof ExNightmare)) {
            GL11.glScalef((float)0.07f, (float)0.07f, (float)0.07f);
        }
        RenderMissile.renderMissile(missile);
        GL11.glPopMatrix();
    }

    public static void renderMissile(Explosion missile) {
        if (missile instanceof ExNightmare) {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.00625f, (float)0.00625f, (float)0.00625f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(((Explosion)Explosives.ANVIL.handler).getMissileResource());
            TIER1_BASE.renderAll();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glTranslated((double)-0.5, (double)3.8, (double)-0.5);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            IIcon side = Blocks.field_150428_aP.func_149691_a(1, 2);
            RenderUtility.renderCubeWithOverrides((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (Block)Blocks.field_150428_aP, (IIcon[])new IIcon[]{side, Blocks.field_150428_aP.func_149691_a(2, 2), side, side, side, side}, (int)0);
            GL11.glPopMatrix();
        } else if (missile.getMissileModel() != null) {
            if (missile.missileModelPath.contains("missiles")) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(missile.getMissileResource());
                if (missile.getTier() == 1) {
                    TIER1_BASE.renderAll();
                } else if (missile.getTier() == 2) {
                    TIER2_BASE.renderAll();
                } else if (missile.getTier() == 3) {
                    TIER3_BASE.renderAll();
                } else if (missile.getTier() == 4) {
                    TIER4_BASE.renderAll();
                }
                missile.getMissileModel().renderAll();
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(missile.getMissileResource());
                missile.getMissileModel().renderAll();
            }
        } else {
            TIER1_BASE.renderAll();
        }
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Explosives ex = Explosives.get(item.func_77960_j());
        if (ex.handler instanceof Explosion) {
            Explosion missile = (Explosion)ex.handler;
            boolean doMissileSizeFix = missile.missileModelPath != null && missile.missileModelPath.contains("missiles");
            float yaw = 0.0f;
            float pitch = -90.0f;
            float scale = doMissileSizeFix ? 0.00625f : 0.7f;
            switch (type) {
                case INVENTORY: {
                    float f = scale = doMissileSizeFix ? 0.0035f : 0.5f;
                    if (missile.getTier() == 2 || !missile.hasBlockForm()) {
                        scale /= 1.5f;
                        GL11.glTranslatef((float)-0.7f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    if (missile.getTier() == 3) {
                        scale /= 1.7f;
                        GL11.glTranslatef((float)-0.65f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    if (missile.getTier() == 4) {
                        scale /= 1.4f;
                        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
                    break;
                }
                case EQUIPPED: {
                    GL11.glTranslatef((float)1.0f, (float)0.3f, (float)0.5f);
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glTranslatef((float)1.15f, (float)-1.0f, (float)0.5f);
                    break;
                }
                case ENTITY: {
                    GL11.glTranslatef((float)-0.6f, (float)0.0f, (float)0.0f);
                    break;
                }
            }
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            RenderMissile.renderMissile(missile);
        }
    }
}

