/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.render.RenderUtility;
import com.builtbroken.mc.lib.render.block.BlockRenderHandler;
import com.builtbroken.mc.prefab.items.ItemBlockBase;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.ICBMClassic;
import icbm.classic.content.blocks.BlockWrapper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TileCamouflage
extends Tile
implements IPacketReceiver,
IRecipeContainer {
    public static boolean useGlassRender = false;
    @SideOnly(value=Side.CLIENT)
    public static IIcon icon;
    private Block _blockToMimic = null;
    private int metaToMimic = 0;
    private boolean isSolid = true;
    private byte renderSides = 0;

    public TileCamouflage() {
        super("camouflage", Material.field_151577_b);
        this.itemBlock = ItemBlockBase.class;
        this.renderType = BlockRenderHandler.ID;
        this.renderNormalBlock = false;
        this.renderTileEntity = false;
    }

    public Tile newTile() {
        return new TileCamouflage();
    }

    public boolean canUpdate() {
        return false;
    }

    public void read(ByteBuf data, EntityPlayer player, PacketType packet) {
        if (this.isClient()) {
            String blockName = ByteBufUtils.readUTF8String((ByteBuf)data);
            this._blockToMimic = blockName.isEmpty() ? null : (Block)Block.field_149771_c.func_82594_a(blockName);
            this.metaToMimic = data.readInt();
            this.renderSides = data.readByte();
            this.isSolid = data.readBoolean();
            this.markRender();
        }
    }

    public void onWorldJoin() {
        this.markRender();
    }

    public PacketTile getDescPacket() {
        String blockName = "";
        if (this.getMimicBlock() != null && (blockName = Block.field_149771_c.func_148750_c((Object)this.getMimicBlock())) == null) {
            blockName = "";
        }
        return new PacketTile((TileEntity)this, new Object[]{blockName, this.metaToMimic, this.renderSides, this.isSolid});
    }

    public boolean getCanCollide() {
        return this.isSolid;
    }

    public void setCanCollide(boolean isSolid) {
        this.isSolid = isSolid;
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescPacket();
        }
        this.func_70296_d();
        this.markRender();
    }

    public void toggleCollision() {
        this.setCanCollide(!this.isSolid);
    }

    public Block getMimicBlock() {
        return this._blockToMimic;
    }

    public int getMimicBlockMeta() {
        return this.metaToMimic;
    }

    public void setMimicBlock(Block block, int metadata) {
        if (this.getMimicBlock() != block || this.metaToMimic != metadata) {
            this._blockToMimic = block;
            this.metaToMimic = Math.max(Math.min(metadata, 15), 0);
            this.oldWorld().func_72921_c(this.xi(), this.yi(), this.zi(), this.metaToMimic, 2);
            if (this.isServer()) {
                this.func_70296_d();
                this.sendDescPacket();
            } else {
                this.markRender();
            }
        }
    }

    public boolean canRenderSide(ForgeDirection direction) {
        return (this.renderSides & 1 << direction.ordinal()) != 0;
    }

    public void setRenderSide(ForgeDirection direction, boolean isClear) {
        this.renderSides = isClear ? (byte)(this.renderSides | 1 << direction.ordinal()) : (byte)(this.renderSides & ~(1 << direction.ordinal()));
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescPacket();
        }
        this.func_70296_d();
        this.markRender();
    }

    public void toggleRenderSide(ForgeDirection direction) {
        this.setRenderSide(direction, !this.canRenderSide(direction));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("blockToMimic")) {
            this._blockToMimic = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("blockToMimic"));
        }
        this.metaToMimic = nbt.func_74762_e("metaToMimic");
        this.renderSides = nbt.func_74771_c("renderSides");
        this.isSolid = nbt.func_74767_n("isSold");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.getMimicBlock() != null) {
            nbt.func_74778_a("blockToMimic", Block.field_149771_c.func_148750_c((Object)this._blockToMimic));
            nbt.func_74768_a("metaToMimic", this.metaToMimic);
        }
        nbt.func_74774_a("renderSides", this.renderSides);
        nbt.func_74757_a("isSold", this.isSolid);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        if (this.canRenderSide(ForgeDirection.getOrientation((int)side))) {
            return Blocks.field_150359_w.func_149691_a(0, 0);
        }
        if (this.getMimicBlock() != null) {
            try {
                IIcon blockIcon = this.getMimicBlock().func_149691_a(side, this.getMimicBlockMeta());
                if (blockIcon != null) {
                    return blockIcon;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(RenderBlocks renderer, Pos pos, int pass) {
        Block block = this.getMimicBlock() != null ? this.getMimicBlock() : this.func_145838_q();
        BlockWrapper wrapper = new BlockWrapper(block);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Block block2 = this.oldWorld().func_147439_a(this.xi() + dir.offsetX, this.yi() + dir.offsetY, this.zi() + dir.offsetZ);
            wrapper.setRenderSide(dir, block2 != this.func_145838_q() && !this.canRenderSide(dir));
        }
        boolean rendered = renderer.func_147784_q((Block)wrapper, this.xi(), this.yi(), this.zi());
        if (this.renderSides != 0) {
            wrapper = new BlockWrapper(useGlassRender ? Blocks.field_150359_w : Blocks.field_150395_bd);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                wrapper.setRenderSide(dir, this.canRenderSide(dir));
            }
            if (renderer.func_147784_q((Block)wrapper, this.xi(), this.yi(), this.zi())) {
                rendered = true;
            }
            renderer.field_147838_g = true;
            renderer.func_147782_a(0.01, 0.01, 0.01, 0.99, 0.99, 0.99);
            wrapper = new BlockWrapper(useGlassRender ? Blocks.field_150359_w : Blocks.field_150395_bd);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Block block2 = this.oldWorld().func_147439_a(this.xi() + dir.offsetX, this.yi() + dir.offsetY, this.zi() + dir.offsetZ);
                wrapper.setRenderSide(dir, block2 != this.func_145838_q());
            }
            if (renderer.func_147784_q((Block)wrapper, this.xi(), this.yi(), this.zi())) {
                rendered = true;
            }
            renderer.field_147838_g = false;
        }
        return rendered;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(ItemStack itemStack) {
        RenderUtility.renderCube((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (Block)this.func_145838_q(), (IIcon)icon);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        icon = iconRegister.func_94245_a("icbmclassic:camouflage");
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null && player.func_82247_a(this.xi(), this.yi(), this.zi(), side, player.func_70694_bm())) {
            if (player.func_70694_bm().func_77973_b() instanceof ItemBlock) {
                if (this.owner == null || this.owner.equals(player.func_146103_bH().getId())) {
                    Block block = Block.func_149634_a((Item)player.func_71045_bC().func_77973_b());
                    int meta = player.func_71045_bC().func_77960_j();
                    if (block != this.func_145838_q()) {
                        if (block != this.getMimicBlock() || meta != this.field_145847_g) {
                            if (block.func_149721_r() && (block.func_149645_b() == 0 || block.func_149645_b() == 31)) {
                                if (this.isServer()) {
                                    this.setMimicBlock(block, meta);
                                    if (Engine.runningAsDev) {
                                        player.func_146105_b((IChatComponent)new ChatComponentText("Camouflage material set to " + block.func_149739_a()));
                                    }
                                }
                            } else if (Engine.runningAsDev && this.isServer()) {
                                player.func_146105_b((IChatComponent)new ChatComponentText("Not normal cube or invalid render type"));
                            }
                        } else if (Engine.runningAsDev && this.isServer()) {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Same block"));
                        }
                    } else if (Engine.runningAsDev && this.isServer()) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Can't be used as a camouflage"));
                    }
                } else if (Engine.runningAsDev && this.isServer()) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("No perms"));
                }
            } else if (Engine.runningAsDev && this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Not a block"));
            }
        } else if (Engine.runningAsDev && this.isServer()) {
            player.func_146105_b((IChatComponent)new ChatComponentText("Empty hand or can not edit"));
        }
        return true;
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        if (player.func_82247_a(this.xi(), this.yi(), this.zi(), side, player.func_70694_bm())) {
            if (this.owner == null || this.owner.equals(player.func_146103_bH().getId())) {
                if (this.isServer()) {
                    if (player.func_70093_af()) {
                        this.toggleCollision();
                        player.func_146105_b((IChatComponent)new ChatComponentText("Collision set to " + this.getCanCollide()));
                    } else {
                        this.toggleRenderSide(ForgeDirection.getOrientation((int)side));
                        player.func_146105_b((IChatComponent)new ChatComponentText("Side set to render: " + this.canRenderSide(ForgeDirection.getOrientation((int)side))));
                    }
                }
                return true;
            }
            if (Engine.runningAsDev && this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("No perms"));
            }
        } else if (Engine.runningAsDev && this.isServer()) {
            player.func_146105_b((IChatComponent)new ChatComponentText("Empty hand or can not edit"));
        }
        return false;
    }

    public int getColorMultiplier() {
        try {
            if (this.getMimicBlock() != null) {
                return this.getMimicBlock().func_149720_d((IBlockAccess)this.oldWorld(), this.xi(), this.yi(), this.xi());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0xFFFFFF;
    }

    public Iterable<Cube> getCollisionBoxes(Cube intersect, Entity entity) {
        ArrayList<Cube> boxes = new ArrayList<Cube>();
        if (this.getCanCollide()) {
            boxes.add(this.getCollisionBounds());
        }
        return boxes;
    }

    public boolean shouldSideBeRendered(int side) {
        return true;
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockCamo, 12), new Object[]{"WGW", "G G", "WGW", Character.valueOf('G'), Blocks.field_150395_bd, Character.valueOf('W'), Blocks.field_150325_L}));
    }
}

