/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.data.EnumProjectileTypes;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.world.map.radar.RadarRegistry;
import com.builtbroken.mc.prefab.entity.EntityProjectile;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.ex.Explosion;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.api.explosion.ILauncherContainer;
import resonant.api.explosion.IMissile;

public class EntityMissile
extends EntityProjectile
implements IEntityAdditionalSpawnData,
IMissile {
    public static final float SPEED = 0.012f;
    public Explosives explosiveID = Explosives.CONDENSED;
    public int maxHeight = 200;
    public Pos targetVector = null;
    public Pos launcherPos = null;
    public boolean isExpoding = false;
    public int targetHeight = 0;
    public double deltaPathX;
    public double deltaPathY;
    public double deltaPathZ;
    public double flatDistance;
    public float missileFlightTime;
    public float acceleration;
    public int protectionTime = 2;
    public Entity lockedTarget;
    public boolean didTargetLockBefore = false;
    public int trackingVar = -1;
    public int missileCount = 0;
    public double daoDanGaoDu = 2.0;
    private boolean setExplode;
    private boolean setNormalExplode;
    public MissileType missileType = MissileType.MISSILE;
    public Pos xiaoDanMotion = new Pos();
    private double lockHeight = 3.0;
    private final HashSet<Entity> ignoreEntity = new HashSet();
    protected final IUpdatePlayerListBox shengYin;
    public NBTTagCompound nbtData = new NBTTagCompound();

    public EntityMissile(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.shengYin = this.field_70170_p != null ? ICBMClassic.proxy.getDaoDanShengYin(this) : null;
        this.field_70155_l = 3.0;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissile(World w, double x, double y, double z, float yaw, float pitch, float speed) {
        super(w, x, y, z, yaw, pitch, speed, 1.0f);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.shengYin = this.field_70170_p != null ? ICBMClassic.proxy.getDaoDanShengYin(this) : null;
        this.field_70155_l = 3.0;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissile(EntityLivingBase entity) {
        super(entity.field_70170_p, entity, 2.0f);
        this.func_70105_a(0.5f, 0.5f);
        this.launcherPos = new Pos((Entity)entity);
        this.inAirKillTime = 144000;
        this.shengYin = this.field_70170_p != null ? ICBMClassic.proxy.getDaoDanShengYin(this) : null;
        this.field_70155_l = 3.0;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public String getEntityName() {
        return this.explosiveID.handler.getMissileName();
    }

    public void writeSpawnData(ByteBuf additionalMissileData) {
        additionalMissileData.writeInt(this.explosiveID.ordinal());
        additionalMissileData.writeInt(this.missileType.ordinal());
    }

    public void readSpawnData(ByteBuf additionalMissileData) {
        this.explosiveID = Explosives.get(additionalMissileData.readInt());
        this.missileType = MissileType.values()[additionalMissileData.readInt()];
    }

    public void launch(Pos target) {
        this.sourceOfProjectile = this.toPos();
        this.targetVector = target;
        int n = this.targetHeight = this.targetVector != null ? this.targetVector.yi() : 0;
        if (this.explosiveID != null && this.explosiveID.handler instanceof Explosion) {
            ((Explosion)this.explosiveID.handler).launch(this);
        }
        this.ticksInAir = 2;
        this.recalculatePath();
        this.updateMotion();
        this.field_70170_p.func_72956_a((Entity)this, "icbmclassic:missilelaunch", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        RadarRegistry.add((Entity)this);
        if (target != null) {
            ICBMClassic.INSTANCE.logger().info("Launching " + this.getEntityName() + " (" + this.func_145782_y() + ") from " + this.sourceOfProjectile.xi() + ", " + this.sourceOfProjectile.yi() + ", " + this.sourceOfProjectile.zi() + " to " + this.targetVector.xi() + ", " + this.targetVector.yi() + ", " + this.targetVector.zi());
        } else {
            ICBMClassic.INSTANCE.logger().info("Launching " + this.getEntityName() + " (" + this.func_145782_y() + ") from " + this.sourceOfProjectile.xi() + ", " + this.sourceOfProjectile.yi() + ", " + this.sourceOfProjectile.zi());
        }
    }

    public void launch(Pos target, int height) {
        this.lockHeight = height;
        this.launch(target);
    }

    public EntityMissile ignore(Entity entity) {
        this.ignoreEntity.add(entity);
        return this;
    }

    public void recalculatePath() {
        if (this.targetVector != null) {
            this.deltaPathX = this.targetVector.x() - this.sourceOfProjectile.x();
            this.deltaPathY = this.targetVector.y() - this.sourceOfProjectile.y();
            this.deltaPathZ = this.targetVector.z() - this.sourceOfProjectile.z();
            this.flatDistance = this.sourceOfProjectile.toVector2().distance((IPos2D)this.targetVector.toVector2());
            this.maxHeight = 160 + (int)(this.flatDistance * 3.0);
            this.missileFlightTime = (float)Math.max(100.0, 2.0 * this.flatDistance) - (float)this.ticksInAir;
            this.acceleration = (float)this.maxHeight * 2.0f / (this.missileFlightTime * this.missileFlightTime);
        }
    }

    public void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void updateMotion() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.ticksInAir >= 0 && this.missileType == MissileType.MISSILE) {
                if (this.lockHeight > 0.0) {
                    this.field_70181_x = 0.012f * (float)this.ticksInAir * (float)(this.ticksInAir / 2);
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.lockHeight -= this.field_70181_x;
                    if (this.lockHeight <= 0.0) {
                        this.field_70181_x = this.acceleration * (this.missileFlightTime / 2.0f);
                        this.field_70159_w = this.deltaPathX / (double)this.missileFlightTime;
                        this.field_70179_y = this.deltaPathZ / (double)this.missileFlightTime;
                    }
                } else {
                    this.field_70181_x -= (double)this.acceleration;
                    this.field_70125_A = (float)(Math.atan(this.field_70181_x / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
                    this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                }
            }
            this.spawnMissileSmoke();
            --this.protectionTime;
        }
        if (this.explosiveID != null && this.explosiveID.handler instanceof Explosion) {
            ((Explosion)this.explosiveID.handler).update(this);
        }
        super.updateMotion();
    }

    protected void decreaseMotion() {
        if (this.missileType != MissileType.MISSILE && this.ticksInAir > 1000) {
            super.decreaseMotion();
        }
    }

    protected void onImpactTile() {
        this.explode();
    }

    protected void onImpactEntity(Entity entityHit, float velocity) {
        if (!this.field_70170_p.field_72995_K) {
            super.onImpactEntity(entityHit, velocity);
            this.explode();
        }
    }

    public ILauncherContainer getLauncher() {
        TileEntity tileEntity;
        if (this.launcherPos != null && (tileEntity = this.launcherPos.getTileEntity((IBlockAccess)this.field_70170_p)) != null && tileEntity instanceof ILauncherContainer && !tileEntity.func_145837_r()) {
            return (ILauncherContainer)tileEntity;
        }
        return null;
    }

    public boolean func_130002_c(EntityPlayer entityPlayer) {
        if (this.explosiveID != null && ((Explosion)this.explosiveID.handler).onInteract(this, entityPlayer)) {
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n != entityPlayer)) {
            entityPlayer.func_70078_a((Entity)this);
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        if (this.missileFlightTime <= 0.0f && this.missileType == MissileType.MISSILE) {
            return this.field_70131_O;
        }
        if (this.missileType == MissileType.CruiseMissile) {
            return this.field_70131_O / 10.0f;
        }
        return (double)(this.field_70131_O / 2.0f) + this.field_70181_x;
    }

    private void spawnMissileSmoke() {
        if (this.field_70170_p.field_72995_K) {
            Pos position = new Pos((IPos3D)this);
            double distance = -this.daoDanGaoDu - (double)0.2f;
            double y = Math.sin(Math.toRadians(this.field_70125_A)) * distance;
            double dH = Math.cos(Math.toRadians(this.field_70125_A)) * distance;
            double x = Math.sin(Math.toRadians(this.field_70177_z)) * dH;
            double z = Math.cos(Math.toRadians(this.field_70177_z)) * dH;
            position = (Pos)position.add(x, y, z);
            this.field_70170_p.func_72869_a("flame", position.x(), position.y(), position.z(), 0.0, 0.0, 0.0);
            ICBMClassic.proxy.spawnParticle("missile_smoke", this.field_70170_p, (IPos3D)position, 4.0f, 2.0);
            position = (Pos)position.multiply(1.0 - 0.001 * Math.random());
            ICBMClassic.proxy.spawnParticle("missile_smoke", this.field_70170_p, (IPos3D)position, 4.0f, 2.0);
            position = (Pos)position.multiply(1.0 - 0.001 * Math.random());
            ICBMClassic.proxy.spawnParticle("missile_smoke", this.field_70170_p, (IPos3D)position, 4.0f, 2.0);
            position = (Pos)position.multiply(1.0 - 0.001 * Math.random());
            ICBMClassic.proxy.spawnParticle("missile_smoke", this.field_70170_p, (IPos3D)position, 4.0f, 2.0);
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (this.ignoreEntity.contains(entity)) {
            return null;
        }
        if (!(entity instanceof EntityItem) && entity != this.field_70153_n && this.protectionTime <= 0) {
            if (entity instanceof EntityMissile) {
                ((EntityMissile)entity).setNormalExplode();
            }
            this.setExplode();
        }
        return null;
    }

    public Pos getPredictedPosition(int t) {
        Pos guJiDiDian = this.toPos();
        double tempMotionY = this.field_70181_x;
        if (this.ticksInAir > 20) {
            for (int i = 0; i < t; ++i) {
                guJiDiDian = this.missileType == MissileType.CruiseMissile || this.missileType == MissileType.LAUNCHER ? (Pos)guJiDiDian.add((IPos3D)this.xiaoDanMotion) : (Pos)guJiDiDian.add(this.field_70159_w, tempMotionY - (double)this.acceleration, this.field_70179_y);
            }
        }
        return guJiDiDian;
    }

    public void setNormalExplode() {
        this.setNormalExplode = true;
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    public void setExplode() {
        this.setExplode = true;
        this.field_70180_af.func_75692_b(17, (Object)2);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            RadarRegistry.remove((Entity)this);
        }
        super.func_70106_y();
        if (this.shengYin != null) {
            this.shengYin.func_73660_a();
        }
    }

    public void explode() {
        try {
            if (!this.isExpoding) {
                if (this.explosiveID == null) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
                    }
                } else {
                    ((Explosion)this.explosiveID.handler).createExplosion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (Entity)this);
                }
                this.isExpoding = true;
                ICBMClassic.INSTANCE.logger().info(this.getEntityName() + " (" + this.func_145782_y() + ") exploded in " + (int)this.field_70165_t + ", " + (int)this.field_70163_u + ", " + (int)this.field_70161_v);
            }
            this.func_70106_y();
        }
        catch (Exception e) {
            ICBMClassic.INSTANCE.logger().error("Missile failed to explode properly. Report this to the developers.", (Throwable)e);
        }
    }

    public void normalExplode() {
        if (!this.isExpoding) {
            this.isExpoding = true;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
            }
            this.func_70106_y();
        }
    }

    public void dropMissileAsItem() {
        if (!this.isExpoding && !this.field_70170_p.field_72995_K) {
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ICBMClassic.itemMissile, 1, this.explosiveID.ordinal()));
            float var13 = 0.05f;
            Random random = new Random();
            entityItem.field_70159_w = (float)random.nextGaussian() * var13;
            entityItem.field_70181_x = (float)random.nextGaussian() * var13 + 0.2f;
            entityItem.field_70179_y = (float)random.nextGaussian() * var13;
            this.field_70170_p.func_72838_d((Entity)entityItem);
        }
        this.func_70106_y();
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.targetVector = new Pos(nbt.func_74775_l("target"));
        this.launcherPos = new Pos(nbt.func_74775_l("faSheQi"));
        this.acceleration = nbt.func_74760_g("acceleration");
        this.targetHeight = nbt.func_74762_e("targetHeight");
        this.explosiveID = Explosives.get(nbt.func_74762_e("explosiveID"));
        this.ticksInAir = nbt.func_74762_e("ticksInAir");
        this.lockHeight = nbt.func_74769_h("lockHeight");
        this.missileType = MissileType.values()[nbt.func_74762_e("missileType")];
        this.nbtData = nbt.func_74775_l("additionalMissileData");
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.targetVector != null) {
            nbt.func_74782_a("target", (NBTBase)this.targetVector.toNBT());
        }
        if (this.launcherPos != null) {
            nbt.func_74782_a("launcherPos", (NBTBase)this.launcherPos.toNBT());
        }
        nbt.func_74776_a("acceleration", this.acceleration);
        nbt.func_74768_a("explosiveID", this.explosiveID.ordinal());
        nbt.func_74768_a("targetHeight", this.targetHeight);
        nbt.func_74768_a("ticksInAir", this.ticksInAir);
        nbt.func_74780_a("lockHeight", this.lockHeight);
        nbt.func_74768_a("missileType", this.missileType.ordinal());
        nbt.func_74782_a("additionalMissileData", (NBTBase)this.nbtData);
    }

    public int getTicksInAir() {
        return this.ticksInAir;
    }

    public Explosive getExplosiveType() {
        return this.explosiveID.handler;
    }

    public NBTTagCompound getTagCompound() {
        return this.nbtData;
    }

    public EnumProjectileTypes getProjectileType() {
        return EnumProjectileTypes.ROCKET;
    }

    public static enum MissileType {
        MISSILE,
        CruiseMissile,
        LAUNCHER;

    }
}

