/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.IRotatable;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.explosive.blast.BlastTNT;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlastBreech
extends BlastTNT {
    private int depth;

    public BlastBreech(World world, Entity entity, double x, double y, double z, float size, int depth) {
        this(world, entity, x, y, z, size);
        this.depth = depth;
    }

    public BlastBreech(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
        this.damageToEntities = 13.0f;
    }

    @Override
    protected void calculateDamage() {
        if (!this.oldWorld().field_72995_K) {
            ForgeDirection direction = ForgeDirection.DOWN;
            if (this.field_77283_e instanceof IRotatable) {
                direction = ((IRotatable)this.field_77283_e).getDirection();
            }
            this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "random.explode", 5.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            float energy = 80 + this.depth * 3;
            for (int i = 0; i < this.depth; ++i) {
                Pos dir = (Pos)new Pos(direction).multiply((double)i);
                block1: for (int h = -1; h < 2; ++h) {
                    for (int w = -1; w < 2; ++w) {
                        float e;
                        Pos p;
                        if (direction == ForgeDirection.DOWN || direction == ForgeDirection.UP) {
                            p = (Pos)dir.add((double)h, 0.0, (double)w);
                        } else if (direction == ForgeDirection.EAST || direction == ForgeDirection.WEST) {
                            p = (Pos)dir.add(0.0, (double)h, (double)w);
                        } else if (direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH) {
                            p = (Pos)dir.add((double)w, (double)h, 0.0);
                        } else {
                            return;
                        }
                        p = (Pos)this.toPos().add((IPos3D)p);
                        Block block = p.getBlock((IBlockAccess)this.oldWorld());
                        if (block != Blocks.field_150350_a && (e = block.getExplosionResistance(this.field_77283_e, this.oldWorld(), p.xi(), p.yi(), p.zi(), this.position.x(), this.position.y(), this.position.z())) < 40.0f) {
                            energy -= e;
                            this.blownBlocks.add(p);
                        }
                        if (energy <= 0.0f) continue block1;
                    }
                }
            }
        }
    }

    @Override
    public long getEnergy() {
        return super.getEnergy() * (long)this.depth / 2L;
    }
}

