/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.explosive.blast.Blast;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlastTNT
extends Blast {
    protected List<Pos> blownBlocks = new ArrayList<Pos>();
    private int pushType = 0;
    private boolean destroyItem = false;
    public float damageToEntities = 10.0f;
    public int raysPerAxis = 16;

    public BlastTNT(World world, Entity entity, double x, double y, double z, float power) {
        super(world, entity, x, y, z, power);
    }

    public BlastTNT setPushType(int type) {
        this.pushType = type;
        return this;
    }

    public BlastTNT setDestroyItems() {
        this.destroyItem = true;
        return this;
    }

    @Override
    public void doExplode() {
        this.calculateDamage();
        this.oldWorld().func_72908_a(this.position.x(), this.position.y(), this.position.z(), "random.explode", 4.0f, (1.0f + (this.oldWorld().field_73012_v.nextFloat() - this.oldWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        switch (this.pushType) {
            case 0: {
                this.doDamageEntities(this.getRadius(), this.damageToEntities, this.destroyItem);
                break;
            }
            default: {
                this.pushEntities(12.0f, this.getRadius() * 4.0f, this.pushType);
            }
        }
        this.doDestroyBlocks();
    }

    protected void calculateDamage() {
        if (!this.oldWorld().field_72995_K) {
            for (int xs = 0; xs < this.raysPerAxis; ++xs) {
                for (int ys = 0; ys < this.raysPerAxis; ++ys) {
                    for (int zs = 0; zs < this.raysPerAxis; ++zs) {
                        if (xs != 0 && xs != this.raysPerAxis - 1 && ys != 0 && ys != this.raysPerAxis - 1 && zs != 0 && zs != this.raysPerAxis - 1) continue;
                        double xStep = (float)xs / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double yStep = (float)ys / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double zStep = (float)zs / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double diagonalDistance = Math.sqrt(xStep * xStep + yStep * yStep + zStep * zStep);
                        xStep /= diagonalDistance;
                        yStep /= diagonalDistance;
                        zStep /= diagonalDistance;
                        double x = this.position.x();
                        double y = this.position.y();
                        double z = this.position.z();
                        float step = 0.3f;
                        for (float radialEnergy = this.getRadius() * (0.7f + this.oldWorld().field_73012_v.nextFloat() * 0.6f); radialEnergy > 0.0f; radialEnergy -= step * 0.75f) {
                            Pos pos;
                            int xi = MathHelper.func_76128_c((double)x);
                            int yi = MathHelper.func_76128_c((double)y);
                            int zi = MathHelper.func_76128_c((double)z);
                            Block block = this.oldWorld().func_147439_a(xi, yi, zi);
                            if (block != Blocks.field_150350_a && (radialEnergy -= (block.getExplosionResistance(this.field_77283_e, this.oldWorld(), xi, yi, zi, (double)this.position.xi(), (double)this.position.yi(), (double)this.position.zi()) + 0.3f) * step) > 0.0f && !this.blownBlocks.contains(pos = new Pos((double)xi, (double)yi, (double)zi))) {
                                this.blownBlocks.add(pos);
                            }
                            x += xStep * (double)step;
                            y += yStep * (double)step;
                            z += zStep * (double)step;
                        }
                    }
                }
            }
        }
    }

    protected void doDestroyBlocks() {
        if (!this.oldWorld().field_72995_K) {
            for (Pos blownPosition : this.blownBlocks) {
                int xi = blownPosition.xi();
                int yi = blownPosition.yi();
                int zi = blownPosition.zi();
                Block block = this.oldWorld().func_147439_a(xi, yi, zi);
                int metadata = this.oldWorld().func_72805_g(xi, yi, zi);
                double var9 = (float)xi + this.oldWorld().field_73012_v.nextFloat();
                double var11 = (float)yi + this.oldWorld().field_73012_v.nextFloat();
                double var13 = (float)zi + this.oldWorld().field_73012_v.nextFloat();
                double var151 = var9 - this.position.y();
                double var171 = var11 - this.position.y();
                double var191 = var13 - this.position.z();
                double var211 = MathHelper.func_76133_a((double)(var151 * var151 + var171 * var171 + var191 * var191));
                var151 /= var211;
                var171 /= var211;
                var191 /= var211;
                double var23 = 0.5 / (var211 / (double)this.getRadius() + 0.1);
                this.oldWorld().func_72869_a("explode", (var9 + this.position.x() * 1.0) / 2.0, (var11 + this.position.y() * 1.0) / 2.0, (var13 + this.position.z() * 1.0) / 2.0, var151 *= (var23 *= (double)(this.oldWorld().field_73012_v.nextFloat() * this.oldWorld().field_73012_v.nextFloat() + 0.3f)), var171 *= var23, var191 *= var23);
                this.oldWorld().func_72869_a("smoke", var9, var11, var13, var151, var171, var191);
                if (block == Blocks.field_150350_a) continue;
                try {
                    if (block.func_149659_a(null)) {
                        block.func_149690_a(this.oldWorld(), xi, yi, zi, this.oldWorld().func_72805_g(xi, yi, zi), 1.0f, 0);
                    }
                    block.onBlockExploded(this.oldWorld(), xi, yi, zi, (Explosion)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void pushEntities(float radius, float force, int type) {
        Pos minCoord = this.position.toPos();
        minCoord = (Pos)minCoord.add((double)(-radius - 1.0f));
        Pos maxCoord = this.position.toPos();
        maxCoord = (Pos)maxCoord.add((double)(radius + 1.0f));
        Cube region = new Cube((IPos3D)minCoord, (IPos3D)maxCoord);
        List entities = region.getEntities(this.oldWorld(), Entity.class);
        for (Entity entity : entities) {
            double modifier;
            double var13 = entity.func_70011_f(this.position.x(), this.position.y(), this.position.z()) / (double)radius;
            if (!(var13 <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.position.x();
            double yDifference = entity.field_70163_u - this.position.y();
            double zDifference = entity.field_70161_v - this.position.z();
            double distance = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= distance;
            yDifference /= distance;
            zDifference /= distance;
            if (type == 1) {
                modifier = var13 * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
                entity.func_70024_g(-xDifference * modifier, -yDifference * modifier, -zDifference * modifier);
                continue;
            }
            if (type != 2) continue;
            modifier = (1.0 - var13) * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
            entity.func_70024_g(xDifference * modifier, yDifference * modifier, zDifference * modifier);
        }
    }

    @Override
    public long getEnergy() {
        return 418000L;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.pushType = nbt.func_74762_e("pushType");
        this.destroyItem = nbt.func_74767_n("destroyItem");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("pushType", this.pushType);
        nbt.func_74757_a("destroyItem", this.destroyItem);
    }
}

