/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.tile;

import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.classic.ICBMClassic;
import icbm.classic.client.render.tile.RenderBombBlock;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.explosive.Explosive;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.tile.TileEntityExplosive;
import icbm.classic.prefab.VectorHelper;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.api.explosion.ExplosionEvent;
import resonant.api.explosion.ExplosiveType;

public class BlockExplosive
extends BlockContainer
implements IPostInit {
    public final HashMap<String, IIcon> ICONS = new HashMap();

    public BlockExplosive() {
        super(Material.field_151590_u);
        this.func_149663_c("icbmclassic:explosives");
        this.func_149658_d("icbmclassic:explosives");
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149779_h);
    }

    private static byte determineOrientation(World world, int x, int y, int z, EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            int rotation;
            if (MathHelper.func_76135_e((float)((float)entityLiving.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entityLiving.field_70161_v - (float)z)) < 2.0f) {
                double var5 = entityLiving.field_70163_u + 1.82 - (double)entityLiving.field_70129_M;
                if (var5 - (double)y > 2.0) {
                    return 1;
                }
                if ((double)y - var5 > 0.0) {
                    return 0;
                }
            }
            return (byte)((rotation = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (rotation == 1 ? 5 : (rotation == 2 ? 3 : (rotation == 3 ? 4 : 0))));
        }
        return 0;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        TileEntity tileEntity = par1IBlockAccess.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileEntityExplosive && ((TileEntityExplosive)tileEntity).explosive == Explosives.SMINE) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.2f, 1.0f);
            return;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World par1World, int x, int y, int z) {
        TileEntity tileEntity = par1World.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileEntityExplosive && ((TileEntityExplosive)tileEntity).explosive == Explosives.SMINE) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + 0.2), (double)((double)z + this.field_149757_G));
        }
        return super.func_149668_a(par1World, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityExplosive) {
            Explosives ex;
            ((TileEntityExplosive)tile).explosive = ex = Explosives.get(itemStack.func_77960_j());
            if (!world.field_72995_K) {
                ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(world, (double)x, (double)y, (double)z, ExplosiveType.BLOCK, (IExplosiveHandler)ex.handler);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (evt.isCanceled()) {
                    this.func_149697_b(world, x, y, z, ex.ordinal(), 0);
                    world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                    return;
                }
            }
            world.func_72921_c(x, y, z, VectorHelper.getOrientationFromSide(ForgeDirection.getOrientation((int)BlockExplosive.determineOrientation(world, x, y, z, entityLiving)), ForgeDirection.NORTH).ordinal(), 2);
            if (world.func_72864_z(x, y, z)) {
                BlockExplosive.triggerExplosive(world, x, y, z, ex, 0);
            }
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                Pos position = (Pos)new Pos((double)x, (double)y, (double)z).add(ForgeDirection.getOrientation((int)i));
                Block blockId = position.getBlock((IBlockAccess)world);
                if (blockId != Blocks.field_150480_ab && blockId != Blocks.field_150356_k && blockId != Blocks.field_150353_l) continue;
                BlockExplosive.triggerExplosive(world, x, y, z, ex, 2);
                break;
            }
            if (entityLiving != null) {
                ICBMClassic.INSTANCE.logger().info("ICBMClassic>>BlockExplosive#onBlockPlacedBy: " + entityLiving.func_70005_c_() + " placed " + ex.handler.getExplosiveName() + " in: " + x + ", " + y + ", " + z + ".");
            }
        }
    }

    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        return this.func_149691_a(side, ((TileEntityExplosive)par1IBlockAccess.func_147438_o((int)x, (int)y, (int)z)).explosive.ordinal());
    }

    public IIcon func_149691_a(int side, int explosiveID) {
        if (side == 0) {
            return this.getIcon(explosiveID + "_bottom");
        }
        if (side == 1) {
            return this.getIcon(explosiveID + "_top");
        }
        return this.getIcon(explosiveID + "_side");
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getIcon(String name) {
        IIcon icon = this.ICONS.get(name);
        if (icon != null) {
            return icon;
        }
        return Blocks.field_150322_A.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (Explosives ex : Explosives.values()) {
            if (!ex.handler.hasBlockForm() || ex == Explosives.SMINE) continue;
            this.ICONS.put(ex.ordinal() + "_top", this.getIcon(iconRegister, ex.handler, "_top"));
            this.ICONS.put(ex.ordinal() + "_side", this.getIcon(iconRegister, ex.handler, "_side"));
            this.ICONS.put(ex.ordinal() + "_bottom", this.getIcon(iconRegister, ex.handler, "_bottom"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IIconRegister iconRegister, Explosive zhaPin, String suffix) {
        block6: {
            String iconName = "explosive_" + zhaPin.getUnlocalizedName() + suffix;
            try {
                ResourceLocation resourcelocation = new ResourceLocation("icbmclassic", "textures/blocks/" + iconName + ".png");
                InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourcelocation).func_110527_b();
                BufferedImage bufferedimage = ImageIO.read(inputstream);
                if (bufferedimage != null) {
                    return iconRegister.func_94245_a("icbmclassic:" + iconName);
                }
            }
            catch (FileNotFoundException e) {
                if (Engine.runningAsDev) {
                    ICBMClassic.INSTANCE.logger().info("Failed to find texture for " + iconName + " moving to using backup texture. For some textures this is normally, especially bottom textures. However, if a side or top texture is missing this may be a bug.");
                }
            }
            catch (Exception e) {
                if (!Engine.runningAsDev) break block6;
                e.printStackTrace();
            }
        }
        if (suffix.equals("_bottom")) {
            return iconRegister.func_94245_a("icbmclassic:explosive_bottom_" + zhaPin.getTier());
        }
        return iconRegister.func_94245_a("icbmclassic:explosive_base_" + zhaPin.getTier());
    }

    public void func_149726_b(World par1World, int x, int y, int z) {
        super.func_149726_b(par1World, x, y, z);
        par1World.func_147458_c(x, y, z, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        Explosives explosiveID = ((TileEntityExplosive)world.func_147438_o((int)x, (int)y, (int)z)).explosive;
        if (world.func_72864_z(x, y, z)) {
            BlockExplosive.triggerExplosive(world, x, y, z, explosiveID, 0);
        } else if (blockId == Blocks.field_150480_ab || blockId == Blocks.field_150356_k || blockId == Blocks.field_150353_l) {
            BlockExplosive.triggerExplosive(world, x, y, z, explosiveID, 2);
        }
    }

    public static void triggerExplosive(World world, int x, int y, int z, Explosives explosiveID, int causeOfExplosion) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) != null && tileEntity instanceof TileEntityExplosive) {
            ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(world, (double)x, (double)y, (double)z, ExplosiveType.BLOCK, (IExplosiveHandler)((TileEntityExplosive)tileEntity).explosive.handler);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (!evt.isCanceled()) {
                ((TileEntityExplosive)tileEntity).exploding = true;
                EntityExplosive eZhaDan = new EntityExplosive(world, (Pos)new Pos((double)x, (double)y, (double)z).add(0.5), ((TileEntityExplosive)tileEntity).explosive, (byte)world.func_72805_g(x, y, z), ((TileEntityExplosive)tileEntity).nbtData);
                switch (causeOfExplosion) {
                    case 2: {
                        eZhaDan.func_70015_d(100);
                    }
                }
                world.func_72838_d((Entity)eZhaDan);
                world.func_147468_f(x, y, z);
            }
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (world.func_147438_o(x, y, z) != null) {
            BlockExplosive.triggerExplosive(world, x, y, z, ((TileEntityExplosive)world.func_147438_o((int)x, (int)y, (int)z)).explosive, 1);
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (entityPlayer.func_70694_bm() != null) {
            if (entityPlayer.func_70694_bm().func_77973_b() == Items.field_151033_d) {
                Explosives explosiveID = ((TileEntityExplosive)tileEntity).explosive;
                BlockExplosive.triggerExplosive(world, x, y, z, explosiveID, 0);
                return true;
            }
            if (WrenchUtility.isUsableWrench((EntityPlayer)entityPlayer, (ItemStack)entityPlayer.func_71045_bC(), (int)x, (int)y, (int)z)) {
                int change = 3;
                switch (world.func_72805_g(x, y, z)) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 2: {
                        change = 5;
                        break;
                    }
                    case 5: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                        break;
                    }
                    case 4: {
                        change = 1;
                        break;
                    }
                    case 1: {
                        change = 0;
                    }
                }
                world.func_72921_c(x, y, z, ForgeDirection.getOrientation((int)change).ordinal(), 3);
                world.func_147444_c(x, y, z, (Block)this);
                return true;
            }
        }
        if (tileEntity instanceof TileEntityExplosive) {
            return ((TileEntityExplosive)tileEntity).explosive.handler.onBlockActivated(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderBombBlock.ID;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityExplosive && ((TileEntityExplosive)tile).explosive != null) {
            return new ItemStack((Block)this, 1, ((TileEntityExplosive)tile).explosive.ordinal());
        }
        return new ItemStack((Block)this);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            InventoryUtility.dropBlockAsItem((World)world, (int)x, (int)y, (int)z, (boolean)false);
        }
        return world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityExplosive && !((TileEntityExplosive)tileEntity).exploding) {
            int explosiveID = ((TileEntityExplosive)tileEntity).explosive.ordinal();
            ret.add(new ItemStack(ICBMClassic.blockExplosive, 1, explosiveID));
        }
        return ret;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Explosives zhaPin : Explosives.values()) {
            if (!zhaPin.handler.hasBlockForm()) continue;
            par3List.add(new ItemStack(par1, 1, zhaPin.ordinal()));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityExplosive();
    }

    public boolean func_149662_c() {
        return false;
    }

    public void onPostInit() {
        GameRegistry.registerTileEntity(TileEntityExplosive.class, (String)"icbmCTileExplosive");
    }
}

