/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util.xml;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.slimevoid.library.core.SlimevoidCore;
import net.slimevoid.library.util.FileReader;
import net.slimevoid.library.util.FileUtils;
import net.slimevoid.library.util.xml.XMLLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLRecipeLoader
extends XMLLoader {
    private static Map<String, Map<String, InputStream>> defaultLocations = new HashMap<String, Map<String, InputStream>>();

    public static void registerDefaultsFromLocation(Class clazz, String location) {
        if (!defaultLocations.containsKey(location)) {
            try {
                String[] resourceList = FileUtils.getResourceListing(clazz, location);
                if (resourceList.length > 0) {
                    HashMap<String, InputStream> defaultStreams = new HashMap<String, InputStream>();
                    for (String file : resourceList) {
                        InputStream instr = clazz.getClassLoader().getResourceAsStream(location + file);
                        defaultStreams.put(file, instr);
                    }
                    defaultLocations.put(location, defaultStreams);
                    SlimevoidCore.console("SlimevoidLib", "Resource list loaded from [" + clazz.getSimpleName() + "][" + location + "]");
                } else {
                    SlimevoidCore.console("SlimevoidLib", "Caution: Failed to get resource list from [" + clazz.getSimpleName() + "][" + location + "]", 1);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadFolder(String locationKey, File dir) {
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
        if (defaultLocations.containsKey(locationKey)) {
            Map<String, InputStream> defaultStreams = defaultLocations.get(locationKey);
            for (String filename : defaultStreams.keySet()) {
                if (!FileReader.checkIfExists(filename, dir)) {
                    File newFile = new File(dir.getPath() + File.separator + filename);
                    if (FileUtils.copyStream(defaultStreams.get(filename), newFile)) {
                        SlimevoidCore.console("SlimevoidLib", "Default was file loaded [" + newFile.getName() + "]");
                        continue;
                    }
                    SlimevoidCore.console("SlimevoidLib", "Failed to load default file [" + newFile.getName() + "]");
                    continue;
                }
                SlimevoidCore.console("SlimevoidLib", "File [" + filename + "] already exists! Skipping...");
            }
            for (File xml : dir.listFiles(filter)) {
                XMLRecipeLoader.loadXML(xml);
            }
            defaultLocations.remove(locationKey);
        } else {
            SlimevoidCore.console("SlimevoidLib", "Caution: Could not load default settings from [" + locationKey + "]");
        }
    }

    public static void loadXML(File file) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodes = doc.getElementsByTagName("recipe");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                XMLRecipeLoader.assemble(element, file);
            }
        }
        catch (ParserConfigurationException e) {
            FileReader.endWithError("Could not parse XML: " + file.getName());
            e.printStackTrace();
        }
        catch (SAXException e) {
            FileReader.endWithError("Could not parse XML markup: " + file.getName());
            e.printStackTrace();
        }
        catch (IOException e) {
            FileReader.endWithError("Could not read XML: " + file.getName());
            e.printStackTrace();
        }
    }

    private static void assemble(Element element, File xmlFile) {
        String[] recipeLayout = null;
        int recipeStackSize = 1;
        Item outItem = null;
        int outMeta = 0;
        HashMap<String, ItemStack> recipeMap = new HashMap<String, ItemStack>();
        NamedNodeMap recAttrs = element.getAttributes();
        for (int j = 0; j < recAttrs.getLength(); ++j) {
            if (recAttrs.item(j).getNodeName().equals("stackSize")) {
                try {
                    recipeStackSize = Integer.parseInt(recAttrs.item(j).getNodeValue());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (recAttrs.item(j).getNodeName().equals("meta")) {
                String outMetaStr = recAttrs.item(j).getNodeValue();
                outMeta = XMLRecipeLoader.xmlValueToInteger(outMetaStr);
            }
            if (!recAttrs.item(j).getNodeName().equals("outId")) continue;
            String outIdStr = recAttrs.item(j).getNodeValue();
            outItem = XMLRecipeLoader.xmlValueToItem(outIdStr);
        }
        if (outItem == null) {
            FileReader.endWithError("recipe.outID not set! (" + xmlFile.getName() + ")");
            return;
        }
        recipeLayout = XMLRecipeLoader.getValue("layout", element).split("\n");
        int nextI = 0;
        for (int i = 0; i < recipeLayout.length; ++i) {
            recipeLayout[i] = recipeLayout[i].trim();
            if (!recipeLayout[i].equals("")) {
                recipeLayout[nextI] = recipeLayout[i];
                recipeLayout[i] = null;
                ++nextI;
                continue;
            }
            recipeLayout[i] = null;
        }
        NodeList blockNodes = element.getElementsByTagName("mapping");
        for (int i = 0; i < blockNodes.getLength(); ++i) {
            Node node = blockNodes.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap attrs = node.getAttributes();
            Item item = null;
            int meta = 0;
            for (int j = 0; j < attrs.getLength(); ++j) {
                if (attrs.item(j).getNodeName().equals("id")) {
                    String idStr = attrs.item(j).getNodeValue();
                    item = XMLRecipeLoader.xmlValueToItem(idStr);
                }
                if (!attrs.item(j).getNodeName().equals("meta")) continue;
                String metaStr = attrs.item(j).getNodeValue();
                meta = XMLRecipeLoader.xmlValueToInteger(metaStr);
            }
            if (item == null) {
                FileReader.endWithError("mapping.id not set! (" + xmlFile.getName() + ")");
                return;
            }
            recipeMap.put(node.getChildNodes().item(0).getNodeValue(), new ItemStack(item, 1, meta));
        }
        ArrayList<Object> recipe = new ArrayList<Object>();
        for (int i = 0; i < recipeLayout.length; ++i) {
            if (recipeLayout[i] == null) continue;
            recipe.add(recipeLayout[i]);
        }
        for (String key : recipeMap.keySet()) {
            recipe.add(Character.valueOf(key.toCharArray()[0]));
            recipe.add(recipeMap.get(key));
        }
        XMLRecipeLoader.registerRecipe(new ItemStack(outItem, recipeStackSize, outMeta), recipe.toArray());
    }

    private static int xmlValueToInteger(String xmlString) {
        int value;
        block2: {
            value = 0;
            try {
                value = Integer.parseInt(xmlString);
            }
            catch (NumberFormatException e) {
                if (!xmlVariables.containsKey(xmlString)) break block2;
                value = (Integer)xmlVariables.get(xmlString);
            }
        }
        return value;
    }

    private static Item xmlValueToItem(String xmlString) {
        int value;
        block2: {
            value = 0;
            try {
                value = Integer.parseInt(xmlString);
            }
            catch (NumberFormatException e) {
                if (!xmlVariables.containsKey(xmlString)) break block2;
                value = (Integer)xmlVariables.get(xmlString);
            }
        }
        return Item.func_150899_d((int)value);
    }

    private static void registerRecipe(ItemStack output, Object[] input) {
        GameRegistry.addRecipe((ItemStack)output, (Object[])input);
        FileReader.sendMessage("Adding recipe for: " + output.func_77977_a());
    }
}

