/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.debug;

import com.builtbroken.jlib.debug.IDebugPrintListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class DebugPrinter {
    protected final Logger logger;
    protected int nest = 0;
    protected String spacer;
    protected String indent = "\t";
    protected String sectionName;
    protected boolean enabled = true;
    protected boolean prev_enabled = true;
    List<IDebugPrintListener> listeners = new ArrayList<IDebugPrintListener>();

    public DebugPrinter(Logger logger) {
        this.logger = logger;
        if (logger == null) {
            throw new IllegalArgumentException("Logger was null");
        }
    }

    public void add(IDebugPrintListener listener) {
        this.listeners.add(listener);
    }

    public void nest() {
        ++this.nest;
        this.buildSpacer();
    }

    public void unnest() {
        --this.nest;
        this.buildSpacer();
    }

    protected void buildSpacer() {
        this.spacer = "";
        for (int i = 0; i < this.nest; ++i) {
            this.spacer = this.spacer + this.indent;
        }
    }

    public void log(String msg) {
        if (this.enabled) {
            if (this.spacer == null) {
                this.buildSpacer();
            }
            this.logger.info(this.spacer + this.getSectionPrefix() + msg);
            for (IDebugPrintListener listener : this.listeners) {
                listener.onMessage(msg, this.getSectionPrefix(), this.spacer, false);
            }
        }
    }

    public void error(String msg) {
        if (this.enabled) {
            this.logger.error(this.spacer + this.getSectionPrefix() + msg);
            for (IDebugPrintListener listener : this.listeners) {
                listener.onMessage(msg, this.getSectionPrefix(), this.spacer, true);
            }
        }
    }

    public void error(String msg, Throwable e) {
        if (this.enabled) {
            this.logger.error(this.spacer + this.getSectionPrefix() + msg, e);
            for (IDebugPrintListener listener : this.listeners) {
                listener.onMessageWithError(msg, this.getSectionPrefix(), this.spacer, e);
            }
        }
    }

    protected String getSectionPrefix() {
        if (this.sectionName != null && !this.sectionName.isEmpty()) {
            return this.sectionName + ": ";
        }
        return "";
    }

    public void start(String msg) {
        this.log(msg);
        this.nest();
    }

    public void start(String sectionName, String msg) {
        this.sectionName = sectionName;
        this.log(msg);
        this.nest();
    }

    public void start(String sectionName, String msg, boolean enable) {
        this.prev_enabled = this.enabled;
        this.enabled = enable;
        this.start(sectionName, msg);
    }

    public void end(String msg) {
        this.enabled = this.prev_enabled;
        this.unnest();
        this.log(msg);
        this.sectionName = null;
    }

    public void end() {
        this.unnest();
        this.sectionName = null;
    }

    public void enable() {
        this.enabled = true;
        this.prev_enabled = true;
    }

    public void disable() {
        this.enabled = false;
        this.prev_enabled = false;
    }

    public void setIndent(String value) {
        this.indent = value;
        if (value == null) {
            this.indent = " ";
        }
    }
}

