/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class PointExplosion {
    private Random ExplosionRNG = new Random();
    private World worldObj;
    public int explosionX;
    public int explosionY;
    public int explosionZ;
    public Entity exploder;
    public float explosionSize;
    public float explosionDropRate;
    public float explosionDamage;
    public Set destroyedBlockPositions = new HashSet();
    private Explosion fakeExplosion;
    private DamageSource damagesource;

    public PointExplosion(World world, Entity entity, int x, int y, int z, float power, float drop, float entitydamage) {
        this.worldObj = world;
        this.exploder = entity;
        this.explosionSize = power;
        this.explosionDropRate = drop;
        this.explosionDamage = entitydamage;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        if (this.explosionX < 0) {
            --this.explosionX;
        }
        if (this.explosionZ < 0) {
            --this.explosionZ;
        }
        this.fakeExplosion = new Explosion(world, entity, (double)x, (double)y, (double)z, power);
        this.damagesource = DamageSource.func_94539_a((Explosion)this.fakeExplosion);
    }

    public void doExplosionA(int lowX, int lowY, int lowZ, int highX, int highY, int highZ) {
        for (int x = this.explosionX - lowX; x <= this.explosionX + highX; ++x) {
            for (int y = this.explosionY - lowY; y <= this.explosionY + highY; ++y) {
                for (int z = this.explosionZ - lowZ; z <= this.explosionZ + highZ; ++z) {
                    Block id = this.worldObj.func_147439_a(x, y, z);
                    float resis = 0.0f;
                    if (id != null) {
                        resis = id.getExplosionResistance(this.exploder, this.worldObj, x, y, z, (double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
                    }
                    if (!(this.explosionSize >= resis / 10.0f)) continue;
                    this.destroyedBlockPositions.add(new ChunkPosition(x, y, z));
                }
            }
        }
        this.explosionSize *= 2.0f;
        int k = MathHelper.func_76128_c((double)((double)((float)this.explosionX - this.explosionSize) - 1.0));
        int i1 = MathHelper.func_76128_c((double)((double)((float)this.explosionX + this.explosionSize) + 1.0));
        int k2 = MathHelper.func_76128_c((double)((double)((float)this.explosionY - this.explosionSize) - 1.0));
        int l1 = MathHelper.func_76128_c((double)((double)((float)this.explosionY + this.explosionSize) + 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)((float)this.explosionZ - this.explosionSize) - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)((float)this.explosionZ + this.explosionSize) + 1.0));
        List list = this.worldObj.func_72839_b(this.exploder, AxisAlignedBB.func_72330_a((double)k, (double)k2, (double)i2, (double)i1, (double)l1, (double)j2));
        Vec3 vec3d = Vec3.func_72443_a((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (int k3 = 0; k3 < list.size(); ++k3) {
            Entity entity = (Entity)list.get(k3);
            double d4 = entity.func_70011_f((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ) / (double)this.explosionSize;
            if (!(d4 <= 1.0)) continue;
            double d2 = entity.field_70165_t - (double)this.explosionX;
            double d3 = entity.field_70163_u - (double)this.explosionY;
            d4 = entity.field_70161_v - (double)this.explosionZ;
            double d5 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3 + d4 * d4));
            d2 /= d5;
            d3 /= d5;
            double d6 = this.worldObj.func_72842_a(vec3d, entity.field_70121_D);
            double d7 = (1.0 - (d4 /= d5)) * d6;
            entity.func_70097_a(this.damagesource, (float)((int)(((d7 * d7 + d7) / 2.0 * 8.0 * (double)this.explosionSize + 1.0) * (double)this.explosionDamage)));
            double d8 = d7;
            Entity entity2 = entity;
            entity2.field_70159_w += d2 * d8;
            Entity entity3 = entity;
            entity3.field_70181_x += d3 * d8;
            Entity entity4 = entity;
            entity4.field_70179_y += d4 * d8;
        }
    }

    public void doExplosionB(boolean flag) {
        this.worldObj.func_72908_a((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        ArrayList arraylist = new ArrayList();
        arraylist.addAll(this.destroyedBlockPositions);
        for (int i = arraylist.size() - 1; i >= 0; --i) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(i);
            int j = chunkposition.field_151329_a;
            int k = chunkposition.field_151327_b;
            int l = chunkposition.field_151328_c;
            Block i2 = this.worldObj.func_147439_a(j, k, l);
            if (flag) {
                double d = (float)j + this.worldObj.field_73012_v.nextFloat();
                double d2 = (float)k + this.worldObj.field_73012_v.nextFloat();
                double d3 = (float)l + this.worldObj.field_73012_v.nextFloat();
                double d4 = d - (double)this.explosionX;
                double d5 = d2 - (double)this.explosionY;
                double d6 = d3 - (double)this.explosionZ;
                double d7 = MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5 + d6 * d6));
                d4 /= d7;
                d5 /= d7;
                d6 /= d7;
                double d8 = 0.5 / (d7 / (double)this.explosionSize + 0.1);
                this.worldObj.func_72869_a("explode", (d + (double)this.explosionX * 1.0) / 2.0, (d2 + (double)this.explosionY * 1.0) / 2.0, (d3 + (double)this.explosionZ * 1.0) / 2.0, d4 *= (d8 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d5 *= d8, d6 *= d8);
                this.worldObj.func_72869_a("smoke", d, d2, d3, d4, d5, d6);
            }
            if (i2 == null) continue;
            i2.func_149690_a(this.worldObj, j, k, l, this.worldObj.func_72805_g(j, k, l), this.explosionDropRate, 0);
            this.worldObj.func_147468_f(j, k, l);
            i2.func_149723_a(this.worldObj, j, k, l, this.fakeExplosion);
        }
    }
}

