/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;

public class CropCacti
extends CropCardBase {
    @Override
    public String discoveredBy() {
        return "SpawnX";
    }

    @Override
    public String name() {
        return "Cacti";
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Green", "Cacti", "Thorns"};
    }

    @Override
    public int maxSize() {
        return 4;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getAirQuality() >= 2 && crop.getSize() < 4;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return 4;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == this.maxSize();
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        int count = 1;
        if (crop.getWorld().field_73012_v.nextInt(3) == 0) {
            count = 2;
        }
        return new ItemStack(Blocks.field_150434_aF, count);
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return 300;
    }

    @Override
    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (!crop.getWorld().field_72995_K) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        return super.onEntityCollision(crop, entity);
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        int count = super.weightInfluences(crop, humidity, nutrients, air);
        count = (int)((float)count + 10.0f * this.getBiomeTemperature(crop));
        return count;
    }

    public float getBiomeTemperature(ICropTile crop) {
        ChunkCoordinates coord = crop.getLocation();
        BiomeGenBase base = crop.getWorld().func_72807_a(coord.field_71574_a, coord.field_71573_c);
        return base.func_150564_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c) - 0.5f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getSprite(ICropTile crop) {
        return Ic2Icons.getTexture("bc")[57 + crop.getSize()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
    }
}

