/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropMushroom
extends CropCardBase {
    boolean red;

    public CropMushroom(boolean par1) {
        this.red = par1;
    }

    @Override
    public String name() {
        return this.red ? "RedMushroom" : "BrownMushroom";
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        String color = this.red ? "Red" : "Brown";
        return new String[]{color, "Food", "Mushroom"};
    }

    @Override
    public int maxSize() {
        return 3;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < this.maxSize() && crop.getHydrationStorage() > 0;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (crop.getSize() == 3) {
            return this.red ? new ItemStack((Block)Blocks.field_150337_Q) : new ItemStack((Block)Blocks.field_150338_P);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getSprite(ICropTile crop) {
        int base = 51;
        if (this.red) {
            base += 3;
        }
        return Ic2Icons.getTexture("bc")[base + crop.getSize()];
    }
}

