/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.block;

import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockConverter
extends BlockMultiID {
    private static Converter[] converterBlocks = new Converter[16];

    public BlockConverter() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(IC2.tabIC2);
    }

    public static void addTile(Converter par1) {
        BlockConverter.converterBlocks[par1.meta] = par1;
    }

    @Override
    public void init() {
        for (int i = 0; i < converterBlocks.length; ++i) {
            if (!BlockConverter.isValidMeta(i)) continue;
            BlockConverter.getConverter(i).init((Block)this);
        }
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        if (BlockConverter.isValidMeta(meta)) {
            return BlockConverter.getConverter(meta).getIconSheet();
        }
        return Ic2Icons.getTexture("conv");
    }

    @Override
    protected int getIconMeta(int meta) {
        if (BlockConverter.isValidMeta(meta)) {
            return BlockConverter.getConverter(meta).getIconMeta();
        }
        return meta;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World p0, int p1) {
        if (BlockConverter.isValidMeta(p1)) {
            return BlockConverter.getConverter(p1).getNewTile();
        }
        return null;
    }

    @Override
    public void func_149666_a(Item j, CreativeTabs tabs, List itemList) {
        for (int i = 0; i < converterBlocks.length; ++i) {
            if (!BlockConverter.isValidMeta(i)) continue;
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public static boolean isValidMeta(int meta) {
        return converterBlocks[meta] != null;
    }

    public static Converter getConverter(int meta) {
        return converterBlocks[meta];
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockOpaqueCube(World world, int i, int j, int k) {
        return true;
    }

    public boolean func_149747_d(IBlockAccess world, int i, int j, int k, int l) {
        return true;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(i, j, k);
        if (entityliving == null) {
            te.setFacing((short)1);
        } else {
            int yaw = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int pitch = Math.round(entityliving.field_70125_A);
            if (pitch >= 65) {
                te.setFacing((short)1);
            } else if (pitch <= -65) {
                te.setFacing((short)0);
            } else {
                switch (yaw) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }

    public static abstract class Converter {
        final int meta;

        public Converter(int par1) {
            this.meta = par1;
        }

        public abstract TileEntityBlock getNewTile();

        public IIcon[] getIconSheet() {
            return Ic2Icons.getTexture("conv");
        }

        public int getIconMeta() {
            return this.meta;
        }

        public void init(Block par1) {
        }

        public void addInfo(List par1) {
        }

        public abstract String getUnlocizedName();
    }
}

