/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.inventory.transporter;

import ic2.core.block.inventory.IInvSlot;
import ic2.core.block.inventory.IItemTransporter;
import ic2.core.block.inventory.TransporterManager;
import ic2.core.block.inventory.transporter.BaseTransporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class BasicTransporter
extends BaseTransporter {
    IInventory inv;

    public BasicTransporter(IInventory par1) {
        this.inv = par1;
    }

    @Override
    public ItemStack removeItem(IItemTransporter.IFilter filter, ForgeDirection dir, int amount, boolean doRemove) {
        ItemStack item = null;
        int realAmount = amount;
        for (IInvSlot slot : TransporterManager.manager.getIteratorForInventory(this.inv, dir)) {
            ItemStack stack = slot.getStack();
            if (stack == null || !slot.canRemoveStack(stack) || !filter.matches(stack) || item != null && (!this.canMerge(item, stack) || item.field_77994_a >= amount)) continue;
            int max = Math.min(amount - this.getStackSize(item), stack.field_77994_a);
            if (doRemove) {
                if (item == null) {
                    item = slot.decreaseStackInSlot(max).func_77946_l();
                    continue;
                }
                ItemStack itemAmount = slot.decreaseStackInSlot(max).func_77946_l();
                item.field_77994_a += itemAmount.field_77994_a;
                continue;
            }
            if (item == null) {
                item = stack.func_77946_l();
                item.field_77994_a = max;
                continue;
            }
            item.field_77994_a += max;
        }
        return item;
    }

    private int getStackSize(ItemStack par1) {
        if (par1 == null) {
            return 0;
        }
        return par1.field_77994_a;
    }

    @Override
    public int injectItem(ItemStack stack, ForgeDirection dir, boolean doAdd) {
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>();
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>();
        for (IInvSlot slot : TransporterManager.manager.getIteratorForInventory(this.inv, dir)) {
            if (!slot.canInsertStack(stack)) continue;
            if (slot.getStack() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(injected, stack, filledSlots, doAdd);
        if ((injected = this.tryPut(injected, stack, emptySlots, doAdd)) > 0 && doAdd) {
            this.inv.func_70296_d();
        }
        return injected;
    }

    private int tryPut(int alreadyInjected, ItemStack stack, List<IInvSlot> slots, boolean doAdd) {
        if (alreadyInjected >= stack.field_77994_a) {
            return alreadyInjected;
        }
        for (IInvSlot slot : slots) {
            int used;
            ItemStack item = slot.getStack();
            if (item != null && !this.canMerge(stack, item) || (used = this.addToSlot(slot, stack, alreadyInjected, doAdd)) <= 0 || (alreadyInjected += used) < stack.field_77994_a) continue;
            return alreadyInjected;
        }
        return alreadyInjected;
    }

    private int addToSlot(IInvSlot slot, ItemStack stack, int alreadyInjected, boolean doAdd) {
        int aviable = stack.field_77994_a - alreadyInjected;
        int max = Math.min(stack.func_77976_d(), this.inv.func_70297_j_());
        ItemStack item = slot.getStack();
        if (item == null) {
            int wanted = Math.min(aviable, max);
            if (doAdd) {
                item = stack.func_77946_l();
                item.field_77994_a = wanted;
                slot.setStack(item);
            }
            return wanted;
        }
        if (!this.canMerge(stack, item)) {
            return 0;
        }
        int wanted = max - item.field_77994_a;
        if (wanted > aviable) {
            wanted = aviable;
        }
        if (doAdd) {
            item.field_77994_a += wanted;
            slot.setStack(item);
        }
        return wanted;
    }
}

