/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.machine.ContainerCropmatron;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCropmatron
extends TileEntityMachine
implements IEnergySink,
IHasGui {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 1000;
    public int scanX = -4;
    public int scanY = -1;
    public int scanZ = -4;
    public boolean addedToEnergyNet = false;
    public static int maxInput = 32;

    public TileEntityCropmatron() {
        super(9);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.energy >= 31) {
            this.scan();
        }
    }

    public void scan() {
        ++this.scanX;
        if (this.scanX > 4) {
            this.scanX = -4;
            ++this.scanZ;
            if (this.scanZ > 4) {
                this.scanZ = -4;
                ++this.scanY;
                if (this.scanY > 1) {
                    this.scanY = -1;
                }
            }
        }
        --this.energy;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.scanX, this.field_145848_d + this.scanY, this.field_145849_e + this.scanZ);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            this.updateSlots();
            if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Ic2Items.fertilizer.func_77973_b() && crop.applyFertilizer(false)) {
                this.energy -= 10;
                ItemStack itemStack = this.inventory[0];
                --itemStack.field_77994_a;
                this.checkStackSizeZero(0);
            }
            if (this.inventory[3] != null && this.inventory[3].func_77973_b() == Ic2Items.hydratingCell.func_77973_b() && crop.applyHydration(false, this.inventory[3])) {
                this.energy -= 10;
                this.checkStackSizeZero(3);
            }
            if (this.inventory[6] != null && this.inventory[6].func_77973_b() == Ic2Items.weedEx.func_77973_b() && crop.applyWeedEx(false)) {
                this.energy -= 10;
                this.inventory[6].func_77964_b(this.inventory[6].func_77960_j() + 1);
                if (this.inventory[6].func_77960_j() >= this.inventory[6].func_77958_k()) {
                    ItemStack itemStack2 = this.inventory[6];
                    --itemStack2.field_77994_a;
                    this.checkStackSizeZero(6);
                }
            }
        }
    }

    public void checkStackSizeZero(int x) {
        if (this.inventory[x] != null && this.inventory[x].field_77994_a <= 0) {
            this.inventory[x] = null;
        }
    }

    public void updateSlots() {
        this.moveFrom(1, 0);
        this.moveFrom(2, 1);
        this.moveFrom(4, 3);
        this.moveFrom(5, 4);
        this.moveFrom(7, 6);
        this.moveFrom(8, 7);
    }

    public void moveFrom(int from, int to) {
        if (this.inventory[from] != null && this.inventory[to] == null) {
            this.inventory[to] = this.inventory[from];
            this.inventory[from] = null;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / this.maxEnergy;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        if (amount > (double)maxInput) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    @Override
    public int getSinkTier() {
        return EnergyNet.instance.getTierFromPower(maxInput);
    }

    @Override
    public String func_145825_b() {
        return "Crop-Matron";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiCropmatron";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCropmatron(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{6, 7, 8};
        }
        if (var1 == 1) {
            return new int[]{3, 4, 5};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack item, int j) {
        if (item == null) {
            return false;
        }
        if (i < 3) {
            return item.func_77973_b() == Ic2Items.fertilizer.func_77973_b();
        }
        if (i < 6) {
            return item.func_77973_b() == Ic2Items.hydratingCell.func_77973_b();
        }
        return item.func_77973_b() == Ic2Items.weedEx.func_77973_b();
    }
}

