/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.item.ITerraformingBP;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTerra
extends TileEntityElecMachine {
    public int failedAttempts = 0;
    public int lastX = -1;
    public int lastY = -1;
    public int lastZ = -1;
    public AudioSource audioSource = null;
    public int inactiveTicks = 0;

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public TileEntityTerra() {
        super(1, 0, 100000, 512);
    }

    @Override
    public String func_145825_b() {
        return "Terraformer";
    }

    @Override
    public void func_145845_h() {
        ITerraformingBP tfbp;
        super.func_145845_h();
        boolean newActive = false;
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof ITerraformingBP && this.energy >= (tfbp = (ITerraformingBP)this.inventory[0].func_77973_b()).getConsume()) {
            newActive = true;
            int x = this.field_145851_c;
            int z = this.field_145849_e;
            int range = 1;
            if (this.lastY > -1) {
                range = tfbp.getRange() / 10;
                x = this.lastX - this.field_145850_b.field_73012_v.nextInt(range + 1) + this.field_145850_b.field_73012_v.nextInt(range + 1);
                z = this.lastZ - this.field_145850_b.field_73012_v.nextInt(range + 1) + this.field_145850_b.field_73012_v.nextInt(range + 1);
            } else {
                if (this.failedAttempts > 4) {
                    this.failedAttempts = 4;
                }
                range = tfbp.getRange() * (this.failedAttempts + 1) / 5;
                x = x - this.field_145850_b.field_73012_v.nextInt(range + 1) + this.field_145850_b.field_73012_v.nextInt(range + 1);
                z = z - this.field_145850_b.field_73012_v.nextInt(range + 1) + this.field_145850_b.field_73012_v.nextInt(range + 1);
            }
            if (tfbp.terraform(this.field_145850_b, x, z, this.field_145848_d)) {
                this.energy -= tfbp.getConsume();
                this.failedAttempts = 0;
                this.lastX = x;
                this.lastZ = z;
                this.lastY = this.field_145848_d;
            } else {
                this.energy -= tfbp.getConsume() / 10;
                ++this.failedAttempts;
                this.lastY = -1;
            }
        }
        if (newActive) {
            this.inactiveTicks = 0;
            this.setActive(true);
        } else if (!newActive && this.getActive() && this.inactiveTicks++ > 30) {
            this.setActive(false);
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        if (amount > 512.0) {
            return 0.0;
        }
        if ((double)this.energy + amount > (double)this.maxEnergy) {
            int unused = (int)((double)this.energy + amount - (double)this.maxEnergy);
            this.energy = this.maxEnergy;
            return unused;
        }
        this.energy = (int)((double)this.energy + amount);
        return 0.0;
    }

    public boolean ejectBlueprint() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.inventory[0]);
            this.inventory[0] = null;
        }
        return true;
    }

    public void insertBlueprint(ItemStack tfbp) {
        this.ejectBlueprint();
        this.inventory[0] = tfbp;
    }

    public static int getFirstSolidBlockFrom(World world, int x, int z, int y) {
        while (y > 0) {
            if (world.func_147445_c(x, y, z, false)) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static int getFirstBlockFrom(World world, int x, int z, int y) {
        while (y > 0) {
            if (!world.func_147437_c(x, y, z)) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static boolean switchGround(World world, Block from, Block to, int x, int y, int z, boolean upwards) {
        Block id2;
        if (upwards) {
            int saveY = ++y;
            while (true) {
                Block id = world.func_147439_a(x, y - 1, z);
                if (world.func_147437_c(x, y - 1, z) || id != from) break;
                --y;
            }
            if (saveY == y) {
                return false;
            }
            world.func_147449_b(x, y, z, to);
            return true;
        }
        while (true) {
            id2 = world.func_147439_a(x, y, z);
            if (world.func_147437_c(x, y, z) || id2 != to) break;
            --y;
        }
        id2 = world.func_147439_a(x, y, z);
        if (world.func_147437_c(x, y, z) || id2 != from) {
            return false;
        }
        world.func_147449_b(x, y, z, to);
        return true;
    }

    public static BiomeGenBase getBiomeAt(World world, int x, int z) {
        return world.func_72938_d(x, z).func_76591_a(x & 0xF, z & 0xF, world.func_72959_q());
    }

    public static void setBiomeAt(World world, int x, int z, BiomeGenBase biome) {
        Chunk chunk = world.func_72938_d(x, z);
        byte[] array = chunk.func_76605_m();
        array[(z & 0xF) << 4 | x & 0xF] = (byte)(biome.field_76756_M & 0xFF);
        chunk.func_76616_a(array);
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Terraformers/TerraformerGenericloop.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }
}

