/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.IRareBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityBatteryBox;
import ic2.core.block.wiring.TileEntityElectricBatBox;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.block.wiring.TileEntityElectricMFE;
import ic2.core.block.wiring.TileEntityElectricMFSU;
import ic2.core.block.wiring.TileEntityTransformerEV;
import ic2.core.block.wiring.TileEntityTransformerHV;
import ic2.core.block.wiring.TileEntityTransformerLV;
import ic2.core.block.wiring.TileEntityTransformerMV;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockElectric
extends BlockMultiID
implements IRareBlock {
    public BlockElectric() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IC2.tabIC2);
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        switch (meta) {
            case 0: {
                return Ic2Icons.getTexture("batBox");
            }
            case 1: {
                return Ic2Icons.getTexture("mfe");
            }
            case 2: {
                return Ic2Icons.getTexture("mfsu");
            }
            case 7: {
                return Ic2Icons.getTexture("bBox");
            }
        }
        return Ic2Icons.getTexture("belec");
    }

    @Override
    protected int getIconMeta(int meta) {
        if (meta >= 3 && meta <= 6) {
            return meta - 3;
        }
        return 0;
    }

    public Item func_149650_a(int meta, Random p_149650_2_, int p_149650_3_) {
        switch (meta) {
            case 0: 
            case 3: 
            case 7: {
                return super.func_149650_a(meta, p_149650_2_, p_149650_3_);
            }
        }
        return Ic2Items.machine.func_77973_b();
    }

    public int func_149692_a(int meta) {
        switch (meta) {
            case 0: {
                return meta;
            }
            case 3: {
                return meta;
            }
            case 7: {
                return meta;
            }
        }
        return Ic2Items.machine.func_77960_j();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_149709_b(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity te = iblockaccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock electricBlock = (TileEntityElectricBlock)te;
            return electricBlock.isEmittingRedstone() ? 15 : 0;
        }
        return 0;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockOpaqueCube(World world, int i, int j, int k) {
        return true;
    }

    public boolean func_149747_d(IBlockAccess world, int i, int j, int k, int l) {
        return true;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityElectricBatBox();
            }
            case 1: {
                return new TileEntityElectricMFE();
            }
            case 2: {
                return new TileEntityElectricMFSU();
            }
            case 3: {
                return new TileEntityTransformerLV();
            }
            case 4: {
                return new TileEntityTransformerMV();
            }
            case 5: {
                return new TileEntityTransformerHV();
            }
            case 6: {
                return new TileEntityTransformerEV();
            }
            case 7: {
                return new TileEntityBatteryBox();
            }
        }
        return null;
    }

    @Override
    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(i, j, k);
        if (entityliving == null) {
            te.setFacing((short)1);
        } else {
            int yaw = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int pitch = Math.round(entityliving.field_70125_A);
            if (pitch >= 65) {
                te.setFacing((short)1);
            } else if (pitch <= -65) {
                te.setFacing((short)0);
            } else {
                switch (yaw) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77960_j() == 2 || stack.func_77960_j() == 6 || stack.func_77960_j() == 5 ? EnumRarity.uncommon : EnumRarity.common;
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public void init() {
        Ic2Items.batBox = new ItemStack((Block)this, 1, 0);
        Ic2Items.mfeUnit = new ItemStack((Block)this, 1, 1);
        Ic2Items.mfsUnit = new ItemStack((Block)this, 1, 2);
        Ic2Items.lvTransformer = new ItemStack((Block)this, 1, 3);
        Ic2Items.mvTransformer = new ItemStack((Block)this, 1, 4);
        Ic2Items.hvTransformer = new ItemStack((Block)this, 1, 5);
        Ic2Items.evTransformer = new ItemStack((Block)this, 1, 6);
        Ic2Items.batteryBox = new ItemStack((Block)this, 1, 7);
    }
}

