/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergySourceInfo;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityTransformer
extends TileEntityBlock
implements IEnergySink,
IEnergySource,
IEnergySourceInfo,
IMultiEnergySource {
    public int lowOutput;
    public int highOutput;
    public int maxStorage;
    public int energy = 0;
    public boolean redstone = false;
    public boolean addedToEnergyNet = false;

    public TileEntityTransformer(int low, int high, int max) {
        this.lowOutput = low;
        this.highOutput = high;
        this.maxStorage = max;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
    }

    @Override
    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.updateRedstone();
    }

    public void updateRedstone() {
        boolean red = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (red != this.redstone) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addedToEnergyNet = false;
            this.redstone = red;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.setActive(this.redstone);
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (this.redstone) {
            return !this.facingMatchesDirection(direction);
        }
        return this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (this.redstone) {
            return this.facingMatchesDirection(direction);
        }
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public double getOfferedEnergy() {
        if (this.redstone) {
            if (this.energy >= this.highOutput) {
                return this.highOutput;
            }
            return 0.0;
        }
        if (this.energy >= this.lowOutput) {
            return this.lowOutput;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        int n = this.redstone ? this.lowOutput : this.highOutput;
        if (amount > (double)n) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxStorage) {
            re = this.energy - this.maxStorage;
            this.energy = this.maxStorage;
        }
        return re;
    }

    @Override
    public int getSinkTier() {
        if (this.redstone) {
            return EnergyNet.instance.getTierFromPower(this.lowOutput);
        }
        return EnergyNet.instance.getTierFromPower(this.highOutput);
    }

    @Override
    public int getSourceTier() {
        if (this.redstone) {
            return EnergyNet.instance.getTierFromPower(this.highOutput);
        }
        return EnergyNet.instance.getTierFromPower(this.lowOutput);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(side);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    @Override
    public boolean sendMultibleEnergyPackets() {
        return !this.redstone;
    }

    @Override
    public int getMultibleEnergyPacketAmount() {
        if (!this.redstone) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getMaxEnergyAmount() {
        if (this.redstone) {
            return this.highOutput;
        }
        return this.lowOutput;
    }
}

