/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.item.IMachineUpgradeItem;
import ic2.api.tile.IMachine;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.item.ItemIC2;
import ic2.core.item.upgrades.BasicExportUpgrade;
import ic2.core.item.upgrades.BasicImportUpgrade;
import ic2.core.item.upgrades.EnergyStorageUpgrade;
import ic2.core.item.upgrades.ExportUpgrade;
import ic2.core.item.upgrades.IUpgradeMetaItem;
import ic2.core.item.upgrades.ImportUpgrade;
import ic2.core.item.upgrades.MufflerUpgrade;
import ic2.core.item.upgrades.MuteUpgrade;
import ic2.core.item.upgrades.OverclockerUpgrade;
import ic2.core.item.upgrades.RedstoneInverterUpgrade;
import ic2.core.item.upgrades.RedstoneSensitivityUpgrade;
import ic2.core.item.upgrades.TransformerUpgrade;
import ic2.core.util.IExtraData;
import ic2.core.util.KeyboardClient;
import ic2.core.util.StackUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemUpgradeModule
extends ItemIC2
implements IExtraData,
IMachineUpgradeItem {
    public Map<Integer, IUpgradeMetaItem> upgrades = new HashMap<Integer, IUpgradeMetaItem>();

    public ItemUpgradeModule() {
        super(176);
        this.func_77637_a(IC2.tabIC2);
        this.func_77627_a(true);
        this.func_77655_b("ic2upgrades");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1, EntityPlayer par2, List par3, boolean par4) {
        super.func_77624_a(par1, par2, par3, par4);
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(par1));
        if (item != null) {
            if (item.usesDirection()) {
                par3.add(StatCollector.func_74837_a((String)"itemInfo.upgradeDirection.name", (Object[])new Object[]{this.getDir(par1)}));
            }
            if (item.usesOwner()) {
                boolean shift = GuiScreen.func_146272_n();
                if (this.getOwner(par1) == null || shift) {
                    par3.add(StatCollector.func_74837_a((String)"itemInfo.setUpgradeOwner.name", (Object[])new Object[]{((KeyboardClient)IC2.keyboard).getKey(3)}));
                    if (shift) {
                        par3.addAll(Arrays.asList(StatCollector.func_74838_a((String)"itemInfo.setUpgradeDirection.name").split("%n ")));
                    }
                }
                if (this.getOwner(par1) != null) {
                    par3.add(StatCollector.func_74837_a((String)"itemInfo.upgradeOwner.name", (Object[])new Object[]{this.getPlayerName(par1)}));
                }
            }
        }
    }

    @Override
    public IIcon func_77617_a(int meta) {
        IUpgradeMetaItem item = this.upgrades.get(meta);
        if (item != null) {
            return item.getTexture();
        }
        return Ic2Icons.getTexture("i0")[176];
    }

    public String func_77667_c(ItemStack par1) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(par1));
        if (item != null) {
            return item.getName();
        }
        return null;
    }

    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack stack;
        for (int meta = 0; meta <= Short.MAX_VALUE && this.func_77667_c(stack = new ItemStack((Item)this, 1, meta)) != null; ++meta) {
            itemList.add(stack);
        }
    }

    public ItemStack func_77659_a(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        IUpgradeMetaItem item;
        if (!p_77659_2_.field_72995_K && IC2.keyboard.isSideinventoryKeyDown(p_77659_3_) && (item = this.upgrades.get(this.getMeta(p_77659_1_))).usesOwner()) {
            this.setOwner(p_77659_1_, p_77659_3_);
            IC2.platform.messagePlayer(p_77659_3_, StatCollector.func_74837_a((String)"itemInfo.defineUpgradeOwner.name", (Object[])new Object[]{p_77659_3_.func_146103_bH().getName()}));
        }
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    @Override
    public void init() {
        Ic2Items.overclockerUpgrade = new ItemStack((Item)this, 1, 0);
        Ic2Items.transformerUpgrade = new ItemStack((Item)this, 1, 1);
        Ic2Items.energyStorageUpgrade = new ItemStack((Item)this, 1, 2);
        Ic2Items.redstoneSUpgrade = new ItemStack((Item)this, 1, 3);
        Ic2Items.redstoneIUpgrade = new ItemStack((Item)this, 1, 4);
        Ic2Items.importBasicUpgrade = new ItemStack((Item)this, 1, 5);
        Ic2Items.importUpgrade = new ItemStack((Item)this, 1, 6);
        Ic2Items.exportBasicUpgrade = new ItemStack((Item)this, 1, 7);
        Ic2Items.exportUpgrade = new ItemStack((Item)this, 1, 8);
        Ic2Items.mufflerUpgrade = new ItemStack((Item)this, 1, 9);
        Ic2Items.muteUpgrade = new ItemStack((Item)this, 1, 10);
        this.upgrades.put(0, new OverclockerUpgrade());
        this.upgrades.put(1, new TransformerUpgrade());
        this.upgrades.put(2, new EnergyStorageUpgrade());
        this.upgrades.put(3, new RedstoneSensitivityUpgrade());
        this.upgrades.put(4, new RedstoneInverterUpgrade());
        this.upgrades.put(5, new BasicImportUpgrade());
        this.upgrades.put(6, new ImportUpgrade());
        this.upgrades.put(7, new BasicExportUpgrade());
        this.upgrades.put(8, new ExportUpgrade());
        this.upgrades.put(9, new MufflerUpgrade());
        this.upgrades.put(10, new MuteUpgrade());
    }

    @Override
    public int getExtraProcessTime(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getExtraProcessTime(upgrade, machine);
        }
        return 0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getProcessTimeMultiplier(upgrade, machine);
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyDemand(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getExtraEnergyDemand(upgrade, machine);
        }
        return 0;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getEnergyDemandMultiplier(upgrade, machine);
        }
        return 1.0;
    }

    @Override
    public int getExtraEnergyStorage(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getExtraEnergyStorage(upgrade, machine);
        }
        return 0;
    }

    @Override
    public double getEnergyStorageMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getEnergyStorageMultiplier(upgrade, machine);
        }
        return 1.0;
    }

    @Override
    public int getExtraTier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getExtraTier(upgrade, machine);
        }
        return 0;
    }

    @Override
    public boolean onTick(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null && item.needsTick()) {
            return item.onTick(upgrade, machine);
        }
        return false;
    }

    @Override
    public void onProcessEnd(ItemStack upgrade, IMachine machine, List<ItemStack> results) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            item.onProcessEnd(upgrade, machine, results);
        }
    }

    @Override
    public boolean useRedstoneinverter(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.useRedstoneinverter(upgrade, machine);
        }
        return false;
    }

    @Override
    public void onInstalling(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            item.onInstalling(upgrade, machine);
        }
    }

    @Override
    public IMachine.UpgradeType getType(ItemStack par1) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(par1));
        if (item != null) {
            return item.getType();
        }
        return null;
    }

    @Override
    public float getSoundVolumeMultiplier(ItemStack upgrade, IMachine machine) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(upgrade));
        if (item != null) {
            return item.getSoundVolumeMultiplier(upgrade, machine);
        }
        return 1.0f;
    }

    public int getItemStackLimit(ItemStack stack) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(stack));
        if (item != null) {
            return item.getMaxStackSize();
        }
        return super.getItemStackLimit(stack);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        IUpgradeMetaItem item = this.upgrades.get(this.getMeta(stack));
        if (!world.field_72995_K && item != null && item.usesDirection()) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            this.setDirection(stack, player.func_70093_af() ? dir : dir.getOpposite());
            IC2.platform.messagePlayer(player, StatCollector.func_74837_a((String)"itemInfo.defineDirection.name", (Object[])new Object[]{player.func_70093_af() ? dir : dir.getOpposite()}));
            return true;
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public int getMeta(ItemStack par1) {
        return par1.func_77960_j();
    }

    public long getWorldTime(IMachine par1) {
        return ((TileEntity)par1).func_145831_w().func_72820_D();
    }

    public void setDirection(ItemStack par1, ForgeDirection dir) {
        if (par1 == null) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        if (nbt.func_74764_b("UpgradeData")) {
            NBTTagCompound data = nbt.func_74775_l("UpgradeData");
            data.func_74768_a("Direction", dir.ordinal());
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("Direction", dir.ordinal());
        nbt.func_74782_a("UpgradeData", (NBTBase)data);
    }

    public ForgeDirection getDir(ItemStack par1) {
        if (par1 == null) {
            return ForgeDirection.UNKNOWN;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        if (!nbt.func_74764_b("UpgradeData")) {
            return ForgeDirection.UNKNOWN;
        }
        NBTTagCompound data = nbt.func_74775_l("UpgradeData");
        return ForgeDirection.getOrientation((int)data.func_74762_e("Direction"));
    }

    public Direction getDirection(ItemStack par1) {
        return Direction.fromForgeDirection(this.getDir(par1));
    }

    public void setOwner(ItemStack par1, EntityPlayer par2) {
        if (par1 == null) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        GameProfile file = par2.func_146103_bH();
        UUID id = file.getId();
        if (nbt.func_74764_b("UpgradeData")) {
            NBTTagCompound data = nbt.func_74775_l("UpgradeData");
            data.func_74772_a("PlayerMost", id.getMostSignificantBits());
            data.func_74772_a("PlayerLeast", id.getLeastSignificantBits());
            data.func_74778_a("PlayerName", file.getName());
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("PlayerMost", id.getMostSignificantBits());
        data.func_74772_a("PlayerLeast", id.getLeastSignificantBits());
        data.func_74778_a("PlayerName", file.getName());
        nbt.func_74782_a("UpgradeData", (NBTBase)data);
    }

    public String getPlayerName(ItemStack par1) {
        if (par1 == null) {
            return null;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        if (!nbt.func_74764_b("UpgradeData")) {
            return null;
        }
        NBTTagCompound data = nbt.func_74775_l("UpgradeData");
        if (data.func_74764_b("PlayerName")) {
            return data.func_74779_i("PlayerName");
        }
        return null;
    }

    public UUID getOwner(ItemStack par1) {
        if (par1 == null) {
            return null;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        if (!nbt.func_74764_b("UpgradeData")) {
            return null;
        }
        NBTTagCompound data = nbt.func_74775_l("UpgradeData");
        if (data.func_74764_b("PlayerMost") && data.func_74764_b("PlayerLeast")) {
            return new UUID(data.func_74763_f("PlayerMost"), data.func_74763_f("PlayerLeast"));
        }
        return null;
    }
}

