/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.IHandHeldInventory;
import ic2.core.item.armor.ItemArmorJetpack;
import ic2.core.item.armor.NuclearJetpackInventory;
import ic2.core.item.armor.NuclearJetpackLogic;
import ic2.core.util.StackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemArmorNuclearJetpack
extends ItemArmorJetpack
implements IElectricItem,
IHandHeldInventory {
    public ItemArmorNuclearJetpack(int spriteIndex, int armorrendering) {
        super(spriteIndex, armorrendering);
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return 30000.0;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 0;
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public void use(ItemStack itemStack, int amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public int getCharge(ItemStack itemStack) {
        return (int)ElectricItem.manager.discharge(itemStack, 2.147483647E9, Integer.MAX_VALUE, true, false, true);
    }

    @Override
    public float getDropPercentage() {
        return 0.05f;
    }

    @Override
    public float getPower() {
        return 0.95f;
    }

    @Override
    public boolean isElectricJetpack() {
        return true;
    }

    @Override
    public IHasGui getInventory(EntityPlayer p0, ItemStack p1) {
        return new NuclearJetpackInventory(p0, p1);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (world.field_72995_K) {
            return;
        }
        NuclearJetpackLogic reactor = new NuclearJetpackLogic(itemStack, player);
        reactor.onTick(player, itemStack);
        reactor.save(itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack stack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(stack) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(stack) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1, EntityPlayer par2, List par3, boolean par4) {
        super.func_77624_a(par1, par2, par3, par4);
        if (GuiContainer.func_146272_n()) {
            par3.addAll(Arrays.asList(StatCollector.func_74838_a((String)"itemInfo.nuclearJetpackUsage.name").split("%n ")));
        } else {
            par3.add(StatCollector.func_74837_a((String)"itemInfo.pressShiftInfo.name", (Object[])new Object[]{EnumChatFormatting.AQUA, EnumChatFormatting.GRAY}));
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
            NBTTagCompound logic = nbt.func_74775_l("Logic");
            par3.add(StatCollector.func_74837_a((String)"itemInfo.nuclearJetpackReactorHeat.name", (Object[])new Object[]{logic.func_74762_e("Heat"), logic.func_74762_e("MaxHeat")}));
            par3.add(StatCollector.func_74837_a((String)"itemInfo.nuclearJetpackCompDamage.name", (Object[])new Object[]{100 - logic.func_74762_e("PartHeat") + "%"}));
        }
        NBTTagCompound data = StackUtil.getOrCreateNbtData(par1);
        if (data.func_74767_n("RocketMode")) {
            int usedEnergy = data.func_74762_e("UsedEnergy");
            int result = (int)((double)usedEnergy / (double)this.getMaxRocketCharge() * 100.0);
            par3.add(StatCollector.func_74837_a((String)"itemInfo.nuclearJetpackRocketCharge.name", (Object[])new Object[]{result + "%"}));
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par3EntityPlayer.func_70093_af()) {
            if (IC2.platform.isSimulating()) {
                IC2.platform.launchGui(par3EntityPlayer, this.getInventory(par3EntityPlayer, par1ItemStack));
            }
            return par1ItemStack;
        }
        return super.func_77659_a(par1ItemStack, par2World, par3EntityPlayer);
    }

    @Override
    public int getFuelCost(boolean hoverMode) {
        return hoverMode ? 9 : 12;
    }

    @Override
    public int getMaxHeight(int worldHight) {
        return (int)((float)worldHight / 1.1f);
    }

    @Override
    public float getThruster(boolean hoverMode) {
        return hoverMode ? 0.8f : 0.3f;
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(2, 0.5, 3);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 2;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @Override
    public boolean canDoRocketMode() {
        return true;
    }

    @Override
    public int getMaxRocketCharge() {
        return 25000;
    }

    @Override
    public String getTextureName() {
        return "jetpack_Electric";
    }
}

