/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import ic2.api.item.ElectricItem;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class NuclearJetpackLogic
implements IReactor {
    ItemStack[] parts = new ItemStack[25];
    int tick;
    int output;
    int heat;
    int partHeat;
    int maxHeat;
    float hem;
    boolean active;
    EntityPlayer player;

    public NuclearJetpackLogic(ItemStack par1, EntityPlayer par2) {
        NBTTagCompound data = StackUtil.getOrCreateNbtData(par1);
        this.readInventory(data.func_74775_l("Inventory"));
        this.readLogic(data.func_74775_l("Logic"));
        this.player = par2;
    }

    public void save(ItemStack par1) {
        NBTTagCompound data = StackUtil.getOrCreateNbtData(par1);
        NBTTagCompound inv = new NBTTagCompound();
        NBTTagCompound logic = new NBTTagCompound();
        this.writeInventory(inv);
        this.writeLogic(logic);
        data.func_74782_a("Inventory", (NBTBase)inv);
        data.func_74782_a("Logic", (NBTBase)logic);
    }

    private void readInventory(NBTTagCompound par1) {
        NBTTagList nbttaglist = par1.func_150295_c("Items", 10);
        this.parts = new ItemStack[25];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.parts.length) continue;
            this.parts[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    private void writeInventory(NBTTagCompound par1) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.parts[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    private void readLogic(NBTTagCompound par1) {
        this.tick = par1.func_74762_e("CurrentTick");
        this.active = par1.func_74767_n("Active");
        this.heat = par1.func_74762_e("Heat");
        this.output = par1.func_74762_e("output");
        this.partHeat = par1.func_74762_e("PartHeat");
        this.maxHeat = par1.func_74762_e("MaxHeat");
        this.hem = par1.func_74760_g("Hem");
    }

    private void writeLogic(NBTTagCompound par1) {
        par1.func_74768_a("CurrentTick", this.tick);
        par1.func_74757_a("Active", this.active);
        par1.func_74768_a("Heat", this.heat);
        par1.func_74768_a("output", this.output);
        par1.func_74768_a("PartHeat", this.partHeat);
        par1.func_74768_a("MaxHeat", this.maxHeat);
        par1.func_74776_a("Hem", this.hem);
    }

    public void onTick(EntityPlayer par1, ItemStack jetpack) {
        this.updateState(jetpack);
        if (this.tick++ % 20 == 0) {
            this.tick = 0;
            if (this.updateReactor()) {
                par1.field_71071_by.field_70460_b[2] = null;
                return;
            }
            this.updatepartHeat();
        }
        ElectricItem.manager.charge(jetpack, this.output, Integer.MAX_VALUE, true, false);
        this.updateState(jetpack);
    }

    public void updatepartHeat() {
        int[] partHeat = new int[25];
        int count = 0;
        for (int i = 0; i < this.parts.length; ++i) {
            IReactorComponent comp;
            int maxHeat;
            ItemStack part = this.parts[i];
            if (part == null || !(part.func_77973_b() instanceof IReactorComponent) || (maxHeat = (comp = (IReactorComponent)part.func_77973_b()).getMaxHeat(this, part, i % 5, i / 5)) <= 0) continue;
            partHeat[count] = (int)((double)part.func_77960_j() / (double)maxHeat * 100.0);
            ++count;
        }
        if (count > 0) {
            double cu = 0.0;
            for (int i = 0; i < count; ++i) {
                cu += (double)partHeat[i];
            }
            this.partHeat = (int)(cu /= (double)count);
        } else {
            this.partHeat = 0;
        }
    }

    public void updateState(ItemStack par1) {
        if (!this.active) {
            double produce = ElectricItem.manager.getCharge(par1) / 30000.0 * 100.0;
            if (produce < 30.0) {
                this.active = true;
            }
        } else if (ElectricItem.manager.getCharge(par1) >= 30000.0) {
            this.active = false;
        }
    }

    public boolean updateReactor() {
        this.output = 0;
        this.maxHeat = 10000;
        this.hem = 1.0f;
        this.processChamber();
        return this.calculateHeatEffects();
    }

    public boolean calculateHeatEffects() {
        Material mat;
        Block id;
        int[] coord;
        if (this.heat < 4000 || !IC2.platform.isSimulating() || IC2.explosionPowerReactorMax <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        World worldObj = this.getWorld();
        if (power >= 0.85f && worldObj.field_73012_v.nextFloat() <= 0.2f * this.hem && (coord = this.getRandCoord(2)) != null) {
            id = worldObj.func_147439_a(coord[0], coord[1], coord[2]);
            if (id == null) {
                worldObj.func_147449_b(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab);
            } else if (id.func_149712_f(worldObj, coord[0], coord[1], coord[2]) <= -1.0f) {
                mat = id.func_149688_o();
                if (mat == Material.field_151576_e || mat == Material.field_151573_f || mat == Material.field_151587_i || mat == Material.field_151578_c || mat == Material.field_151571_B) {
                    worldObj.func_147465_d(coord[0], coord[1], coord[2], (Block)Blocks.field_150356_k, 15, 3);
                } else {
                    worldObj.func_147449_b(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab);
                }
            }
        }
        if (power >= 0.7f) {
            ChunkCoordinates coords = this.getPosition();
            List list1 = worldObj.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(coords.field_71574_a - 3), (double)(coords.field_71572_b - 3), (double)(coords.field_71573_c - 3), (double)(coords.field_71574_a + 4), (double)(coords.field_71572_b + 4), (double)(coords.field_71573_c + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                EntityLivingBase ent = (EntityLivingBase)list1.get(l);
                ent.func_70097_a((DamageSource)IC2DamageSource.radiation, (float)((int)((float)worldObj.field_73012_v.nextInt(4) * this.hem)));
            }
        }
        if (power >= 0.5f && worldObj.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = worldObj.func_147439_a(coord[0], coord[1], coord[2])) != null && id.func_149688_o() == Material.field_151586_h) {
            worldObj.func_147468_f(coord[0], coord[1], coord[2]);
        }
        if (power >= 0.4f && worldObj.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = worldObj.func_147439_a(coord[0], coord[1], coord[2])) != null && ((mat = id.func_149688_o()) == Material.field_151575_d || mat == Material.field_151584_j || mat == Material.field_151580_n)) {
            worldObj.func_147449_b(coord[0], coord[1], coord[2], (Block)Blocks.field_150480_ab);
        }
        return false;
    }

    public void processChamber() {
        for (int pass = 0; pass < 2; ++pass) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 5; ++y) {
                    ItemStack stack = this.getMatrix(x, y);
                    if (stack == null || !(stack.func_77973_b() instanceof IReactorComponent)) continue;
                    IReactorComponent comp = (IReactorComponent)stack.func_77973_b();
                    comp.processChamber(this, stack, x, y, pass == 0);
                }
            }
        }
    }

    public int[] getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        ChunkCoordinates coords = this.getPosition();
        World worldObj = this.getWorld();
        int[] c = new int[]{coords.field_71574_a + worldObj.field_73012_v.nextInt(2 * radius + 1) - radius, coords.field_71572_b + worldObj.field_73012_v.nextInt(2 * radius + 1) - radius, coords.field_71573_c + worldObj.field_73012_v.nextInt(2 * radius + 1) - radius};
        if (c[0] == coords.field_71574_a && c[1] == coords.field_71572_b && c[2] == coords.field_71573_c) {
            return null;
        }
        return c;
    }

    @Override
    public ChunkCoordinates getPosition() {
        return new ChunkCoordinates((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v);
    }

    @Override
    public World getWorld() {
        return this.player.field_70170_p;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        return this.heat += amount;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public void addEmitHeat(int heat) {
    }

    @Override
    public float getHeatEffectModifier() {
        return this.hem;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.output;
    }

    @Override
    public float addOutput(float energy) {
        this.output = (int)((float)this.output + energy);
        return this.output;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.getMatrix(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        this.setMatrix(x, y, item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        float boomMod = 1.0f;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                ItemStack stack = this.getMatrix(x, y);
                if (stack != null && stack.func_77973_b() instanceof IReactorComponent) {
                    float f = ((IReactorComponent)stack.func_77973_b()).influenceExplosion(this, stack);
                    if (f > 0.0f && f < 1.0f) {
                        boomMod *= f;
                    } else {
                        boomPower += f;
                    }
                }
                this.setMatrix(x, y, null);
            }
        }
        IC2.log.info("Nuclear Jetpack at " + this.player.field_70170_p.field_73011_w.field_76574_g + ":(" + this.player.field_70165_t + "," + this.player.field_70163_u + "," + this.player.field_70161_v + ") melted (explosion power " + (boomPower *= this.hem * boomMod) + ")");
        if (boomPower > IC2.explosionPowerReactorMax) {
            boomPower = IC2.explosionPowerReactorMax;
        }
        this.player.field_71071_by.field_70460_b[2] = null;
        this.player.field_71070_bA.func_75142_b();
        ExplosionIC2 explosion = new ExplosionIC2(this.player.field_70170_p, null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, boomPower, 0.01f, 1.5f, IC2DamageSource.nuke);
        explosion.doExplosion();
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    public boolean produceEnergy() {
        return this.active;
    }

    public ItemStack getStackInSlot(int i) {
        return this.parts[i];
    }

    public void setInventoryContent(int i, ItemStack par1) {
        this.parts[i] = par1;
    }

    public void setMatrix(int x, int y, ItemStack par1) {
        if (x < 0 || x >= 5 || y < 0 || y >= 5) {
            return;
        }
        this.setInventoryContent(x + y * 5, par1);
    }

    public ItemStack getMatrix(int x, int y) {
        if (x < 0 || x >= 5 || y < 0 || y >= 5) {
            return null;
        }
        return this.getStackInSlot(x + y * 5);
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return this.output;
    }

    @Override
    public void setRedstoneSignal(boolean redstone) {
    }

    @Override
    public boolean isFluidCooled() {
        return false;
    }
}

