/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.item.ItemIC2;
import net.minecraft.item.ItemStack;

public class ItemReactorHeatpack
extends ItemIC2
implements IReactorComponent {
    public int maxPer;
    public int heatPer;

    public ItemReactorHeatpack(int index, int maxper, int heatper) {
        super(index);
        this.maxPer = maxper;
        this.heatPer = heatper;
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun) {
        this.heat(reactor, yourStack.field_77994_a, x + 1, y);
        this.heat(reactor, yourStack.field_77994_a, x - 1, y);
        this.heat(reactor, yourStack.field_77994_a, x, y + 1);
        this.heat(reactor, yourStack.field_77994_a, x, y - 1);
    }

    private void heat(IReactor reactor, int stacksize, int x, int y) {
        IReactorComponent comp;
        int want = this.maxPer * stacksize;
        if (reactor.getHeat() >= want) {
            return;
        }
        ItemStack stack = reactor.getItemAt(x, y);
        if (stack != null && stack.func_77973_b() instanceof IReactorComponent && (comp = (IReactorComponent)stack.func_77973_b()).canStoreHeat(reactor, stack, x, y)) {
            int add = this.heatPer * stacksize;
            int curr = comp.getCurrentHeat(reactor, stack, x, y);
            if (add > want - curr) {
                add = want - curr;
            }
            if (add > 0) {
                comp.alterHeat(reactor, stack, x, y, add);
            }
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        return 0;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return yourStack.field_77994_a / 10;
    }
}

