/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import com.mojang.authlib.GameProfile;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.IC2;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class DataEncoder {
    public static Object decode(DataInputStream is) throws IOException {
        byte type = is.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return is.readInt();
            }
            case 1: {
                int length = is.readShort();
                int[] idata = new int[length];
                for (int i = 0; i < length; ++i) {
                    idata[i] = is.readInt();
                }
                return idata;
            }
            case 2: {
                return is.readShort();
            }
            case 3: {
                int length = is.readShort();
                short[] shdata = new short[length];
                for (int j = 0; j < length; ++j) {
                    shdata[j] = is.readShort();
                }
                return shdata;
            }
            case 4: {
                return is.readByte();
            }
            case 5: {
                int length = is.readShort();
                byte[] bydata = new byte[length];
                for (int k = 0; k < length; ++k) {
                    bydata[k] = is.readByte();
                }
                return bydata;
            }
            case 6: {
                return is.readLong();
            }
            case 7: {
                int length = is.readShort();
                long[] ldata = new long[length];
                for (int l = 0; l < length; ++l) {
                    ldata[l] = is.readLong();
                }
                return ldata;
            }
            case 8: {
                return is.readBoolean();
            }
            case 9: {
                int length = is.readShort();
                boolean[] bdata = new boolean[length];
                byte b = 0;
                for (int m = 0; m < length; ++m) {
                    if (m % 8 == 0) {
                        b = is.readByte();
                    }
                    bdata[m] = (b & 1 << m % 8) != 0;
                }
                return bdata;
            }
            case 10: {
                int length = is.readShort();
                char[] cdata = new char[length];
                for (int i2 = 0; i2 < length; ++i2) {
                    cdata[i2] = is.readChar();
                }
                return new String(cdata);
            }
            case 11: {
                int length = is.readShort();
                String[] stdata = new String[length];
                for (int i3 = 0; i3 < length; ++i3) {
                    int slength = is.readShort();
                    char[] sdata = new char[slength];
                    for (int j2 = 0; j2 < slength; ++j2) {
                        sdata[j2] = is.readChar();
                    }
                    stdata[i3] = new String(sdata);
                }
                return stdata;
            }
            case 12: {
                int id = is.readInt();
                if (id <= 0) {
                    return null;
                }
                byte size = is.readByte();
                short meta = is.readShort();
                ItemStack stack = new ItemStack(Item.func_150899_d((int)id), (int)size, (int)meta);
                boolean nbt = is.readBoolean();
                if (nbt) {
                    stack.func_77982_d(CompressedStreamTools.func_74794_a((DataInputStream)is));
                }
                return stack;
            }
            case 13: {
                return CompressedStreamTools.func_74794_a((DataInputStream)is);
            }
            case 14: {
                byte subType = is.readByte();
                switch (subType) {
                    case 0: {
                        return Block.func_149729_e((int)is.readInt());
                    }
                    case 1: {
                        return Item.func_150899_d((int)is.readInt());
                    }
                    case 2: {
                        return StatList.func_151177_a((String)is.readUTF());
                    }
                    case 3: {
                        return Potion.field_76425_a[is.readInt()];
                    }
                    case 4: {
                        return Enchantment.field_77331_b[is.readInt()];
                    }
                }
            }
            case 15: {
                byte subType = is.readByte();
                switch (subType) {
                    case 0: {
                        return new ChunkCoordinates(is.readInt(), is.readInt(), is.readInt());
                    }
                    case 1: {
                        return new ChunkCoordIntPair(is.readInt(), is.readInt());
                    }
                    case 2: {
                        return new ChunkPosition(is.readInt(), is.readInt(), is.readInt());
                    }
                }
            }
            case 16: {
                World world = IC2.platform.getWorld(is.readInt());
                if (world == null) {
                    return null;
                }
                return world.func_147438_o(is.readInt(), is.readInt(), is.readInt());
            }
            case 17: {
                return IC2.platform.getWorld(is.readInt());
            }
            case 18: {
                return Float.valueOf(is.readFloat());
            }
            case 19: {
                int length = is.readShort();
                float[] fdata = new float[length];
                for (int i4 = 0; i4 < length; ++i4) {
                    fdata[i4] = is.readFloat();
                }
                return fdata;
            }
            case 20: {
                return is.readDouble();
            }
            case 21: {
                int length = is.readShort();
                double[] ddata = new double[length];
                for (int i5 = 0; i5 < length; ++i5) {
                    ddata[i5] = is.readDouble();
                }
                return ddata;
            }
            case 22: {
                FluidStack stack = new FluidStack(FluidRegistry.getFluid((int)is.readInt()), is.readInt());
                boolean flag = is.readBoolean();
                if (flag) {
                    stack.tag = CompressedStreamTools.func_74794_a((DataInputStream)is);
                }
                return stack;
            }
            case 23: {
                boolean empty = is.readBoolean();
                if (empty) {
                    return new FluidTank(is.readInt());
                }
                return new FluidTank((FluidStack)DataEncoder.decode(is), is.readInt());
            }
            case 24: {
                byte subType = is.readByte();
                switch (subType) {
                    case 0: {
                        return new UUID(is.readLong(), is.readLong());
                    }
                    case 1: {
                        return new GameProfile((UUID)DataEncoder.decode(is), is.readUTF());
                    }
                }
            }
            case 25: {
                return Crops.instance.getCropCard(is.readUTF(), is.readUTF());
            }
            case 26: {
                return is.readInt();
            }
        }
        IC2.platform.displayError("An unknown data type was received over multiplayer to be decoded.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: type ID " + type + ")");
        return null;
    }

    public static void encode(DataOutputStream os, Object o) throws IOException {
        if (o == null) {
            os.writeByte(-1);
        }
        if (o instanceof Integer) {
            os.writeByte(0);
            os.writeInt((Integer)o);
        } else if (o instanceof int[]) {
            os.writeByte(1);
            int[] array = (int[])o;
            os.writeShort(array.length);
            for (int i = 0; i < array.length; ++i) {
                os.writeInt(array[i]);
            }
        } else if (o instanceof Short) {
            os.writeByte(2);
            os.writeShort(((Short)o).shortValue());
        } else if (o instanceof short[]) {
            os.writeByte(3);
            short[] oa2 = (short[])o;
            os.writeShort(oa2.length);
            for (int i = 0; i < oa2.length; ++i) {
                os.writeShort(oa2[i]);
            }
        } else if (o instanceof Byte) {
            os.writeByte(4);
            os.writeByte(((Byte)o).byteValue());
        } else if (o instanceof byte[]) {
            os.writeByte(5);
            byte[] oa3 = (byte[])o;
            os.writeShort(oa3.length);
            for (int i = 0; i < oa3.length; ++i) {
                os.writeByte(oa3[i]);
            }
        } else if (o instanceof Long) {
            os.writeByte(6);
            os.writeLong((Long)o);
        } else if (o instanceof long[]) {
            os.writeByte(7);
            long[] oa4 = (long[])o;
            os.writeShort(oa4.length);
            for (int i = 0; i < oa4.length; ++i) {
                os.writeLong(oa4[i]);
            }
        } else if (o instanceof Boolean) {
            os.writeByte(8);
            os.writeBoolean((Boolean)o);
        } else if (o instanceof boolean[]) {
            os.writeByte(9);
            boolean[] oa5 = (boolean[])o;
            os.writeShort(oa5.length);
            int b = 0;
            for (int j = 0; j < oa5.length; ++j) {
                if (j % 8 == 0 && j > 0) {
                    os.writeByte(b);
                    b = 0;
                }
                b = (byte)(b | (byte)((oa5[j] ? 1 : 0) << j % 8));
            }
            os.writeByte(b);
        } else if (o instanceof String) {
            os.writeByte(10);
            String oa6 = (String)o;
            os.writeShort(oa6.length());
            os.writeChars(oa6);
        } else if (o instanceof String[]) {
            os.writeByte(11);
            String[] oa7 = (String[])o;
            os.writeShort(oa7.length);
            for (int i = 0; i < oa7.length; ++i) {
                os.writeShort(oa7[i].length());
                os.writeChars(oa7[i]);
            }
        } else if (o instanceof ItemStack) {
            NBTTagCompound nbt;
            os.writeByte(12);
            ItemStack item = (ItemStack)o;
            int id = Item.func_150891_b((Item)item.func_77973_b());
            os.writeInt(id);
            if (id <= 0) {
                return;
            }
            os.writeByte(item.field_77994_a);
            os.writeShort(item.func_77960_j());
            boolean nbtData = item.func_77942_o();
            os.writeBoolean(nbtData);
            if (nbtData && (nbt = item.func_77978_p()) != null) {
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)os);
            }
        } else if (o instanceof NBTTagCompound) {
            os.writeByte(13);
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)o), (DataOutput)os);
        } else if (o instanceof Block) {
            os.writeByte(14);
            os.writeByte(0);
            os.writeInt(Block.func_149682_b((Block)((Block)o)));
        } else if (o instanceof Item) {
            os.writeByte(14);
            os.writeByte(1);
            os.writeInt(Item.func_150891_b((Item)((Item)o)));
        } else if (o instanceof Achievement) {
            os.writeByte(14);
            os.writeByte(2);
            os.writeUTF(((StatBase)o).field_75975_e);
        } else if (o instanceof Potion) {
            os.writeByte(14);
            os.writeByte(3);
            os.writeInt(((Potion)o).field_76415_H);
        } else if (o instanceof Enchantment) {
            os.writeByte(14);
            os.writeByte(4);
            os.writeInt(((Enchantment)o).field_77352_x);
        } else if (o instanceof ChunkCoordinates) {
            os.writeByte(15);
            os.writeByte(0);
            ChunkCoordinates coords = (ChunkCoordinates)o;
            os.writeInt(coords.field_71574_a);
            os.writeInt(coords.field_71572_b);
            os.writeInt(coords.field_71573_c);
        } else if (o instanceof ChunkCoordIntPair) {
            os.writeByte(15);
            os.writeByte(1);
            ChunkCoordIntPair coords = (ChunkCoordIntPair)o;
            os.writeInt(coords.field_77276_a);
            os.writeInt(coords.field_77275_b);
        } else if (o instanceof ChunkPosition) {
            os.writeByte(15);
            os.writeByte(2);
            ChunkPosition pos = (ChunkPosition)o;
            os.writeInt(pos.field_151329_a);
            os.writeInt(pos.field_151327_b);
            os.writeInt(pos.field_151328_c);
        } else if (o instanceof TileEntity) {
            os.writeByte(16);
            TileEntity oa12 = (TileEntity)o;
            os.writeInt(oa12.func_145831_w().field_73011_w.field_76574_g);
            os.writeInt(oa12.field_145851_c);
            os.writeInt(oa12.field_145848_d);
            os.writeInt(oa12.field_145849_e);
        } else if (o instanceof World) {
            os.writeInt(17);
            os.writeInt(((World)o).field_73011_w.field_76574_g);
        } else if (o instanceof Float) {
            os.writeByte(18);
            os.writeFloat(((Float)o).floatValue());
        } else if (o instanceof float[]) {
            os.writeByte(19);
            float[] oa13 = (float[])o;
            os.writeShort(oa13.length);
            for (int i = 0; i < oa13.length; ++i) {
                os.writeFloat(oa13[i]);
            }
        } else if (o instanceof Double) {
            os.writeByte(20);
            os.writeDouble((Double)o);
        } else if (o instanceof double[]) {
            os.writeByte(21);
            double[] oa14 = (double[])o;
            os.writeShort(oa14.length);
            for (int i = 0; i < oa14.length; ++i) {
                os.writeDouble(oa14[i]);
            }
        } else if (o instanceof FluidStack) {
            os.writeByte(22);
            FluidStack stack = (FluidStack)o;
            os.writeInt(stack.getFluidID());
            os.writeInt(stack.amount);
            NBTTagCompound data = stack.tag;
            os.writeBoolean(data != null);
            if (data != null) {
                CompressedStreamTools.func_74800_a((NBTTagCompound)data, (DataOutput)os);
            }
        } else if (o instanceof FluidTank) {
            os.writeByte(23);
            FluidTank tank = (FluidTank)o;
            boolean empty = tank.getFluid() == null;
            os.writeBoolean(empty);
            if (empty) {
                os.writeInt(tank.getCapacity());
            } else {
                DataEncoder.encode(os, tank.getFluid());
                os.writeInt(tank.getCapacity());
            }
        } else if (o instanceof UUID) {
            os.writeByte(24);
            os.writeByte(0);
            UUID id = (UUID)o;
            os.writeLong(id.getMostSignificantBits());
            os.writeLong(id.getLeastSignificantBits());
        } else if (o instanceof GameProfile) {
            os.writeByte(24);
            os.writeByte(1);
            GameProfile id = (GameProfile)o;
            DataEncoder.encode(os, id.getId());
            os.writeUTF(id.getName());
        } else if (o instanceof CropCard) {
            os.writeByte(25);
            CropCard card = (CropCard)o;
            os.writeUTF(card.owner());
            os.writeUTF(card.name());
        } else if (o instanceof Enum) {
            os.writeByte(26);
            os.writeInt(((Enum)o).ordinal());
        }
    }
}

