/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FieldUpdatePacket
extends IC2Packet {
    List<Integer> xCoords = new ArrayList<Integer>();
    List<Integer> yCoords = new ArrayList<Integer>();
    List<Integer> zCoords = new ArrayList<Integer>();
    List<String> fields = new ArrayList<String>();
    List<Object> data = new ArrayList<Object>();
    int dimID;
    int expected;

    public FieldUpdatePacket() {
    }

    public FieldUpdatePacket(List<NetworkManager.FieldData> par1, World par2) {
        this.expected = par1.size();
        for (NetworkManager.FieldData cu : par1) {
            this.xCoords.add(cu.x);
            this.yCoords.add(cu.y);
            this.zCoords.add(cu.z);
            this.fields.add(cu.fieldName);
            this.data.add(cu.data);
        }
        this.dimID = par2.field_73011_w.field_76574_g;
    }

    @Override
    public void read(ByteBuf par1) {
        try {
            int i;
            this.expected = par1.readInt();
            this.dimID = par1.readInt();
            for (i = 0; i < this.expected; ++i) {
                this.xCoords.add(par1.readInt());
            }
            for (i = 0; i < this.expected; ++i) {
                this.yCoords.add(par1.readInt());
            }
            for (i = 0; i < this.expected; ++i) {
                this.zCoords.add(par1.readInt());
            }
            for (i = 0; i < this.expected; ++i) {
                char[] rawName = new char[par1.readInt()];
                for (int c = 0; c < rawName.length; ++c) {
                    rawName[c] = par1.readChar();
                }
                this.fields.add(new String(rawName));
            }
            byte[] bytes = new byte[par1.readInt()];
            par1.readBytes(bytes);
            ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
            GZIPInputStream zipStream = new GZIPInputStream(buffer);
            DataInputStream stream = new DataInputStream(zipStream);
            for (int i2 = 0; i2 < this.expected; ++i2) {
                this.data.add(DataEncoder.decode(stream));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(ByteBuf par1) {
        try {
            int i;
            par1.writeInt(this.expected);
            par1.writeInt(this.dimID);
            for (i = 0; i < this.xCoords.size(); ++i) {
                par1.writeInt(this.xCoords.get(i).intValue());
            }
            for (i = 0; i < this.yCoords.size(); ++i) {
                par1.writeInt(this.yCoords.get(i).intValue());
            }
            for (i = 0; i < this.zCoords.size(); ++i) {
                par1.writeInt(this.zCoords.get(i).intValue());
            }
            for (i = 0; i < this.fields.size(); ++i) {
                String field = this.fields.get(i);
                par1.writeInt(field.length());
                for (char cars : field.toCharArray()) {
                    par1.writeChar((int)Character.valueOf(cars).charValue());
                }
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            GZIPOutputStream zipStream = new GZIPOutputStream(buffer);
            DataOutputStream stream = new DataOutputStream(zipStream);
            for (int i2 = 0; i2 < this.data.size(); ++i2) {
                Object obj = this.data.get(i2);
                DataEncoder.encode(stream, obj);
            }
            stream.close();
            zipStream.close();
            byte[] bytes = buffer.toByteArray();
            par1.writeInt(bytes.length);
            par1.writeBytes(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Got Incorrect Data");
        }
        for (int i = 0; i < this.expected; ++i) {
            try {
                int x = this.xCoords.get(i);
                int y = this.yCoords.get(i);
                int z = this.zCoords.get(i);
                String field = this.fields.get(i);
                Object value = this.data.get(i);
                TileEntity tile = world.func_147438_o(x, y, z);
                if (tile != null) {
                    Field targetField = null;
                    Class<?> fieldDeclaringClass = tile.getClass();
                    do {
                        try {
                            targetField = fieldDeclaringClass.getDeclaredField(field);
                        }
                        catch (NoSuchFieldException e4) {
                            fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                        }
                    } while (targetField == null && fieldDeclaringClass != null);
                    if (field == null) {
                        IC2.log.warn("Can't find field " + field + " in te " + tile + " at " + x + "/" + y + "/" + z);
                    } else {
                        targetField.setAccessible(true);
                    }
                    if (targetField != null && tile != null) {
                        if (targetField.getType().isEnum()) {
                            value = targetField.getType().getEnumConstants()[(Integer)value];
                        }
                        targetField.set(tile, value);
                    }
                }
                if (!(tile instanceof INetworkUpdateListener)) continue;
                ((INetworkUpdateListener)tile).onNetworkUpdate(field);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could not Inject TileEntity Data");
            }
        }
    }
}

