/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.item.IWrenchHandler;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventManager {
    public EventManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockClick(PlayerInteractEvent evt) {
        if (evt.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            boolean flag;
            World world = evt.world;
            int x = evt.x;
            int y = evt.y;
            int z = evt.z;
            EntityPlayer player = evt.entityPlayer;
            ItemStack item = player.func_71045_bC();
            TileEntity tile = world.func_147438_o(x, y, z);
            IWrenchHandler handler = this.getWrenchHandler(item);
            if (handler != null && tile instanceof IWrenchable && handler.canWrench(item, x, y, z, player) && (flag = this.handleWrench(handler, (IWrenchable)tile, item, player, world, x, y, z, evt.face))) {
                evt.setCanceled(true);
            }
        }
    }

    private boolean handleWrench(IWrenchHandler par1, IWrenchable wrenchable, ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side) {
        TileEntityTerra terra;
        if (wrenchable instanceof TileEntityTerra && (terra = (TileEntityTerra)wrenchable).ejectBlueprint()) {
            if (IC2.platform.isSimulating()) {
                par1.useWrench(item, x, y, z, player);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return true;
        }
        if (IC2.keyboard.isAltKeyDown(player)) {
            side = player.func_70093_af() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
        } else if (player.func_70093_af()) {
            side += side % 2 * -2 + 1;
        }
        if (wrenchable.wrenchCanSetFacing(player, side)) {
            if (IC2.platform.isSimulating()) {
                wrenchable.setFacing((short)side);
                par1.useWrench(item, x, y, z, player);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        if (wrenchable.wrenchCanRemove(player)) {
            if (IC2.platform.isSimulating()) {
                Block block = world.func_147439_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                boolean dropOriginalBlock = false;
                if (wrenchable.getWrenchDropRate() < 1.0f && this.checkIfNoloss(par1)) {
                    dropOriginalBlock = true;
                    par1.useWrench(item, x, y, z, player);
                } else {
                    dropOriginalBlock = world.field_73012_v.nextFloat() <= wrenchable.getWrenchDropRate();
                    par1.useWrench(item, x, y, z, player);
                }
                ArrayList drops = block.getDrops(world, x, y, z, meta, 0);
                if (dropOriginalBlock) {
                    if (drops.isEmpty()) {
                        drops.add(wrenchable.getWrenchDrop(player));
                    } else {
                        drops.set(0, wrenchable.getWrenchDrop(player));
                    }
                }
                for (ItemStack itemStack : drops) {
                    StackUtil.dropAsEntity(world, x, y, z, itemStack);
                }
                world.func_147468_f(x, y, z);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        return false;
    }

    private boolean checkIfNoloss(IWrenchHandler par1) {
        return IC2.losslessAddonWrenches;
    }

    private IWrenchHandler getWrenchHandler(ItemStack par1) {
        if (par1 == null) {
            return null;
        }
        for (IWrenchHandler handler : IC2.handlers) {
            if (!handler.supportsItem(par1)) continue;
            return handler;
        }
        return null;
    }
}

