/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.core;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.core.Ic2Items;
import ic2.core.block.machine.gui.GuiCanner;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.item.ItemTinCan;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class CanningRecipeHandler
extends TemplateRecipeHandler {
    List<RecipeEntry> recipeList = new ArrayList<RecipeEntry>();

    public CanningRecipeHandler() {
        this.load();
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return "Canning Machine";
    }

    public String getOverlayIdentifier() {
        return "canning";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCanner.class;
    }

    public String getGuiTexture() {
        return "ic2:textures/guiSprites/GUICanner.png";
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)140, (int)65);
    }

    public void drawExtras(int i) {
        float f = this.cycleticks >= 20 ? (float)((this.cycleticks - 20) % 40) / 20.0f : 0.0f;
        this.drawProgressBar(69, 25, 176, 15, 25, 13, f, 0);
        f = this.cycleticks <= 20 ? (float)this.cycleticks / 20.0f : 1.0f;
        this.drawProgressBar(24, 16, 176, 0, 14, 14, f, 3);
        CannerRecipe recipe = (CannerRecipe)((Object)this.arecipes.get(i));
        if (recipe != null && !recipe.recipe.extraInfo.equals("")) {
            GuiDraw.fontRenderer.func_78276_b(recipe.recipe.extraInfo, 50, 65, 0x404040);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    private String getRecipeId() {
        return "ic2:canner";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (RecipeEntry entry : this.recipeList) {
                this.arecipes.add(new CannerRecipe(entry));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (RecipeEntry entry : this.recipeList) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.output, (ItemStack)result)) continue;
            this.arecipes.add(new CannerRecipe(entry));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (RecipeEntry entry : this.recipeList) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.input, (ItemStack)ingredient) && (entry.container == null || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)entry.container, (ItemStack)ingredient))) continue;
            this.arecipes.add(new CannerRecipe(entry));
        }
    }

    void load() {
        this.loadFood();
        this.loadFuelCan();
    }

    void loadFuelCan() {
        for (Map.Entry<TileEntityElectrolyzer.ItemRecipe, Integer> entry : TileEntityCanner.fuelValues.entrySet()) {
            this.recipeList.add(new RecipeEntry(entry.getKey().toItem(), Ic2Items.filledFuelCan, "+" + entry.getValue() + " Fuel").setContainer(Ic2Items.fuelCan));
            this.recipeList.add(new RecipeEntry(entry.getKey().toItem(), Ic2Items.jetpack, "+" + entry.getValue() + " Fuel").setContainer(Ic2Items.jetpack));
        }
        for (Map.Entry<TileEntityElectrolyzer.ItemRecipe, Number> entry : TileEntityCanner.fuelMultiplyers.entrySet()) {
            this.recipeList.add(new RecipeEntry(entry.getKey().toItem(), Ic2Items.filledFuelCan, "+" + (int)(((Float)entry.getValue()).floatValue() * 100.0f) + "% Fuel Multiplier").setContainer(Ic2Items.fuelCan));
            this.recipeList.add(new RecipeEntry(entry.getKey().toItem(), Ic2Items.jetpack, "+" + (int)(((Float)entry.getValue()).floatValue() * 100.0f) + "% Fuel Multiplier").setContainer(Ic2Items.jetpack));
        }
        this.recipeList.add(new RecipeEntry(Ic2Items.constructionFoamPellet, Ic2Items.cfPack, "2 Points of CF").setContainer(Ic2Items.cfPack));
        this.recipeList.add(new RecipeEntry(Ic2Items.constructionFoamPellet, Ic2Items.constructionFoamSprayer, "2 Points of CF").setContainer(Ic2Items.constructionFoamSprayer));
    }

    void loadFood() {
        for (Item item : Item.field_150901_e) {
            if (item instanceof ItemTinCan || !(item instanceof ItemFood)) continue;
            ArrayList items = new ArrayList();
            item.func_150895_a(item, null, items);
            for (int i = 0; i < items.size(); ++i) {
                ItemStack stack = (ItemStack)items.get(i);
                if (stack == null) continue;
                int stackSize = this.getFoodValue(stack);
                int metadata = this.getFoodMeta(stack);
                if (stackSize <= 0) continue;
                this.recipeList.add(new RecipeEntry(stack, new ItemStack(Ic2Items.filledTinCan.func_77973_b(), stackSize, metadata), "").setContainer(Ic2Items.tinCan));
            }
        }
    }

    private int getFoodValue(ItemStack item) {
        if (item.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)item.func_77973_b();
            return (int)Math.ceil((double)food.func_150905_g(item) / 2.0);
        }
        if (item.func_77973_b() == Items.field_151105_aU || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150414_aQ)) {
            return 6;
        }
        return 0;
    }

    private int getFoodMeta(ItemStack item) {
        if (item == null) {
            return 0;
        }
        TileEntityElectrolyzer.ItemRecipe ccip = new TileEntityElectrolyzer.ItemRecipe(item);
        return TileEntityCanner.specialFood.containsKey(ccip) ? TileEntityCanner.specialFood.get(ccip) : 0;
    }

    public class RecipeEntry {
        ItemStack container;
        ItemStack input;
        ItemStack output;
        String extraInfo;

        public RecipeEntry(ItemStack input, ItemStack output, String extraInfo) {
            this.input = input;
            this.output = output;
            this.extraInfo = extraInfo;
        }

        public RecipeEntry setContainer(ItemStack par1) {
            this.container = par1;
            return this;
        }
    }

    public class CannerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        RecipeEntry recipe;

        public CannerRecipe(RecipeEntry entry) {
            super((TemplateRecipeHandler)CanningRecipeHandler.this);
            this.recipe = entry;
        }

        public List<PositionedStack> getIngredients() {
            List list = super.getIngredients();
            list.add(new PositionedStack((Object)this.recipe.input, 64, 6));
            if (this.recipe.container != null) {
                list.add(new PositionedStack((Object)this.recipe.container, 64, 42));
            }
            list.add(new PositionedStack((Object)Ic2Items.chargedReBattery, 25, 34));
            return list;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.recipe.output, 115, 24);
        }
    }
}

