/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.blocks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.dynamictransport.core.lib.BlockLib;
import net.slimevoid.dynamictransport.core.lib.ConfigurationLib;
import net.slimevoid.dynamictransport.items.ItemElevatorTool;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevator;
import net.slimevoid.dynamictransport.tileentity.TileEntityFloorMarker;
import net.slimevoid.dynamictransport.tileentity.TileEntityTransportBase;
import net.slimevoid.library.blocks.BlockBase;
import net.slimevoid.library.data.Logger;
import net.slimevoid.library.data.LoggerSlimevoidLib;
import net.slimevoid.library.tileentity.TileEntityBase;
import net.slimevoid.library.util.helpers.BlockHelper;

public class BlockTransportBase
extends BlockBase {
    protected IIcon[][] iconList;
    private static IIcon[] iconOverlays;

    public BlockTransportBase() {
        super(Material.field_151573_f, 3);
    }

    public CreativeTabs getCreativeTab() {
        return CreativeTabs.field_78029_e;
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.iconList[metadata][side];
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.iconList = new IIcon[3][6];
        this.iconList = BlockLib.registerIcons(iconRegister, this.iconList);
        iconOverlays = new IIcon[1];
        iconOverlays = BlockLib.registerIconOverLays(iconRegister, iconOverlays);
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z) != 2 && super.shouldCheckWeakPower(world, x, y, z, side);
    }

    public IIcon func_149673_e(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        IIcon output = this.iconList[iblockaccess.func_72805_g(i, j, k)][l];
        try {
            TileEntity tile = iblockaccess.func_147438_o(i, j, k);
            if (tile instanceof TileEntityTransportBase) {
                ItemStack itemstack = ((TileEntityTransportBase)tile).getCamoItem();
                if (itemstack == null && tile instanceof TileEntityFloorMarker) {
                    itemstack = ((TileEntityFloorMarker)tile).getCamoItem();
                }
                if (itemstack != null && itemstack.func_77973_b() != null) {
                    Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
                    int damage = itemstack.func_77960_j();
                    output = block.func_149691_a(l, damage);
                }
            }
        }
        catch (Exception e) {
            LoggerSlimevoidLib.getInstance((String)LoggerSlimevoidLib.filterClassName((String)((Object)((Object)this)).getClass().toString())).write(false, "Failed to get Camo Item", Logger.LogLevel.WARNING);
            LoggerSlimevoidLib.getInstance((String)LoggerSlimevoidLib.filterClassName((String)((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        return output;
    }

    public IIcon[] registerBottomIcons(IIconRegister iconRegister) {
        return null;
    }

    public IIcon[] registerTopIcons(IIconRegister iconRegister) {
        return null;
    }

    public IIcon[] registerFrontIcons(IIconRegister iconRegister) {
        return null;
    }

    public IIcon[] registerSideIcons(IIconRegister iconRegister) {
        return null;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityTransportBase) {
            ItemStack itemstack = ((TileEntityTransportBase)tile).getCamoItem();
            if (itemstack == null && tile instanceof TileEntityFloorMarker) {
                itemstack = ((TileEntityFloorMarker)tile).getCamoItem();
            }
            if (itemstack != null && itemstack.func_77973_b() != null) {
                Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
                return block.func_149709_b(world, x, y, z, side);
            }
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityTransportBase) {
            ItemStack itemstack = ((TileEntityTransportBase)tile).getCamoItem();
            if (itemstack == null && tile instanceof TileEntityFloorMarker) {
                itemstack = ((TileEntityFloorMarker)tile).getCamoItem();
            }
            if (itemstack != null && itemstack.func_77973_b() != null) {
                Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
                return block.func_149748_c(world, x, y, z, side);
            }
        }
        return 0;
    }

    public int func_149645_b() {
        return ConfigurationLib.ElevatorRenderId;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float xHit, float yHit, float zHit) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBase tileentity = (TileEntityBase)BlockHelper.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, (Class)this.getTileMapData(metadata));
        if (tileentity != null) {
            if (tileentity instanceof TileEntityElevator) {
                return ((TileEntityElevator)tileentity).onBlockActivated(entityplayer, side, xHit, yHit, zHit);
            }
            return tileentity.onBlockActivated(entityplayer);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getIconSideOverlay() {
        return iconOverlays[0];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        NBTTagCompound tags;
        ItemStack heldItem = FMLClientHandler.instance().getClientPlayerEntity().func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemElevatorTool && (tags = heldItem.func_77978_p()) != null && tags.func_74764_b("ComputerX")) {
            ChunkCoordinates possibleComputer = new ChunkCoordinates(tags.func_74762_e("ComputerX"), tags.func_74762_e("ComputerY"), tags.func_74762_e("ComputerZ"));
            switch (world.func_72805_g(x, y, z)) {
                case 1: {
                    if (!possibleComputer.equals((Object)new ChunkCoordinates(x, y, z))) break;
                    return ConfigurationLib.ComputerMaintenanceHighlight;
                }
                case 0: {
                    TileEntityElevator elevator = (TileEntityElevator)((Object)BlockHelper.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityElevator.class));
                    if (elevator == null || !elevator.getParent().equals((Object)possibleComputer)) break;
                    return ConfigurationLib.ElevatorMaintenanceHighlight;
                }
                case 2: {
                    TileEntityFloorMarker marker = (TileEntityFloorMarker)((Object)BlockHelper.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityFloorMarker.class));
                    if (marker == null || marker.getParentChunkCoords() == null || !marker.getParentChunkCoords().equals((Object)possibleComputer)) break;
                    return ConfigurationLib.MarkerMaintenanceHighlight;
                }
            }
        }
        return super.func_149720_d(world, x, y, z);
    }
}

