/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.entities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.dynamictransport.core.lib.ConfigurationLib;
import net.slimevoid.dynamictransport.entities.EntityMasterElevator;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevator;
import net.slimevoid.library.util.helpers.BlockHelper;

public class EntityElevatorPart
extends Entity {
    public EntityMasterElevator entityElevatorObj;
    private HashSet<Entity> confirmedRiders = new HashSet();
    private int elevatorYOffset;

    public EntityElevatorPart(World par1World, EntityMasterElevator parent, double x, double y, double z) {
        this(par1World);
        this.field_70169_q = x + 0.5;
        this.field_70167_r = y;
        this.field_70166_s = z + 0.5;
        this.func_70107_b(this.field_70169_q, this.field_70167_r, this.field_70166_s);
        this.entityElevatorObj = parent;
    }

    public EntityElevatorPart(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.field_70144_Y = 1.0f;
        this.field_70158_ak = true;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    protected void func_70088_a() {
        this.func_70096_w().func_82709_a(2, 5);
        this.func_70096_w().func_75682_a(3, (Object)0);
        this.func_70096_w().func_75682_a(4, (Object)0);
        this.func_70096_w().func_75682_a(5, (Object)0);
        this.func_70096_w().func_75682_a(6, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setElevatorYOffset(nbttagcompound.func_74762_e("Offset"));
        this.setOverlay(nbttagcompound.func_74765_d("overlay"));
        ItemStack Camo = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("CamoItem"));
        if (Camo != null) {
            this.setCamoItem(Camo);
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("Offset", this.getElevatorYOffset());
        if (this.getCamoItem() != null) {
            NBTTagCompound itemNBTTagCompound = new NBTTagCompound();
            this.getCamoItem().func_77955_b(itemNBTTagCompound);
            nbttagcompound.func_74782_a("CamoItem", (NBTBase)itemNBTTagCompound);
        }
        nbttagcompound.func_74777_a("overlay", this.getOverlay().shortValue());
    }

    public ItemStack getCamoItem() {
        return this.func_70096_w().func_82710_f(2);
    }

    public void setCamoItem(ItemStack itemstack) {
        this.func_70096_w().func_75692_b(2, (Object)itemstack);
    }

    public Short getOverlay() {
        return this.func_70096_w().func_75693_b(3);
    }

    public void setOverlay(Short overlay) {
        this.func_70096_w().func_75692_b(3, (Object)overlay);
    }

    private byte getStillCount() {
        return this.func_70096_w().func_75683_a(4);
    }

    private void setStillCount(byte b) {
        this.func_70096_w().func_75692_b(4, (Object)b);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateRiderPosition(this.field_70181_x);
            this.func_70091_d(0.0, this.field_70181_x, 0.0);
        }
    }

    protected void removeElevatorBlock() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v)) == ConfigurationLib.blockTransportBase && this.field_70170_p.func_72805_g(x, y, z) == 0) {
            TileEntityElevator tile = (TileEntityElevator)((Object)BlockHelper.getTileEntity((IBlockAccess)this.field_70170_p, (int)x, (int)y, (int)z, TileEntityElevator.class));
            if (tile != null) {
                if (tile.getCamoItem() != null) {
                    this.setCamoItem(tile.removeCamoItemWithoutDrop());
                }
                this.setElevatorYOffset(tile.getYOffest());
                this.setOverlay(tile.getOverlay());
            }
            this.field_70170_p.func_147468_f(x, y, z);
        }
    }

    protected void setTransitBlocks() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.getCamoItem() != null) {
            Block camouflage = Block.func_149634_a((Item)this.getCamoItem().func_77973_b());
            int blockLightValue = camouflage.func_149750_m();
            int blockWeakPower = camouflage.func_149709_b((IBlockAccess)this.field_70170_p, x, y, z, 0) / 2;
            int n = y = this.field_70167_r < this.field_70163_u ? y - 1 : y + 1;
            if (this.field_70170_p.func_147437_c(x, y, z)) {
                this.field_70170_p.func_147465_d(x, y, z, (Block)ConfigurationLib.blockPoweredLight[blockLightValue], blockWeakPower, 3);
            }
        }
    }

    public void setDead(ChunkCoordinates parentComputer) {
        boolean blockPlaced;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        boolean bl = blockPlaced = !this.field_70170_p.field_72995_K && (this.field_70170_p.func_147439_a(x, y, z) == ConfigurationLib.blockTransportBase || this.field_70170_p.func_147472_a((Block)ConfigurationLib.blockTransportBase, x, y, z, true, 1, null, null) && this.field_70170_p.func_147465_d(x, y, z, (Block)ConfigurationLib.blockTransportBase, 0, 3));
        if (!this.field_70170_p.field_72995_K) {
            if (blockPlaced) {
                TileEntityElevator tile = (TileEntityElevator)this.field_70170_p.func_147438_o(x, y, z);
                if (tile != null) {
                    tile.setParentElevatorComputer(parentComputer);
                    if (this.getCamoItem() != null) {
                        tile.setCamoItem(this.getCamoItem());
                    }
                    tile.setYOffset(this.getElevatorYOffset());
                    tile.setOverlay(this.getOverlay());
                }
            } else {
                this.func_70099_a(new ItemStack((Block)ConfigurationLib.blockTransportBase, 1, 0), 0.0f);
            }
        }
        this.updateRiders(true, 0.0);
        this.func_70106_y();
    }

    public void checkMotion(double velocity, double minSpeed) {
        if (!this.entityElevatorObj.getEmerHalt()) {
            if ((double)MathHelper.func_76135_e((float)((float)velocity)) < minSpeed) {
                if (this.getStillCount() > 10) {
                    this.func_70106_y();
                    this.setStillCount((byte)(this.getStillCount() + 1));
                }
            } else {
                this.setStillCount((byte)0);
            }
        }
    }

    public void updateRiderPosition(double velocity) {
        this.updateRiders(false, velocity);
    }

    protected void updateRiders(boolean atDestination, double velocity) {
        if (this.field_70128_L) {
            return;
        }
        this.updatePotentialRiders(velocity);
        if (atDestination) {
            this.unmountRiders();
            return;
        }
        this.updateConfirmedRiders(velocity);
    }

    protected void updatePotentialRiders(double velocity) {
        ArrayList potentialRiders = new ArrayList();
        AxisAlignedBB boundBox = this.func_70046_E().func_72317_d(0.0, 0.5, 0.0);
        potentialRiders.addAll(this.field_70170_p.func_72839_b((Entity)this, boundBox));
        for (Entity rider : potentialRiders) {
            if (rider instanceof EntityElevatorPart || rider instanceof EntityMasterElevator || rider.func_70115_ae() || this.confirmedRiders.contains(rider) || rider instanceof EntityPlayer && ((EntityPlayer)rider).field_71075_bZ.field_75100_b) continue;
            double yPos = this.field_70163_u + this.func_70042_X() - rider.field_70121_D.field_72338_b;
            rider.field_70181_x = velocity < 0.0 ? velocity : Math.max(yPos, rider.field_70181_x);
            rider.field_70160_al = false;
            rider.field_70122_E = true;
            rider.field_70143_R = 0.0f;
            this.confirmedRiders.add(rider);
        }
    }

    public AxisAlignedBB func_70046_E() {
        return AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 0.5), (double)(this.field_70163_u - 0.5), (double)(this.field_70161_v - 0.5), (double)(this.field_70165_t + 0.5), (double)(this.field_70163_u + 0.5), (double)(this.field_70161_v + 0.5));
    }

    protected boolean isRiding(Entity rider) {
        return rider != null && !rider.func_70115_ae() && rider.field_70121_D.field_72336_d >= this.func_70046_E().field_72340_a && rider.field_70121_D.field_72340_a <= this.func_70046_E().field_72336_d && rider.field_70121_D.field_72334_f >= this.func_70046_E().field_72339_c && rider.field_70121_D.field_72339_c <= this.func_70046_E().field_72334_f && rider.field_70121_D.field_72338_b <= this.field_70163_u + this.func_70042_X() + 0.5;
    }

    protected void updateConfirmedRiders(double velocity) {
        if (!this.confirmedRiders.isEmpty()) {
            Iterator<Entity> entities = this.confirmedRiders.iterator();
            while (entities.hasNext()) {
                Entity rider = entities.next();
                if (this.isRiding(rider)) {
                    double yPos = this.field_70163_u + this.func_70042_X() - rider.field_70121_D.field_72338_b;
                    double yDif = Math.abs(this.field_70163_u + this.func_70042_X() - rider.field_70121_D.field_72338_b);
                    if (yDif < 1.0) {
                        rider.field_70181_x = velocity < 0.0 ? velocity : Math.max(yPos, rider.field_70181_x);
                    } else {
                        rider.func_70091_d(0.0, yPos, 0.0);
                        rider.field_70181_x = velocity;
                    }
                    rider.field_70160_al = true;
                    rider.field_70122_E = true;
                    rider.field_70143_R = 0.0f;
                    continue;
                }
                entities.remove();
            }
        }
    }

    protected void unmountRiders() {
        for (Entity rider : this.confirmedRiders) {
            if (rider == null) continue;
            rider.field_70121_D.func_72317_d(0.0, this.func_70042_X(), 0.0);
            rider.field_70163_u = this.func_70046_E().field_72337_e + this.func_70042_X() + (double)rider.field_70129_M;
            rider.field_70160_al = false;
            rider.field_70122_E = true;
            rider.field_70143_R = 0.0f;
        }
    }

    public double func_70042_X() {
        return 0.5;
    }

    public int getElevatorYOffset() {
        return this.elevatorYOffset;
    }

    public void setElevatorYOffset(int elevatorYOffset) {
        this.elevatorYOffset = elevatorYOffset;
    }

    public void setParentElevator(EntityMasterElevator entityMasterElevator) {
        this.entityElevatorObj = entityMasterElevator;
    }

    public void setArrived() {
        this.func_70096_w().func_75692_b(6, (Object)1);
    }

    public Boolean hasArrived() {
        return this.func_70096_w().func_75679_c(6) == 1;
    }
}

