/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.entities;

import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.dynamictransport.entities.EntityElevatorPart;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevatorComputer;
import net.slimevoid.library.util.helpers.BlockHelper;
import net.slimevoid.library.util.helpers.ChatHelper;

public class EntityMasterElevator
extends Entity {
    protected static final float elevatorAccel = 0.01f;
    protected static final float minElevatorMovingSpeed = 0.016f;
    private ChunkCoordinates computerPos;
    private boolean canBeHalted;
    private boolean slowingDown;
    private int startStops;
    private HashSet<EntityElevatorPart> parts;
    private String elevatorName;
    private String destFloorName;

    public EntityMasterElevator(World world) {
        super(world);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.field_70144_Y = 1.0f;
        this.field_70158_ak = true;
        this.func_70105_a(0.0f, 0.0f);
        this.parts = new HashSet();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70145_X = true;
    }

    public EntityMasterElevator(World world, double x, double y, double z) {
        this(world);
        this.field_70169_q = x + 0.5;
        this.field_70167_r = y + 0.5;
        this.field_70166_s = z + 0.5;
        this.func_70107_b(this.field_70169_q, this.field_70167_r, this.field_70166_s);
        this.setWaitToAccelerate((byte)0);
    }

    public void setProperties(int destination, String destinationName, float elevatorTopSpeed, ChunkCoordinates computer, boolean haltable, List<ChunkCoordinates> elevatorParts) {
        this.setDestinationY(destination);
        this.destFloorName = destinationName != null && !destinationName.trim().equals("") ? destinationName : String.valueOf(destination);
        this.computerPos = computer;
        this.canBeHalted = haltable;
        for (ChunkCoordinates elevatorPart : elevatorParts) {
            EntityElevatorPart part = new EntityElevatorPart(this.field_70170_p, this, elevatorPart.field_71574_a, (double)elevatorPart.field_71572_b + this.field_70163_u, elevatorPart.field_71573_c);
            this.field_70170_p.func_72838_d((Entity)part);
            this.parts.add(part);
        }
        this.setMaximumSpeed(elevatorTopSpeed);
        this.setWaitToAccelerate((byte)0);
    }

    protected void func_70088_a() {
        this.func_70096_w().func_75682_a(2, (Object)-1);
        this.func_70096_w().func_75682_a(3, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_75682_a(4, (Object)0);
        this.func_70096_w().func_75682_a(5, (Object)0);
    }

    public int getDestinationY() {
        return this.func_70096_w().func_75679_c(2);
    }

    protected void setDestinationY(int destinationY) {
        this.func_70096_w().func_75692_b(2, (Object)destinationY);
    }

    public float getMaximumSpeed() {
        return this.func_70096_w().func_111145_d(3);
    }

    protected void setMaximumSpeed(float speed) {
        this.func_70096_w().func_75692_b(3, (Object)Float.valueOf(speed));
    }

    public byte getWaitToAccelerate() {
        return this.func_70096_w().func_75683_a(4);
    }

    public void setWaitToAccelerate(byte value) {
        this.func_70096_w().func_75692_b(4, (Object)value);
    }

    public boolean getEmerHalt() {
        return this.field_70180_af.func_75683_a(5) == 1;
    }

    public void setEmerHalt(boolean b) {
        this.field_70180_af.func_75692_b(5, (Object)(b ? (byte)1 : 0));
    }

    public void func_70106_y() {
        for (EntityElevatorPart part : this.parts) {
            part.setDead(this.getParentElevatorComputerPos());
        }
        if (!this.field_70170_p.field_72995_K && MathHelper.func_76128_c((double)this.field_70163_u) == this.getDestinationY()) {
            if (this.elevatorName != null && !this.elevatorName.trim().equals("")) {
                ChatHelper.sendChatMessageToAllNear((World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (int)4, (String)"slimevoid.DT.entityElevator.arriveWithName", (Object[])new Object[]{this.elevatorName, this.destFloorName});
            } else {
                ChatHelper.sendChatMessageToAllNear((World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v), (int)4, (String)"slimevoid.DT.entityElevator.arrive", (Object[])new Object[]{this.destFloorName});
            }
            TileEntityElevatorComputer computer = this.getParentElevatorComputer();
            if (computer != null) {
                computer.elevatorArrived(this.getDestinationY());
            }
        }
        super.func_70106_y();
    }

    public void func_70071_h_() {
        boolean moving;
        super.func_70071_h_();
        boolean bl = moving = this.getDestinationY() != -1;
        if (moving) {
            this.moveElevator();
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean removeElevators = this.field_70173_aa == 1;
            boolean setTransit = this.field_70173_aa % 10 == 0;
            for (EntityElevatorPart part : this.parts) {
                if (removeElevators) {
                    part.removeElevatorBlock();
                }
                part.setTransitBlocks();
                if (!moving) continue;
                part.field_70181_x = this.field_70181_x;
                part.updateRiderPosition(this.field_70181_x);
                part.checkMotion(this.field_70181_x, this.getMinElevatorMovingSpeed());
                part.func_70091_d(0.0, this.field_70181_x, 0.0);
            }
        }
    }

    protected void moveElevator() {
        boolean atDestination;
        if (this.field_70133_I) {
            this.field_70133_I = false;
            this.setEmerHalt(!this.getEmerHalt());
            ++this.startStops;
            if (this.startStops > 2) {
                this.func_70106_y();
            }
        }
        float destinationY = (float)this.getDestinationY() + 0.5f;
        float elevatorSpeed = (float)Math.abs(this.field_70181_x);
        if (this.getEmerHalt()) {
            elevatorSpeed = 0.0f;
        } else if (this.getWaitToAccelerate() < 15) {
            elevatorSpeed = this.getWaitToAccelerate() < 10 ? 0.0f : 0.016f;
            this.setWaitToAccelerate((byte)(this.getWaitToAccelerate() + 1));
        } else {
            float tempSpeed = Math.min(elevatorSpeed + 0.01f, this.getMaximumSpeed());
            if (!this.slowingDown && MathHelper.func_76135_e((float)((float)((double)destinationY - this.field_70163_u))) >= (tempSpeed * tempSpeed - 2.5600003E-4f) / 0.02f) {
                elevatorSpeed = tempSpeed;
            } else {
                elevatorSpeed -= 0.01f;
                this.slowingDown = true;
            }
            elevatorSpeed = Math.max(Math.min(elevatorSpeed, this.getMaximumSpeed()), 0.016f);
        }
        boolean bl = atDestination = this.field_70122_E || MathHelper.func_76135_e((float)((float)((double)destinationY - this.field_70163_u))) < elevatorSpeed || destinationY < 1.0f || destinationY > (float)this.field_70170_p.func_72800_K();
        if (!atDestination) {
            this.field_70181_x = (double)destinationY > this.field_70163_u ? (double)elevatorSpeed : (double)(-elevatorSpeed);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("destY", this.getDestinationY());
        if (this.destFloorName != null && !this.destFloorName.trim().isEmpty()) {
            nbttagcompound.func_74778_a("destName", this.destFloorName);
        }
        nbttagcompound.func_74757_a("emerHalt", this.getEmerHalt());
        nbttagcompound.func_74768_a("ComputerX", this.computerPos.field_71574_a);
        nbttagcompound.func_74768_a("ComputerY", this.computerPos.field_71572_b);
        nbttagcompound.func_74768_a("ComputerZ", this.computerPos.field_71573_c);
        nbttagcompound.func_74776_a("TopSpeed", this.getMaximumSpeed());
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setDestinationY(nbttagcompound.func_74762_e("destY"));
        this.setMaximumSpeed(nbttagcompound.func_74760_g("TopSpeed"));
        this.setEmerHalt(nbttagcompound.func_74767_n("emerHalt"));
        this.destFloorName = nbttagcompound.func_74779_i("destName");
        this.computerPos = new ChunkCoordinates(nbttagcompound.func_74762_e("ComputerX"), nbttagcompound.func_74762_e("ComputerY"), nbttagcompound.func_74762_e("ComputerZ"));
    }

    protected TileEntityElevatorComputer getParentElevatorComputer() {
        TileEntityElevatorComputer computer = null;
        if (this.computerPos != null) {
            computer = (TileEntityElevatorComputer)((Object)BlockHelper.getTileEntity((IBlockAccess)this.field_70170_p, (int)this.computerPos.field_71574_a, (int)this.computerPos.field_71572_b, (int)this.computerPos.field_71573_c, TileEntityElevatorComputer.class));
        }
        return computer;
    }

    protected ChunkCoordinates getParentElevatorComputerPos() {
        return this.computerPos;
    }

    public float getMinElevatorMovingSpeed() {
        return 0.016f;
    }
}

