/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.network.packet;

import net.minecraft.world.World;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevatorComputer;
import net.slimevoid.dynamictransport.tileentity.TileEntityFloorMarker;
import net.slimevoid.library.network.PacketGuiEvent;
import net.slimevoid.library.network.PacketPayload;

public class PacketMarkerData
extends PacketGuiEvent {
    public PacketMarkerData() {
        this.setChannel("DYNAMICTRANSPORT");
    }

    public PacketMarkerData(int guiid, int destY, String floorname, int compX, int compY, int compZ, int commandType) {
        this();
        this.payload = new PacketPayload(1, 0, 1, 0);
        this.setGuiID(guiid);
        switch (commandType) {
            case 0: {
                this.setCommand("call");
                break;
            }
            case 1: {
                this.setCommand("configMarker");
            }
        }
        this.setDestinationY(destY);
        this.setFloorName(floorname == null || floorname.equals("") ? "none" : floorname);
        this.xPosition = compX;
        this.yPosition = compY;
        this.zPosition = compZ;
    }

    public void setDestinationY(int destinationY) {
        this.payload.setIntPayload(0, destinationY);
    }

    public int getDestinationY() {
        return this.payload.getIntPayload(0);
    }

    public void setFloorName(String floorname) {
        this.payload.setStringPayload(0, floorname);
    }

    public String getFloorName() {
        return this.payload.getStringPayload(0);
    }

    public boolean targetExists(World world) {
        if (this.command.equals("call")) {
            return world.func_147438_o(this.xPosition, this.yPosition, this.zPosition) instanceof TileEntityElevatorComputer;
        }
        if (this.command.equals("configMarker")) {
            return world.func_147438_o(this.xPosition, this.yPosition, this.zPosition) instanceof TileEntityFloorMarker;
        }
        return false;
    }
}

