/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.slimevoid.dynamictransport.core.DynamicTransportMod;
import net.slimevoid.dynamictransport.core.lib.ConfigurationLib;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevatorComputer;
import net.slimevoid.dynamictransport.tileentity.TileEntityTransportBase;
import net.slimevoid.library.blocks.BlockBase;
import net.slimevoid.library.util.helpers.ChatHelper;

public class TileEntityElevator
extends TileEntityTransportBase {
    private ChunkCoordinates ParentElevatorComputer;
    private int yOffset = 0;
    private int maxY = -1;
    private int minY = -1;
    private short overlay = 0;

    public int getMaxY(boolean reCalculate) {
        if (reCalculate || this.maxY == -1) {
            for (int y = this.field_145848_d; y < this.field_145850_b.func_72940_L(); ++y) {
                if (this.field_145850_b.func_147437_c(this.field_145851_c, y + 1, this.field_145849_e) && y != this.field_145850_b.func_72940_L()) continue;
                this.maxY = y;
                break;
            }
        }
        return this.maxY;
    }

    public int getMinY(boolean reCalculate) {
        if (reCalculate || this.minY == -1) {
            for (int y = this.field_145848_d; y >= 0; --y) {
                if (this.field_145850_b.func_147437_c(this.field_145851_c, y - 1, this.field_145849_e) && y != 0) continue;
                this.minY = y;
                break;
            }
        }
        return this.minY;
    }

    public boolean onBlockActivated(EntityPlayer entityplayer, int side, float xHit, float yHit, float zHit) {
        if (this.func_145831_w().field_72995_K) {
            return true;
        }
        short digitLoc = (short)Math.pow(2.0, side);
        ItemStack heldItem = entityplayer.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == ConfigurationLib.itemElevatorTool) {
            if (heldItem.func_77942_o() && entityplayer.func_70694_bm().func_77978_p() != null) {
                NBTTagCompound tags = entityplayer.func_70694_bm().func_77978_p();
                if (tags != null && tags.func_74764_b("ComputerX")) {
                    ChunkCoordinates possibleComputer = new ChunkCoordinates(tags.func_74762_e("ComputerX"), tags.func_74762_e("ComputerY"), tags.func_74762_e("ComputerZ"));
                    if (entityplayer.func_70093_af()) {
                        if (possibleComputer.equals((Object)this.ParentElevatorComputer)) {
                            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorBlock.unbound", (Object[])new Object[0]);
                            this.getParentElevatorComputer().RemoveElevatorBlock(new ChunkCoordinates(this.field_145851_c, this.getYOffest(), this.field_145849_e));
                            this.RemoveComputer(possibleComputer);
                            return true;
                        }
                        if (this.ParentElevatorComputer != null) {
                            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorBlock.boundToOtherComputer", (Object[])new Object[0]);
                        }
                    } else if (this.getParent() == null) {
                        this.setParentElevatorComputer(possibleComputer, entityplayer);
                    } else if (possibleComputer.equals((Object)this.getParent())) {
                        this.overlay = (this.overlay & digitLoc) == digitLoc ? (short)(this.overlay & ~digitLoc & 0x7F) : (short)(this.overlay | digitLoc);
                        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        return true;
                    }
                }
            } else {
                FMLCommonHandler.instance().getFMLLogger().warn("There was an error processing this Transport Component at [" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + "]");
            }
        }
        if (!this.isInMaintenanceMode() && (this.overlay & digitLoc) == digitLoc) {
            entityplayer.openGui((Object)DynamicTransportMod.instance, 2, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return super.onBlockActivated(entityplayer);
    }

    public void setParentElevatorComputer(ChunkCoordinates ComputerLocation) {
        TileEntityElevatorComputer comTile;
        TileEntityElevatorComputer tileEntityElevatorComputer = comTile = this.ParentElevatorComputer == null ? null : (TileEntityElevatorComputer)this.field_145850_b.func_147438_o(this.ParentElevatorComputer.field_71574_a, this.ParentElevatorComputer.field_71572_b, this.ParentElevatorComputer.field_71573_c);
        if (comTile == null) {
            this.ParentElevatorComputer = null;
        }
        if (this.field_145850_b.func_147439_a(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c) == ConfigurationLib.blockTransportBase && this.field_145850_b.func_72805_g(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c) == 1) {
            this.ParentElevatorComputer = ComputerLocation;
        }
    }

    public void setParentElevatorComputer(ChunkCoordinates ComputerLocation, EntityPlayer entityplayer) {
        TileEntityElevatorComputer comTile;
        TileEntityElevatorComputer tileEntityElevatorComputer = comTile = this.ParentElevatorComputer == null ? null : (TileEntityElevatorComputer)this.field_145850_b.func_147438_o(this.ParentElevatorComputer.field_71574_a, this.ParentElevatorComputer.field_71572_b, this.ParentElevatorComputer.field_71573_c);
        if (comTile == null) {
            this.ParentElevatorComputer = null;
        }
        if (this.field_145850_b.func_147439_a(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c) == ConfigurationLib.blockTransportBase && this.field_145850_b.func_72805_g(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c) == 1) {
            comTile = (TileEntityElevatorComputer)this.field_145850_b.func_147438_o(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c);
            if (comTile.addElevator(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e), entityplayer)) {
                this.ParentElevatorComputer = ComputerLocation;
            }
            this.yOffset = this.field_145848_d - (ComputerLocation.field_71572_b + 1);
        } else {
            ItemStack heldItem = entityplayer.func_70694_bm();
            NBTTagCompound tags = new NBTTagCompound();
            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.elevatorBlock.bindMissingElevator", (Object[])new Object[0]);
            heldItem.func_77982_d(tags);
        }
        this.updateBlock();
    }

    public boolean removeBlockByPlayer(EntityPlayer player, BlockBase blockBase) {
        TileEntityElevatorComputer comTile;
        TileEntityElevatorComputer tileEntityElevatorComputer = comTile = this.ParentElevatorComputer == null ? null : (TileEntityElevatorComputer)this.field_145850_b.func_147438_o(this.ParentElevatorComputer.field_71574_a, this.ParentElevatorComputer.field_71572_b, this.ParentElevatorComputer.field_71573_c);
        if (comTile != null) {
            comTile.RemoveElevatorBlock(new ChunkCoordinates(this.field_145851_c, this.getYOffest(), this.field_145849_e));
        }
        return super.removeBlockByPlayer(player, blockBase);
    }

    public ChunkCoordinates getParent() {
        return this.ParentElevatorComputer;
    }

    public TileEntityElevatorComputer getParentElevatorComputer() {
        TileEntity tile;
        TileEntity tileEntity = tile = this.ParentElevatorComputer == null ? null : this.field_145850_b.func_147438_o(this.ParentElevatorComputer.field_71574_a, this.ParentElevatorComputer.field_71572_b, this.ParentElevatorComputer.field_71573_c);
        if (tile == null) {
            this.ParentElevatorComputer = null;
        } else if (!(tile instanceof TileEntityElevatorComputer)) {
            tile = null;
            this.ParentElevatorComputer = null;
        }
        return (TileEntityElevatorComputer)tile;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.ParentElevatorComputer != null) {
            nbttagcompound.func_74768_a("ParentElevatorComputerX", this.ParentElevatorComputer.field_71574_a);
            nbttagcompound.func_74768_a("ParentElevatorComputerY", this.ParentElevatorComputer.field_71572_b);
            nbttagcompound.func_74768_a("ParentElevatorComputerZ", this.ParentElevatorComputer.field_71573_c);
            nbttagcompound.func_74768_a("yOffset", this.yOffset);
            nbttagcompound.func_74777_a("overLay", this.overlay);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.ParentElevatorComputer = new ChunkCoordinates(nbttagcompound.func_74762_e("ParentElevatorComputerX"), nbttagcompound.func_74762_e("ParentElevatorComputerY"), nbttagcompound.func_74762_e("ParentElevatorComputerZ"));
        this.yOffset = nbttagcompound.func_74762_e("yOffset");
        this.overlay = nbttagcompound.func_74765_d("overLay");
    }

    public void RemoveComputer(ChunkCoordinates chunkCoordinates) {
        this.ParentElevatorComputer = null;
        this.updateBlock();
    }

    public int getExtendedBlockID() {
        return 0;
    }

    @Override
    protected boolean isInMaintenanceMode() {
        return this.getParentElevatorComputer() == null || this.getParentElevatorComputer().isInMaintenanceMode();
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public int getYOffest() {
        return this.yOffset;
    }

    public String getInvName() {
        return "dt.transport.elevator";
    }

    public short getOverlay() {
        return this.overlay;
    }

    public void setOverlay(Short overlay) {
        this.overlay = overlay;
    }
}

