/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.tileentity;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.slimevoid.dynamictransport.core.lib.ConfigurationLib;
import net.slimevoid.library.blocks.BlockBase;
import net.slimevoid.library.tileentity.TileEntityBase;
import net.slimevoid.library.util.helpers.ItemHelper;

public abstract class TileEntityTransportBase
extends TileEntityBase {
    protected ItemStack camoItem;
    protected String owner;
    protected Privacy privacyLvl = Privacy.Public;

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.camoItem != null) {
            NBTTagCompound itemNBTTagCompound = new NBTTagCompound();
            this.camoItem.func_77955_b(itemNBTTagCompound);
            nbttagcompound.func_74782_a("CamoItem", (NBTBase)itemNBTTagCompound);
        }
        if (this.owner != null && !this.owner.isEmpty()) {
            nbttagcompound.func_74778_a("Owner", this.owner);
        }
        nbttagcompound.func_74768_a("PrivacyLvl", this.privacyLvl.ordinal());
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.camoItem = nbttagcompound.func_74764_b("CamoItem") ? ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("CamoItem")) : null;
        this.owner = nbttagcompound.func_74779_i("Owner");
        this.privacyLvl = Privacy.values()[nbttagcompound.func_74762_e("PrivacyLvl")];
    }

    public float getBlockHardness(BlockBase blockBase) {
        return 1.0f;
    }

    public boolean onBlockActivated(EntityPlayer entityplayer) {
        if (this.func_145831_w().field_72995_K) {
            return true;
        }
        if (this.isInMaintenanceMode()) {
            ItemStack heldItem = entityplayer.func_70694_bm();
            if (this.getCamoItem() == null && ItemHelper.isSolidBlockStack((ItemStack)heldItem, (World)this.func_145831_w(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)) {
                this.setCamoItem(heldItem.func_77946_l());
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a < 0) {
                        heldItem = null;
                    }
                }
                return true;
            }
            if (this.getCamoItem() != null && entityplayer.func_70694_bm() == null) {
                this.removeCamoItem();
                return true;
            }
        }
        return false;
    }

    public ItemStack getCamoItem() {
        return this.camoItem;
    }

    public void setCamoItem(ItemStack itemstack) {
        this.camoItem = itemstack;
        this.camoItem.field_77994_a = 1;
        this.updateBlock();
        this.func_145831_w().func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ConfigurationLib.blockTransportBase);
    }

    protected void removeCamoItem() {
        ItemHelper.dropItem((World)this.func_145831_w(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ItemStack)this.camoItem);
        this.camoItem = null;
        this.updateBlock();
    }

    public ItemStack removeCamoItemWithoutDrop() {
        ItemStack copyCamoItem = null;
        if (this.camoItem != null) {
            copyCamoItem = this.camoItem.func_77946_l();
            this.camoItem = null;
            this.onInventoryChanged();
        }
        return copyCamoItem;
    }

    protected abstract boolean isInMaintenanceMode();

    protected void addHarvestContents(ArrayList<ItemStack> harvestList) {
        if (this.camoItem != null) {
            harvestList.add(this.camoItem);
        }
    }

    public int getLightValue() {
        return this.camoItem == null ? 0 : Block.func_149634_a((Item)this.camoItem.func_77973_b()).func_149750_m();
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.camoItem;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.camoItem = itemstack;
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 && ItemHelper.isBlockStack((ItemStack)itemstack);
    }

    public static enum Privacy {
        Public,
        Restricted,
        Private;

    }
}

